package com.tydic.dyc.agr.repository;

import com.tydic.dyc.agr.model.sysDicDictionary.SysDicDictionaryDo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.AgrDictionaryRspBo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.SysDicDictionaryRspBo;

import java.util.List;

/**
 * @Description: AgrDictionaryRepository
 * @Author: the_xhl
 * @Date: 2023-07-27
 */
public interface AgrDictionaryRepository {

    /**
     * 根据PCode集合查询字典
     *
     * @param pCodeList pCodeList
     * @return {@link List}<{@link DicDictionaryBo}>
     */
    List<DicDictionaryBo> selectByPCodeList(List<String> pCodeList);

    SysDicDictionaryDo getDictionaryByDo(SysDicDictionaryDo dicDictionaryDo);

    void addDicDictionary(SysDicDictionaryDo sysDicDictionaryDo);

    void deleteDicDictionary(SysDicDictionaryDo dicDictionaryBO);

    AgrDictionaryRspBo queryBypCodeBackMap(SysDicDictionaryDo sysDicDictionaryDo);

    SysDicDictionaryRspBo queryBypCodeBackPo(SysDicDictionaryDo dicDictionaryDo);

    void updateDicDictionary(SysDicDictionaryDo dicDictionaryBO);
}
