package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckAgrAppScopeReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckAgrAppScopeRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckScopeBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName AgrCheckAgrAppScopeServiceImpl
 * @Author 14051
 * @Date 2024/3/4 15:37
 * @Version 1.0
 * @Description 根据协议ID集合校验是否满足所给的应用范围实现类
 **/
@HTServiceImpl
public class AgrCheckAgrAppScopeServiceImpl implements AgrCheckAgrAppScopeService{

    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrCheckAgrAppScopeRspBO checkAgrAppScope(AgrCheckAgrAppScopeReqBO reqBO) {
        validParam(reqBO);
        List<AgrCheckScopeBO> agrCheckScopeBOS = new ArrayList<>();
        //根据入参查询协议名称放到map
        Map<Long, String> agrMap = new HashMap<>();
        AgrAgrQryBo qryAgrMainList = new AgrAgrQryBo();
        qryAgrMainList.setAgrIds(reqBO.getAgrIds());
        qryAgrMainList.setPageNo(-1);
        qryAgrMainList.setPageSize(-1);
        AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = iAgrAgrModel.getAgrMainList(qryAgrMainList);
        if (!CollectionUtils.isEmpty(agrGetAgrMainListRspQryBo.getRows())){
            agrMap = agrGetAgrMainListRspQryBo.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, AgrAgrDo::getAgrName));
        }
        //第一步查询全平台后过滤的
        List<Long> otherAgrIds = new ArrayList<>();
        //第二步根据指定范围ID查询后过滤的
        List<Long> lastAgrIds = new ArrayList<>();
        //先查询是全平台的应用范围，返回true
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrIds(reqBO.getAgrIds());
        agrAgrQryBo.setScopeType(AgrCommConstant.ScopeType.ALL);
        List<AgrAppScope> agrAppScopes = iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
        if (!CollectionUtils.isEmpty(agrAppScopes)) {
            agrAppScopes.forEach(bo -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrId(bo.getAgrId());
                agrCheckScopeBO.setCheckFlag(true);
                agrCheckScopeBOS.add(agrCheckScopeBO);
            });

            //过滤剩下的协议ID，放入otherAgrIds集合
            otherAgrIds = reqBO.getAgrIds().stream()
                    .filter(agrId -> agrAppScopes.stream().noneMatch(a -> a.getAgrId().equals(agrId)))
                    .collect(Collectors.toList());
        } else {
            //未查询到全平台范围的则放入入参集合
            otherAgrIds = reqBO.getAgrIds();
        }
        //根据指定范围ID查询
        if (!CollectionUtils.isEmpty(otherAgrIds)){
            agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrIds(otherAgrIds);
            agrAgrQryBo.setScopeCode(reqBO.getScopeId().toString());
            List<AgrAppScope> otherAgrAppScopes = iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
            if (!CollectionUtils.isEmpty(otherAgrAppScopes)){
                otherAgrAppScopes.forEach(bo ->{
                    AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                    agrCheckScopeBO.setAgrId(bo.getAgrId());
                    agrCheckScopeBO.setCheckFlag(true);
                    agrCheckScopeBOS.add(agrCheckScopeBO);
                });

                lastAgrIds = otherAgrIds.stream()
                        .filter(agrId -> otherAgrAppScopes.stream().noneMatch(a -> a.getAgrId().equals(agrId)))
                        .collect(Collectors.toList());
            } else {
                lastAgrIds = otherAgrIds;
            }
        }

        if (!CollectionUtils.isEmpty(lastAgrIds)){
            lastAgrIds.forEach(agrId ->{
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrId(agrId);
                agrCheckScopeBO.setCheckFlag(false);
                agrCheckScopeBOS.add(agrCheckScopeBO);
            });
        }
        //协议名称赋值
        for (AgrCheckScopeBO bo : agrCheckScopeBOS) {
            if (agrMap != null && agrMap.containsKey(bo.getAgrId())) {
                bo.setAgrName(agrMap.get(bo.getAgrId()));
            }
        }
        //返回
        AgrCheckAgrAppScopeRspBO rspBO = new AgrCheckAgrAppScopeRspBO();
        rspBO.setRows(agrCheckScopeBOS);
        return rspBO;
    }

    private void validParam(AgrCheckAgrAppScopeReqBO reqBO){
        if (reqBO == null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_OBJ_EMPTY_ERROR, "入参对象为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getAgrIds())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参协议ID集合为空！");
        }
        if (reqBO.getScopeId() == null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参范围ID为空！");
        }
    }
}
