package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrCodeReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrCodeRspBO;
import com.tydic.plugin.encoded.constant.CfcEncodedPluginCommonConstant;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @title:AgrGetAgrCodeServiceImpl
 * @describe：协议编号生成服务实现
 * @created: 2022/8/29 16:16
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrGetAgrCodeServiceImpl implements AgrGetAgrCodeService{
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @Override
    public AgrGetAgrCodeRspBO getAgrCode(AgrGetAgrCodeReqBO reqBO) {
        //定义出参
        AgrGetAgrCodeRspBO rsp = new AgrGetAgrCodeRspBO();

        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("AGR");
        encodedSerialGetServiceReqBO.setRelType(CfcEncodedPluginCommonConstant.EncodedSerialRelType.ORG);
        //是否向上继承
        encodedSerialGetServiceReqBO.setExtendFlag(CfcEncodedPluginCommonConstant.EncodedSerialExtendFlag.VALID);
        //如果向上继承需要穿org路径 反之传 orgId
        encodedSerialGetServiceReqBO.setRelId(reqBO.getOrgPath()+"");
        if(StringUtils.isEmpty(reqBO.getEncodedRuleCode())){
            encodedSerialGetServiceReqBO.setEncodedRuleCode("ARG_AGREEMENT_CODE");
        }else {
            encodedSerialGetServiceReqBO.setEncodedRuleCode(reqBO.getEncodedRuleCode());
        }
        List<String> replaceValue = new ArrayList<>();
        replaceValue.add(reqBO.getAgrCode());
        encodedSerialGetServiceReqBO.setReplaceValue(replaceValue);
        String rspString = JSONObject.toJSONString(encodedSerialGetServiceReqBO);
        log.debug("获取协议编码入参="+rspString);
        CfcEncodedSerialGetServiceRspBO encodedSerial = encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        String plaAgreementCode="";
        if(encodedSerial!=null){
            List<String> serialNoList = encodedSerial.getSerialNoList();
            if(!CollectionUtils.isEmpty(serialNoList)){
                plaAgreementCode = serialNoList.get(0);
                rsp.setPlaAgreementCode(plaAgreementCode);
            }

        }
        return rsp;
    }
}
