package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.service.agr.bo.AgrUnifyTodoQryAbilityReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUnifyTodoQryAbilityRspBO;
import com.tydic.dyc.agr.service.auditorder.bo.AgrGetAuditToDoInfoReqBO;
import com.tydic.dyc.agr.service.auditorder.bo.AgrGetAuditToDoInfoRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class AgrUnifyTodoQryAbilityServiceImpl implements AgrUnifyTodoQryAbilityService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;
    @Override
    public AgrUnifyTodoQryAbilityRspBO qryTodoInfo(AgrUnifyTodoQryAbilityReqBO reqBO) {
        AgrUnifyTodoQryAbilityRspBO rspBO = AgrRu.success(AgrUnifyTodoQryAbilityRspBO.class);
        String checkResult = check(reqBO);
        if (!StringUtils.isEmpty(checkResult)){
            throw new ZTBusinessException(checkResult);
        }
        //单据类型  1：协议单     2：协议变更单     9：审批单
        switch (reqBO.getObjType()){
            case 1:
                getAgrInfo(reqBO.getObjId(),rspBO);
                if (!StringUtils.isEmpty(rspBO.getParamJson())){
                    JSONObject paramJson = JSONObject.parseObject(rspBO.getParamJson());
                    paramJson.put("confirmType","1");
                    rspBO.setParamJson(JSONObject.toJSONString(paramJson));
                }
                break;
            case 2:
                //查询协议变更单信息
                getAgrChngInfo(reqBO.getObjId(),rspBO);
                if (!StringUtils.isEmpty(rspBO.getParamJson())){
                    JSONObject paramJson = JSONObject.parseObject(rspBO.getParamJson());
                    paramJson.put("confirmType","2");
                    rspBO.setParamJson(JSONObject.toJSONString(paramJson));
                }
                break;
            case 9:
                //查询审批单信息
                AgrGetAuditToDoInfoReqBO agrGetAuditToDoInfoReqBO = new AgrGetAuditToDoInfoReqBO();
                agrGetAuditToDoInfoReqBO.setObjId(reqBO.getObjId());
                AgrGetAuditToDoInfoRspBO agrGetAuditToDoInfoRspBO = iAgrAuditOrderModel.getAuditTodoInfo(agrGetAuditToDoInfoReqBO);
                if (agrGetAuditToDoInfoRspBO!=null){
                    if (AgrCommConstant.ObjType.AGREEMENT.equals(agrGetAuditToDoInfoRspBO.getDataType())) {
                        //查询协议信息
                        getAgrInfo(agrGetAuditToDoInfoRspBO.getAgrId(),rspBO);
                    } else if (AgrCommConstant.ObjType.CHANGE.equals(agrGetAuditToDoInfoRspBO.getDataType())){
                        //查询协议变更信息
                        getAgrChngInfo(agrGetAuditToDoInfoRspBO.getChngApplyId(),rspBO);
                    }
                    if (!StringUtils.isEmpty(rspBO.getParamJson())){
                        JSONObject paramJson = JSONObject.parseObject(rspBO.getParamJson());
                        paramJson.put("taskId",agrGetAuditToDoInfoRspBO.getTaskId());
                        paramJson.put("procInstId",agrGetAuditToDoInfoRspBO.getProcInstId());
                        paramJson.put("auditOrderCode",agrGetAuditToDoInfoRspBO.getAuditOrderCode());
                        rspBO.setParamJson(JSONObject.toJSONString(paramJson));
                    }
                }
                break;
            default:
                throw new ZTBusinessException("错误的单据类型");
        }
        return rspBO;
    }

    private String check(AgrUnifyTodoQryAbilityReqBO reqBO){
        String checkMsg = "";
        if (reqBO.getShareId()==null){
            checkMsg = "分库键ID不能为空";
        }
        if (reqBO.getObjId()==null){
            checkMsg = "单据ID不能为空";
        }
        if (reqBO.getObjType()==null){
            checkMsg = "单据类型不能为空";
        }
        return checkMsg;
    }

    private void getAgrInfo(Long agrId,AgrUnifyTodoQryAbilityRspBO rspBO){
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrId);
        //查询协议信息
        AgrAgrDo agrAgrDo = iAgrAgrModel.getAgrMain(agrAgrQryBo);
        if (agrAgrDo!=null) {
            rspBO.setObjCreateUserId(agrAgrDo.getCreateLoginId());
            rspBO.setProOrgId(null);
            rspBO.setPurOrgId(agrAgrDo.getPurchaseOrgId());
            rspBO.setSupOrgId(agrAgrDo.getSupplierId());
            JSONObject paramJson = new JSONObject();
            paramJson.put("agrId",agrAgrDo.getAgrId());
            paramJson.put("agrCode",agrAgrDo.getAgrCode());
            paramJson.put("busiObjType",1);
            rspBO.setParamJson(JSONObject.toJSONString(paramJson));
        }else {
            throw new ZTBusinessException("未获取到协议信息");
        }
    }

    private void getAgrChngInfo(Long chngApplyId,AgrUnifyTodoQryAbilityRspBO rspBO){
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
        agrAgrChngApplyQryBo.setChngApplyId(chngApplyId);
        AgrChngApplyDo agrChngApplyDo = iAgrChngApplyModel.getAgrMainChng(agrAgrChngApplyQryBo);
        if (agrChngApplyDo!=null) {
            rspBO.setObjCreateUserId(agrChngApplyDo.getCreateLoginId());
            rspBO.setProOrgId(null);
            if (agrChngApplyDo.getAgrMainChng()!=null) {
                rspBO.setPurOrgId(agrChngApplyDo.getAgrMainChng().getPurchaseOrgId());
                rspBO.setSupOrgId(agrChngApplyDo.getAgrMainChng().getSupplierId());
            }else {
                AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
                agrAgrQryBo.setAgrId(agrChngApplyDo.getAgrId());
                //查询协议信息
                AgrAgrDo agrAgrDo = iAgrAgrModel.getAgrMain(agrAgrQryBo);
                rspBO.setPurOrgId(agrAgrDo.getPurchaseOrgId());
                rspBO.setSupOrgId(agrAgrDo.getSupplierId());
            }
            JSONObject paramJson = new JSONObject();
            paramJson.put("agrId",agrChngApplyDo.getAgrId());
            paramJson.put("agrCode",agrChngApplyDo.getAgrCode());
            paramJson.put("chngApplyNo",agrChngApplyDo.getChngApplyNo());
            paramJson.put("busiObjType",2);
            rspBO.setParamJson(JSONObject.toJSONString(paramJson));
        }else {
            throw new ZTBusinessException("未获取到协议变更信息");
        }
    }
}
