package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyListRspBO;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrChngApply;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgChngApplyReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgChngApplyRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * @title: AgrCreateArgChngApplyServiceImpl
 * @describe： 协议变更申请新增服务实现
 * @created: 2022/9/9 15:18
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrCreateArgChngApplyServiceImpl implements AgrCreateArgChngApplyService{
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Override
    public AgrCreateArgChngApplyRspBO createAgrChngApply(AgrCreateArgChngApplyReqBO agrCreateArgChngApplyReqBO) {

        //1.入参校验
        this.validation(agrCreateArgChngApplyReqBO);

        AgrCreateArgChngApplyRspBO agrCreateArgChngApplyRspBO = AgrRu.success(AgrCreateArgChngApplyRspBO.class);
        this.getDeleteChng(agrCreateArgChngApplyRspBO,agrCreateArgChngApplyReqBO);

        //组装协议新增入参
        AgrChngApplyDo agrChngApplyDo = JSONObject.parseObject(JSONObject.toJSONString(agrCreateArgChngApplyReqBO),AgrChngApplyDo.class);
        //2.协议变更申请修改
        this.iAgrChngApplyModel.createAgrChngApply(agrChngApplyDo);
        //4 新增协议明细变更信息
        if(!CollectionUtils.isEmpty(agrCreateArgChngApplyReqBO.getAgrItemChng())){
            AgrChngApplyDo agrChngApplyDo1 = JSONObject.parseObject(JSON.toJSONString(agrCreateArgChngApplyReqBO), AgrChngApplyDo.class);
            this.iAgrChngApplyModel.saveAgrItemChng(agrChngApplyDo1);
        }
        // 设置deleteChngApplyId默认值
        if (ObjectUtil.isEmpty(agrCreateArgChngApplyRspBO.getDeleteChngApplyId())) {
            agrCreateArgChngApplyRspBO.setDeleteChngApplyId(1L);
        }

        return  agrCreateArgChngApplyRspBO;
    }
    /**
     * 查询需要删除变更申请
     */
    private void getDeleteChng(AgrCreateArgChngApplyRspBO agrCreateArgChngApplyRspBO ,AgrCreateArgChngApplyReqBO agrCreateArgChngApplyReqBO){
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
        agrAgrChngApplyQryBo.setAgrId(agrCreateArgChngApplyReqBO.getAgrId());
        AgrAgrChngApplyListRspBO rspBO = this.iAgrChngApplyModel.getAgrChngApplyList(agrAgrChngApplyQryBo);
        if(!CollectionUtils.isEmpty(rspBO.getAgrChngApply())){
            for (AgrChngApply agrChngApply:rspBO.getAgrChngApply()) {
                if(AgrCommConstant.ChangeApplyStatus.IN_AUDIT.equals(Integer.parseInt(agrChngApply.getChngApplyStatus()))
                        || AgrCommConstant.ChangeApplyStatus.TO_CONFIRM.equals(Integer.parseInt(agrChngApply.getChngApplyStatus()))){
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "已存在在途变更申请！");
                }else if(AgrCommConstant.ChangeApplyStatus.DRAFT.equals(Integer.parseInt(agrChngApply.getChngApplyStatus()))){
                    agrCreateArgChngApplyRspBO.setDeleteChngApplyId(agrChngApply.getChngApplyId());
                }
            }
        }
    }
    /**
     * 入参校验
     * @param agrCreateArgChngApplyReqBO
     */
    private void validation(AgrCreateArgChngApplyReqBO agrCreateArgChngApplyReqBO) {
        if (ObjectUtil.isEmpty(agrCreateArgChngApplyReqBO)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgChngApplyReqBO.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgChngApplyReqBO.getChngApplyNo())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请编号]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgChngApplyReqBO.getChngType())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议变更类型]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgChngApplyReqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgChngApplyReqBO.getAgrCode())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议编号]不能为空");
        }
        if (ObjectUtil.isEmpty(agrCreateArgChngApplyReqBO.getAgrVersion())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议版本]不能为空");
        }
        if (!CollectionUtils.isEmpty(agrCreateArgChngApplyReqBO.getAgrChngAccessory())) {
            agrCreateArgChngApplyReqBO.getAgrChngAccessory().forEach(agrChngAccessory -> {
                if (ObjectUtil.isEmpty(agrChngAccessory.getAttachmentType())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件类型]不能为空");
                }
                if (ObjectUtil.isEmpty(agrChngAccessory.getAccessoryName())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件名称]不能为空");
                }
                if (ObjectUtil.isEmpty(agrChngAccessory.getAccessoryUrl())) {
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更附件附件url]不能为空");
                }
            });
        }
    }
}
