package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateAgrItemChngRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrDeleteAgrItemChngReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrDeleteAgrItemChngRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@HTServiceImpl
/**
 * @title: AgrDeleteAgrItemChngServiceImpl
 * @describe： 协议明细变更删除服务实现
 * @created: 2022/9/14 17:08
 * @author: FKC
 */
public class AgrDeleteAgrItemChngServiceImpl  implements AgrDeleteAgrItemChngService{
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrDeleteAgrItemChngRspBO deleteAgrItemChng(AgrDeleteAgrItemChngReqBO agrDeleteAgrItemChngReqBO) {
        //1.入参校验
        this.validation(agrDeleteAgrItemChngReqBO);
        //2.组装协议明细变更删除入参
        AgrChngApplyDo agrChngApplyDo = setChngDelInfo(agrDeleteAgrItemChngReqBO);
        //3.调用协议变更申请修改
        this.iAgrChngApplyModel.deleteAgrItemChng(agrChngApplyDo);

        return  AgrRu.success(AgrDeleteAgrItemChngRspBO.class);
    }

    /**
     * 设置协议明细变更删除方法入参
     * @param agrDeleteAgrItemChngReqBO
     */
    private AgrChngApplyDo setChngDelInfo(AgrDeleteAgrItemChngReqBO agrDeleteAgrItemChngReqBO){
        AgrChngApplyDo agrChngApplyDo = JSONObject.parseObject(JSONObject.toJSONString(agrDeleteAgrItemChngReqBO),AgrChngApplyDo.class);
        List<AgrItemChng> agrItemChngs = new ArrayList<>();
        AgrItemChng agrItemChng = new AgrItemChng();
        agrItemChng.setAgrItemChngIds(agrDeleteAgrItemChngReqBO.getAgrItemChngIds());
        agrItemChngs.add(agrItemChng);
        agrChngApplyDo.setAgrItemChng(agrItemChngs);
        return agrChngApplyDo;
    }
    /**
     * 入参校验
     * @param agrDeleteAgrItemChngReqBO 入参
     */
    private void validation(AgrDeleteAgrItemChngReqBO agrDeleteAgrItemChngReqBO) {
        if (ObjectUtil.isEmpty(agrDeleteAgrItemChngReqBO)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrDeleteAgrItemChngReqBO.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrDeleteAgrItemChngReqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
    }
}
