package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.agr.sub.AgrPayConfig;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrPayConfigDetailBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrMainChngDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrMainChngDetailRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrMainChngDetailBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrPayConfigChngBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @title: AgrGetAgrMainChngDetailServiceImpl
 * @describe： 协议主体变更详情查询服务
 * @created: 2022/9/13 17:14
 * @author: FKC
 */
@HTServiceImpl
@Slf4j
public class AgrGetAgrMainChngDetailServiceImpl implements AgrGetAgrMainChngDetailService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;

    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;

    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @Override
    public AgrGetAgrMainChngDetailRspBO getAgrMainChngDetail(AgrGetAgrMainChngDetailReqBO agrGetAgrMainChngDetailReqBO) {
        //1 入参校验
        this.validation(agrGetAgrMainChngDetailReqBO);
        //2 组装协议主体变更详情查询入参
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = JSONObject.parseObject(JSONObject.toJSONString(agrGetAgrMainChngDetailReqBO), AgrAgrChngApplyQryBo.class);
        log.debug("协议主体变更详情查询入参[agrChngApplyDo]:{}", agrAgrChngApplyQryBo);
        //3 协议变更申请修改
        AgrChngApplyDo agrChngApplyDo = this.iAgrChngApplyModel.getAgrMainChngDetail(agrAgrChngApplyQryBo);
        //4 出参类型转换
        AgrGetAgrMainChngDetailRspBO agrGetAgrMainChngDetailRspBO = JSONObject.parseObject(JSONObject.toJSONString(agrChngApplyDo), AgrGetAgrMainChngDetailRspBO.class);
        //5 字段转义
        this.agrMainTransferredMeaning(agrGetAgrMainChngDetailRspBO.getAgrMainChng());
        //6 付款配置转义
        this.agrPayConfTransfer(agrGetAgrMainChngDetailRspBO);
        // 设置流程实例id
        agrGetAgrMainChngDetailRspBO.setProcInstId(this.qryProInstId(agrGetAgrMainChngDetailReqBO.getAgrId(),agrGetAgrMainChngDetailReqBO.getChngApplyId()));
        agrGetAgrMainChngDetailRspBO.setBusiProclnstld(this.qryBusiProInstId(agrGetAgrMainChngDetailReqBO.getAgrId(),agrGetAgrMainChngDetailReqBO.getChngApplyId()));
        return agrGetAgrMainChngDetailRspBO;
    }

    private String qryBusiProInstId(Long agrId,Long chngApplyId) {
        String procInstId = "";
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setOrderId(agrId);
        agrProcInstDo.setObjId(chngApplyId);
        agrProcInstDo.setObjType(AgrCommConstant.ObjType.CHANGE);
        agrProcInstDo.setOrderBy("id desc LIMIT 1");
        AgrProcInstDo agrProcInstDo1 = iAgrProcInstModel.getProcInst(agrProcInstDo);
        if (agrProcInstDo1 != null) {
            procInstId = agrProcInstDo1.getProcInstId();
        }
        return procInstId;
    }
    /**
     * 入参校验
     *
     * @param agrGetAgrMainChngDetailReqBO 入参
     */
    private void validation(AgrGetAgrMainChngDetailReqBO agrGetAgrMainChngDetailReqBO) {
        if (ObjectUtil.isEmpty(agrGetAgrMainChngDetailReqBO)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(agrGetAgrMainChngDetailReqBO.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(agrGetAgrMainChngDetailReqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
    }

    private String qryProInstId(Long agrId,Long chngApplyId) {
        String procInstId = "";
        AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
        agrAuditOrderQryBo.setObjType(AgrCommConstant.ObjType.CHANGE);
        agrAuditOrderQryBo.setObjId(chngApplyId);
        agrAuditOrderQryBo.setOrderId(agrId);
        agrAuditOrderQryBo.setOrderBy("id desc");
        AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
        if (!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())) {
            Long auditOrderId = agrAuditOrderDo.getUocApprovalObj().get(0).getAuditOrderId();
            AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
            agrProcInstDo.setOrderId(agrId);
            agrProcInstDo.setObjId(auditOrderId);
            agrProcInstDo.setObjType(AgrCommConstant.ObjType.APPROVE);
            AgrProcInstDo agrProcInstDo1 = iAgrProcInstModel.getProcInst(agrProcInstDo);
            if (agrProcInstDo1 != null) {
                procInstId = agrProcInstDo1.getProcInstId();
            }
        }
        return procInstId;
    }

    /**
     * 协议主体所需字段转义
     *
     * @return
     */
    private AgrMainChngDetailBo agrMainTransferredMeaning(AgrMainChngDetailBo rspBo) {
        List<String> pCodeList = new ArrayList<>();
        //协议模式转义  协议模式 1：平台协议 2：单位协议 默认1
        if (rspBo.getAgrMode() != null) {
//            rspBo.setAgrModeStr(AgrCommConstant.AgreementModeEnum.getValueByCode(rspBo.getAgrMode()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_MODE_PCODE);
        }
        //协议分类转义 协议分类 0：集团集采协议:1：区域集采协议、2：项目单位协议； 默认值：0：集团集采协议
        if (rspBo.getAgrType() != null) {
//            rspBo.setAgrTypeStr(AgrCommConstant.AgrTypeEnum.getValueByCode(rspBo.getAgrType()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_TYPE_PCODE);
        }
        //协议状态转义  协议状态 0：草稿 1：提交中  2：启用 3：停用
        if (rspBo.getAgrStatus() != null) {
//            rspBo.setAgrStatusStr(AgrCommConstant.AgreementStatusEnum.getNameByValue(rspBo.getAgrStatus()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_STATUS_PCODE);
        }
        //协议价格类型转义 价格类型 1：执行价 2：协议价 默认1
        if (rspBo.getAgrPriceType() != null) {
//            rspBo.setAgrPriceTypeStr(AgrCommConstant.AgrPriceTypeEnum.getValueByCode(rspBo.getAgrPriceType()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_PRICE_TYPE_PCODE);
        }
        //协议来源转义 协议来源：1：手动创建，2.协议合同，3.招投标，4.询比价，5.竞价
        if (rspBo.getAgrSrc() != null) {
//            rspBo.setAgrSrcStr(AgrCommConstant.AgrSrcEnum.getValueByCode(rspBo.getAgrSrc()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_SRC_PCODE);
        }
        //交易模式转义 交易模式：1：贸易模式 2：搓合模式
        if (rspBo.getTradeMode() != null) {
//            rspBo.setTradeModeStr(AgrCommConstant.TradeModeEnum.getValueByCode(rspBo.getTradeMode()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.TRADE_MODE_PCODE);
        }
        //是否配送转义 是否配送 0:否,1是 默认值：是
        if (rspBo.getWhetherDispatch() != null) {
//            rspBo.setWhetherDispatchStr(AgrCommConstant.WhetherDispatchEnum.getValueByCode(rspBo.getWhetherDispatch()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.IS_DISPATCH_PCODE);
        }
        //是否分配转义 是否配送 0:否,1是 默认值：是
        if (rspBo.getWhetherAssign() != null) {
//            rspBo.setWhetherAssignStr(AgrCommConstant.WhetherAssignEnum.getValueByCode(rspBo.getWhetherAssign()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN_PCODE);
        }
        //采购类别：1物资类、2施工类、3服务类
        if (rspBo.getAgreementVariety() != null) {
//            rspBo.setAgreementVarietyStr(AgrCommConstant.AgreementVarietyEnum.getValueByCode(rspBo.getAgreementVariety()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_VARIETY_PCODE);
        }
        //所属专区转义  1：电力专区，5：煤炭专区
        if (rspBo.getAgrLocation() != null) {
//            rspBo.setAgrLocationStr(AgrCommConstant.AgrLocationEnum.getValueByCode(rspBo.getAgrLocation()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.AGR_LOCATION_PCODE);
        }
        //是否商城铺货标识转义 是否商城铺货标识 1：是，0：否
        if (rspBo.getWhetherStorePlan() != null) {
//            rspBo.setWhetherStorePlanStr(AgrCommConstant.WhetherStorePlanEnum.getValueByCode(rspBo.getWhetherStorePlan()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.IS_STORE_PLAN_PCODE);
        }
        //应用范围类型转义 选项值：0：全部:1：省份、2：行业:3：分子公司:4：项目单位 默认值：无
        if (rspBo.getScopeType() != null) {
//            rspBo.setScopeTypeStr(AgrCommConstant.ScopeTypeEnum.getValueByCode(rspBo.getScopeType()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.SCOPE_TYPE_PCODE);
        }
        //调价机制转义 调价机制：0：无，1：事前调价，2：事中调价 默认值：0
        if (rspBo.getAdjustPrice() != null) {
//            rspBo.setAdjustPriceStr(AgrCommConstant.AdjustPriceEnum.getValueByCode(rspBo.getAdjustPrice()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.ADJUST_PRICE_PCODE);
        }
        //是否有明细标识转义  1：是，0：否
        if (rspBo.getWhetherHaveItem() != null) {
//            rspBo.setWhetherHaveItemStr(AgrCommConstant.WhetherHaveItemEnum.getValueByCode(rspBo.getWhetherHaveItem()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.IS_HAVE_ITEM_PCODE);
        }
        //铺货方式转义
        if (rspBo.getVendorMode() != null) {
//            rspBo.setVendorModeStr(AgrCommConstant.VendorModeEnum.getValueByCode(rspBo.getVendorMode()));
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.VENDO_RMODE);
        }

        Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);
        if (MapUtil.isNotEmpty(dicMap)) {
            //协议模式转义  协议模式 1：平台协议 2：单位协议 默认1
            rspBo.setAgrModeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_MODE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_MODE_PCODE).get(rspBo.getAgrMode().toString()).getTitle());
            //协议分类转义 协议分类 0：集团集采协议:1：区域集采协议、2：项目单位协议； 默认值：0：集团集采协议
            rspBo.setAgrTypeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_TYPE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_TYPE_PCODE).get(rspBo.getAgrType().toString()).getTitle());
            //协议状态转义  协议状态 0：草稿 1：提交中  2：启用 3：停用
            rspBo.setAgrStatusStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_STATUS_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_STATUS_PCODE).get(rspBo.getAgrType().toString()).getTitle());
            //协议价格类型转义 价格类型 1：执行价 2：协议价 默认1
            rspBo.setAgrPriceTypeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_PRICE_TYPE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_PRICE_TYPE_PCODE).get(rspBo.getAgrPriceType().toString()).getTitle());
            //协议来源转义 协议来源：1：手动创建，2.协议合同，3.招投标，4.询比价，5.竞价
            rspBo.setAgrSrcStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_SRC_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_SRC_PCODE).get(rspBo.getAgrSrc().toString()).getTitle());
            //交易模式转义 交易模式：1：贸易模式 2：搓合模式
            rspBo.setTradeModeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.TRADE_MODE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.TRADE_MODE_PCODE).get(rspBo.getTradeMode().toString()).getTitle());
            //是否配送转义 是否配送 0:否,1是 默认值：是
            rspBo.setWhetherDispatchStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_DISPATCH_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_DISPATCH_PCODE).get(rspBo.getWhetherDispatch().toString()).getTitle());
            //是否分配转义 是否配送 0:否,1是 默认值：是
            rspBo.setWhetherAssignStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN_PCODE).get(rspBo.getWhetherAssign().toString()).getTitle());
            //采购类别：1物资类、2施工类、3服务类
            rspBo.setAgreementVarietyStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_VARIETY_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGREEMENT_VARIETY_PCODE).get(rspBo.getAgreementVariety().toString()).getTitle());
            //所属专区转义  1：电力专区，5：煤炭专区
//            rspBo.setAgrLocationStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_LOCATION_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.AGR_LOCATION_PCODE).get(rspBo.getAgrLocation().toString()).getTitle());
            //是否商城铺货标识转义 是否商城铺货标识 1：是，0：否
            rspBo.setWhetherStorePlanStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_STORE_PLAN_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_STORE_PLAN_PCODE).get(rspBo.getWhetherStorePlan().toString()).getTitle());
            //应用范围类型转义 选项值：0：全部:1：省份、2：行业:3：分子公司:4：项目单位 默认值：无
            rspBo.setScopeTypeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.SCOPE_TYPE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.SCOPE_TYPE_PCODE).get(rspBo.getScopeType().toString()).getTitle());
            //调价机制转义 调价机制：0：无，1：事前调价，2：事中调价 默认值：0\
            rspBo.setAdjustPriceStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.ADJUST_PRICE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.ADJUST_PRICE_PCODE).get(rspBo.getAdjustPrice().toString()).getTitle());
            //是否有明细标识转义  1：是，0：否
            rspBo.setWhetherHaveItemStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_HAVE_ITEM_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_HAVE_ITEM_PCODE).get(rspBo.getWhetherHaveItem().toString()).getTitle());
            //铺货方式转义
            rspBo.setVendorModeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.VENDO_RMODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.VENDO_RMODE).get(rspBo.getVendorMode().toString()).getTitle());
        }
        return rspBo;
    }

    /**
     * 描述：付款信息转义
     */
    private void agrPayConfTransfer(AgrGetAgrMainChngDetailRspBO agrGetAgrMainChngDetailRspBO){
        //设置付款配置
        List<AgrPayConfigChngBo> agrPayConfig = agrGetAgrMainChngDetailRspBO.getAgrPayConfigChng();
        if (!agrPayConfig.isEmpty()) {
            List<String> pCodeList = new ArrayList<>();
            //设置支付方式转义
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.PAY_TYPE_PCODE);
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.PAY_OBJ_PCODE);
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.ASSIGN_PCODE);
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN);
            pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.NO_ASSIGN_PCODE);

            // 查询字典
            Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);
            for (AgrPayConfigChngBo item : agrPayConfig) {
                if (!StringUtils.isEmpty(item.getAssign())) {
                    item.setAssignStr(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.ASSIGN_PCODE).get(item.getAssign()).getTitle());
                }
                if (!StringUtils.isEmpty(item.getBusiNode())){
                    if (item.getAssign().equals(AgrCommConstant.Assign.NOT_FINISH.toString())){
                        item.setBusiNodeStr(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.IS_ASSIGN).get(item.getBusiNode().toString()).getTitle());
                    } else if (item.getAssign().equals(AgrCommConstant.Assign.FINISHED.toString())) {
                        item.setBusiNodeStr(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.NO_ASSIGN_PCODE).get(item.getBusiNode().toString()).getTitle());
                    }
                }
                if (item.getPayType() != null){
                    item.setPayTypeStr(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.PAY_TYPE_PCODE).get(item.getPayType().toString()).getTitle());
                }
                if (item.getPayObj() != null){
                    item.setPayObjStr(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.PAY_OBJ_PCODE).get(item.getPayObj().toString()).getTitle());
                }
            }
        }
    }
}
