package com.tydic.dyc.agr.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrGetAgrAdjustIChngItemListReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrGetAgrAdjustIChngItemListRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrItemAdjustChngBo;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @title: AgrGetAgrAdjustIChngItemListServiceImpl
 * @describe： 协议调价变更明细列表查询服务实现
 * @created: 2022/9/15 16:53
 * @author: FKC
 */
@HTServiceImpl
@Slf4j
public class AgrGetAgrAdjustIChngItemListServiceImpl implements AgrGetAgrAdjustIChngItemListService{
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrGetAgrAdjustIChngItemListRspBO getAgrAdjustIChngItemList(AgrGetAgrAdjustIChngItemListReqBO reqBo) {
        //1.入参校验
        this.validation(reqBo);
        //2.根据协议ID分页查询协议明细
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.getAgrItemByPage(reqBo);

        //3.根据协议ID，变更申请ID，和步骤2查询出的协议明细ID集合 查询协议明细变更列表
        AgrItemChngListQryRspPageBo agrItemChngListQryRspPageBo = this.getAgrItemChngByItemIds(agrItemListQryRspPageBo,reqBo);

        //4.组装出参
        AgrGetAgrAdjustIChngItemListRspBO rspBO = AgrRu.js(agrItemListQryRspPageBo,AgrGetAgrAdjustIChngItemListRspBO.class);
        rspBO.setRows(this.packageRsp(agrItemListQryRspPageBo,agrItemChngListQryRspPageBo));
        return rspBO;
    }
    private List<AgrItemAdjustChngBo> packageRsp(AgrItemListQryRspPageBo itemBo,AgrItemChngListQryRspPageBo itemChngBo){
        List<AgrItemAdjustChngBo> rows = AgrRu.jsl(itemBo.getRows(),AgrItemAdjustChngBo.class);
        if(!CollectionUtils.isEmpty(rows)){
            Map<Long, AgrItemChng> tempMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(itemChngBo.getRows())){
                tempMap =  itemChngBo.getRows().stream().collect(Collectors.toMap(AgrItemChng::getAgrItemId, agrItemChng->agrItemChng));
            }
            for (AgrItemAdjustChngBo agrItemAdjustChngBo:rows) {
                AgrItemChng agrItemChng = tempMap.get(agrItemAdjustChngBo.getAgrItemId());
                if (agrItemAdjustChngBo.getWhetherOil() != null) {
                    agrItemAdjustChngBo.setWhetherOilStr(AgrCommConstant.IsOilPcodeEnum.getValueByCode(agrItemAdjustChngBo.getWhetherOil()));
                }
                agrItemAdjustChngBo.setNewbuyNumber(agrItemAdjustChngBo.getBuyNumber());
                agrItemAdjustChngBo.setNewbuyPrice(agrItemAdjustChngBo.getBuyPrice());
                agrItemAdjustChngBo.setNewbuyPriceSum(agrItemAdjustChngBo.getBuyPriceSum());
                agrItemAdjustChngBo.setNewmarkupRate(agrItemAdjustChngBo.getMarkupRate());
                agrItemAdjustChngBo.setNewsalePrice(agrItemAdjustChngBo.getSalePrice());
                agrItemAdjustChngBo.setNewsalePriceSum(agrItemAdjustChngBo.getSalePriceSum());
                agrItemAdjustChngBo.setAgrItemChngId(agrItemAdjustChngBo.getAgrItemChngId());

                if(agrItemChng!=null){
                    if(agrItemChng.getBuyNumber()!=null){
                        agrItemAdjustChngBo.setNewbuyNumber(agrItemChng.getBuyNumber());
                    }
                    if(agrItemChng.getBuyPrice()!=null){
                        agrItemAdjustChngBo.setNewbuyPrice(agrItemChng.getBuyPrice());
                    }
                    if(agrItemChng.getBuyPriceSum()!=null){
                        agrItemAdjustChngBo.setNewbuyPriceSum(agrItemChng.getBuyPriceSum());
                    }
                    if(agrItemChng.getMarkupRate()!=null){
                        agrItemAdjustChngBo.setNewmarkupRate(agrItemChng.getMarkupRate());
                    }
                    if(agrItemChng.getSalePrice()!=null){
                        agrItemAdjustChngBo.setNewsalePrice(agrItemChng.getSalePrice());
                    }
                    if(agrItemChng.getSalePriceSum()!=null){
                        agrItemAdjustChngBo.setNewsalePriceSum(agrItemChng.getSalePriceSum());
                    }
                    if(agrItemChng.getAgrItemChngId()!=null){
                        agrItemAdjustChngBo.setAgrItemChngId(agrItemChng.getAgrItemChngId());
                    }

                }
            }
        }
       return rows;
    }
    /**
     * 查询协议变更明细列表
     */
    private AgrItemChngListQryRspPageBo getAgrItemChngByItemIds(AgrItemListQryRspPageBo agrItemListQryRspPageBo,AgrGetAgrAdjustIChngItemListReqBO reqBo){
        //获取协议明细Id集合
        List<Long> agrItemIds = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(agrItemListQryRspPageBo)){
            List<AgrItem> agrItems = agrItemListQryRspPageBo.getRows();
            if (!CollectionUtils.isEmpty(agrItems)){
                agrItems.stream().map(AgrItem::getAgrItemId).forEach(agrItemId -> agrItemIds.add(agrItemId));
            }
        }
        if(agrItemIds.size()>0){
            AgrItemChngListQryReqPageBo agrItemChngListQryReqPageBo = AgrRu.js(reqBo,AgrItemChngListQryReqPageBo.class);
            agrItemChngListQryReqPageBo.setAgrItemIds(agrItemIds);
            agrItemChngListQryReqPageBo.setPageNo(1);
            agrItemChngListQryReqPageBo.setPageSize(agrItemIds.size());
            //查询查询协议明细变更列表
            AgrItemChngListQryRspPageBo agrItemChngListQryRspPageBo = this.iAgrChngApplyModel.getAgrItemChngList(agrItemChngListQryReqPageBo);
            return agrItemChngListQryRspPageBo;
        }
        return null;
    }

    /**
     * 根据协议ID分页查询协议明细
     * @param reqBo
     * @return
     */
    private AgrItemListQryRspPageBo getAgrItemByPage(AgrGetAgrAdjustIChngItemListReqBO reqBo) {
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = AgrRu.js(reqBo,AgrItemListQryReqPageBo.class);

        // 查询协议变更申请对应的版本号
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
        agrAgrChngApplyQryBo.setAgrId(reqBo.getAgrId());
        agrAgrChngApplyQryBo.setChngApplyId(reqBo.getChngApplyId());
        AgrChngApplyDo rspDo = this.iAgrChngApplyModel.getAgrChngApplyDetail(agrAgrChngApplyQryBo);
        if(rspDo!=null && StringUtils.hasText(rspDo.getAgrVersion())){
            agrItemListQryReqPageBo.setAgrVersion(rspDo.getAgrVersion());
        }
        //查询协议明细列表
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        return agrItemListQryRspPageBo;
    }

    private void validation(AgrGetAgrAdjustIChngItemListReqBO reqBo) {
        if (ObjectUtil.isEmpty(reqBo)) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getChngApplyId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更申请ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPageNo())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[当前页]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPageSize())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[每页条数]不能为空");
        }
    }
}
