package com.tydic.dyc.agr.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.agr.bo.AgrAppScopeBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrScopeSyncBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSkuChangePriceBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:AgrSyncUccServiceImpl
 * 说明:TODO
 * 时间:2022/9/23 10:22
 * 作者:代愿愿
 */
@HTServiceImpl
@Slf4j
public class AgrSyncUccServiceImpl implements AgrSyncUccService {
    @Value("${AGR_SKU_CHANGE_TOPIC}")
    private String agrSkuChangeTopic;

    @Value("${AGR_SKU_CHANGE_TAG}")
    private String agrSkuChangeTag;

    @Resource(name = "agrSyncSkuStatusMqServiceProvider")
    private ProxyMessageProducer agrSyncSkuStatusMqServiceProvider;

    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @Override
    public AgrSyncUccRspBO dealAgrSyncUcc(AgrSyncUccReqBO agrSyncUccReqBO) {
        // 1 必填校验
        this.validParam(agrSyncUccReqBO);
        // 2 根据不同的类型处理数据
        String messageContent = "";
        switch (agrSyncUccReqBO.getSyncType()) {
            case 1:
                // 修改商品状态为协议冻结
                messageContent = this.toFrozen(agrSyncUccReqBO);
                break;
            case 2:
                //  修改商品状态为协议失效
                messageContent = this.toInvalid(agrSyncUccReqBO);
                break;
            case 3:
                //  恢复商品状态
                messageContent = this.toUpShelf(agrSyncUccReqBO);
                break;
            case 4:
                // 应用范围同步 同步协议应用范围编码集合
                messageContent = this.syncScope(agrSyncUccReqBO);
                break;
            case 5:
                // 明细调价同步 同步采购单价，销售单价
                this.syncAgrItemAjustPrice(agrSyncUccReqBO);
                break;
            case 6:
                // 明细删除同步 修改商品状态为协议失效
                this.syncAgrItemDelete(agrSyncUccReqBO);
                break;
            default:
                break;
        }
        // 发消息
        this.sendMsg(messageContent);
        return AgrRu.success(AgrSyncUccRspBO.class);
    }

    /**
     * 发送消息
     */
    private void sendMsg(String content) {
        if (StringUtils.hasText(content)) {
            log.info("发消息同步商品商品中心入参为" + content);
            agrSyncSkuStatusMqServiceProvider.send(new ProxyMessage(agrSkuChangeTopic, agrSkuChangeTag, content));
            log.info("发消息同步商品商品中心成功");
        }

    }

    /**
     * 明细删除同步 修改商品状态为协议失效
     */
    private void syncAgrItemDelete(AgrSyncUccReqBO agrSyncUccReqBO) {
        // 1 查询协议明细变更列表
        AgrItemChngListQryReqPageBo reqPageBo = new AgrItemChngListQryReqPageBo();
        reqPageBo.setAgrId(agrSyncUccReqBO.getAgrId());
        reqPageBo.setChngApplyId(agrSyncUccReqBO.getChngApplyId());
        reqPageBo.setItemChngType(AgrCommConstant.AgreementSkuChangeType.DELETE);
        reqPageBo.setPageNo(1);
        reqPageBo.setPageSize(1000);
        AgrItemChngListQryRspPageBo rspPageBo = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
        if (null != rspPageBo && !CollectionUtils.isEmpty(rspPageBo.getRows())) {
            this.syncAgrItemDeleteData(rspPageBo.getRows(), agrSyncUccReqBO.getAgrId());
            // 如果明细数据不止一页
            if (rspPageBo.getTotal() > 1) {
                int total = rspPageBo.getTotal();
                for (int i = 2; i <= total; i++) {
                    reqPageBo.setPageNo(1);
                    reqPageBo.setPageSize(1000);
                    AgrItemChngListQryRspPageBo rspPageBo1 = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
                    this.syncAgrItemDeleteData(rspPageBo1.getRows(), agrSyncUccReqBO.getAgrId());
                }
            }
        }

    }

    /**
     * 组装删除数据
     */
    private void syncAgrItemDeleteData(List<AgrItemChng> agrItemChngs, Long agrId) {
        List<Long> agreementSkuIds = new ArrayList<>();
        agrItemChngs.forEach(agrItemChng -> {
            agreementSkuIds.add(agrItemChng.getAgrItemId());
        });
        Map<String, Object> content = new HashMap<>();
        List<Long> agreementIds = new ArrayList<>();
        agreementIds.add(agrId);
        content.put("agreementIds", agreementIds);
        content.put("agreementSkuIds", agreementSkuIds);
        content.put("changeType", AgrCommConstant.AgrChangeOperType.INVALID);
        // 发消息
        this.sendMsg(JSON.toJSONString(content));

    }

    /**
     * 明细调价同步 同步采购单价，销售单价
     */
    private void syncAgrItemAjustPrice(AgrSyncUccReqBO agrSyncUccReqBO) {
        // 1 查询协议明细变更列表
        AgrItemChngListQryReqPageBo reqPageBo = new AgrItemChngListQryReqPageBo();
        reqPageBo.setAgrId(agrSyncUccReqBO.getAgrId());
        reqPageBo.setChngApplyId(agrSyncUccReqBO.getChngApplyId());
        reqPageBo.setPageNo(1);
        reqPageBo.setPageSize(1000);
        AgrItemChngListQryRspPageBo rspPageBo = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
        if (null != rspPageBo && !CollectionUtils.isEmpty(rspPageBo.getRows())) {
            this.syncAgrItemAjustPriceData(rspPageBo.getRows(), agrSyncUccReqBO.getAgrId());
            // 如果明细数据不止一页
            if (rspPageBo.getTotal() > 1) {
                int total = rspPageBo.getTotal();
                for (int i = 2; i <= total; i++) {
                    reqPageBo.setPageNo(1);
                    reqPageBo.setPageSize(1000);
                    AgrItemChngListQryRspPageBo rspPageBo1 = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
                    this.syncAgrItemAjustPriceData(rspPageBo1.getRows(), agrSyncUccReqBO.getAgrId());
                }
            }
        }

    }

    /**
     * 组装调价数据
     */
    private void syncAgrItemAjustPriceData(List<AgrItemChng> agrItemChngs, Long agrId) {
        List<AgrSkuChangePriceBO> skuChangePriceBOs = new ArrayList<>();
        agrItemChngs.forEach(agrItemChng -> {
            AgrSkuChangePriceBO agrSkuChangePriceBO = new AgrSkuChangePriceBO();
            agrSkuChangePriceBO.setAgreementId(agrId);
            agrSkuChangePriceBO.setAgreementSkuId(agrItemChng.getAgrItemId());
            try {
                agrSkuChangePriceBO.setSalePrice(MoneyUtils.BigDecimal2Long(agrItemChng.getSalePrice()));
                agrSkuChangePriceBO.setBuyPrice(MoneyUtils.BigDecimal2Long(agrItemChng.getBuyPrice()));
            } catch (Exception e) {
                log.info(e.getMessage());
            }
            skuChangePriceBOs.add(agrSkuChangePriceBO);
        });
        Map<String, Object> content = new HashMap<>();
        content.put("skuChangePriceBOs", skuChangePriceBOs);
        content.put("changeType", AgrCommConstant.AgrChangeOperType.PRICE);
        // 发消息
        this.sendMsg(JSON.toJSONString(content));

    }

    /**
     * 应用范围同步 同步协议应用范围编码集合
     */
    private String syncScope(AgrSyncUccReqBO agrSyncUccReqBO) {
        // 1 查询协议主体变更详情，取应用范围信息
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
        agrAgrChngApplyQryBo.setAgrId(agrSyncUccReqBO.getAgrId());
        agrAgrChngApplyQryBo.setChngApplyId(agrSyncUccReqBO.getChngApplyId());
        AgrChngApplyDo agrChngApplyDo = this.iAgrChngApplyModel.getAgrMainChngDetail(agrAgrChngApplyQryBo);
        if (null != agrChngApplyDo && !CollectionUtils.isEmpty(agrChngApplyDo.getAgrAppScopeChng())) {
            List<String> appScopes = new ArrayList<>();
            agrChngApplyDo.getAgrAppScopeChng().forEach(agrAppScopeChng -> {
                appScopes.add(agrAppScopeChng.getScopeCode());
            });
            List<AgrAgrScopeSyncBO> agrScopeSyncBOs = new ArrayList<>();
            AgrAgrScopeSyncBO agrAgrScopeSyncBO = new AgrAgrScopeSyncBO();
            agrAgrScopeSyncBO.setAgreementId(agrSyncUccReqBO.getAgrId());
            agrAgrScopeSyncBO.setScopeCodes(appScopes.toString());
            // 包含应用范围机构树
            agrAgrScopeSyncBO.setAgrAppScopeBos(JUtil.jsl(agrChngApplyDo.getAgrAppScopeChng(), AgrAppScopeBo.class));
            agrScopeSyncBOs.add(agrAgrScopeSyncBO);
            Map<String, Object> content = new HashMap<>();
            content.put("agrScopeSyncBOs", agrScopeSyncBOs);
            return JSON.toJSONString(content);
        }
        return null;
    }

    /**
     * 恢复商品状态
     */
    private String toUpShelf(AgrSyncUccReqBO agrSyncUccReqBO) {
        Map<String, Object> content = new HashMap<>();
        List<Long> agreementIds = new ArrayList<>();
        agreementIds.add(agrSyncUccReqBO.getAgrId());
        content.put("changeType", AgrCommConstant.AgrChangeOperType.THAW);
        content.put("agreementIds", agreementIds.stream().distinct().collect(Collectors.toList()));
        content.put("operId", agrSyncUccReqBO.getOperId());
        content.put("operName", agrSyncUccReqBO.getOperName());
        return JSON.toJSONString(content);
    }

    /**
     * 修改商品状态为协议失效
     */
    private String toInvalid(AgrSyncUccReqBO agrSyncUccReqBO) {
        Map<String, Object> content = new HashMap<>();
        List<Long> agreementIds = new ArrayList<>();
        agreementIds.add(agrSyncUccReqBO.getAgrId());
        if (CollectionUtil.isNotEmpty(agrSyncUccReqBO.getAgrIds())) {
            agreementIds.addAll(agrSyncUccReqBO.getAgrIds());
        }
        content.put("changeType", AgrCommConstant.AgrChangeOperType.INVALID);
        content.put("agreementIds", agreementIds.stream().distinct().collect(Collectors.toList()));
        content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_INVALID);
        content.put("operId", agrSyncUccReqBO.getOperId());
        content.put("operName", agrSyncUccReqBO.getOperName());
        return JSON.toJSONString(content);
    }

    /**
     * 修改商品状态为协议冻结
     */
    private String toFrozen(AgrSyncUccReqBO agrSyncUccReqBO) {
        Map<String, Object> content = new HashMap<>();
        List<Long> agreementIds = new ArrayList<>();
        agreementIds.add(agrSyncUccReqBO.getAgrId());
        if (CollectionUtil.isNotEmpty(agrSyncUccReqBO.getAgrIds())) {
            agreementIds.addAll(agrSyncUccReqBO.getAgrIds());
        }
        content.put("changeType", AgrCommConstant.AgrChangeOperType.FREZE);
        content.put("agreementIds", agreementIds.stream().distinct().collect(Collectors.toList()));
        content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
        content.put("operId", agrSyncUccReqBO.getOperId());
        content.put("operName", agrSyncUccReqBO.getOperName());
        return JSON.toJSONString(content);
    }

    /**
     * 必填校验
     */
    private void validParam(AgrSyncUccReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (reqBO.getSyncType() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参syncType不能为空");
        }
        if (reqBO.getAgrId() == null) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参agrId不能为空");
        }

    }
}
