package com.tydic.dyc.agr.service.sysdictionary;

import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.SysDicDictionaryDo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.sysdictionary.AgrDeleteDictionaryService;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrDeleteDictionaryReqBo;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrDeleteDictionaryRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：AgrDeleteDictionaryServiceImpl
 * 说明：
 * 时间：2022/7/6 16:06
 * 作者：huzhongbao
 */
@HTServiceImpl
@Slf4j
public class AgrDeleteDictionaryServiceImpl implements AgrDeleteDictionaryService {
    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;
    @Override
    public AgrDeleteDictionaryRspBo deleteDicDictionary(AgrDeleteDictionaryReqBo reqBo) {
        SysDicDictionaryDo sysDicDictionaryDo = new SysDicDictionaryDo();
        sysDicDictionaryDo.setPCode(reqBo.getPCode());
        sysDicDictionaryDo.setCode(reqBo.getCode());
        this.iAgrDictionaryModel.deleteDicDictionary(sysDicDictionaryDo);
        AgrDeleteDictionaryRspBo rspBo = new AgrDeleteDictionaryRspBo();
        rspBo.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBo.setRespDesc("成功");
        return rspBo;
    }
}
