package com.tydic.dyc.agr.service.sysdictionary;

import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.SysDicDictionaryDo;
import com.tydic.dyc.agr.service.sysdictionary.AgrQueryBypCodeBackMapService;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrQueryBypCodeBackMapReqBO;
import com.tydic.dyc.agr.service.sysdictionary.bo.AgrQueryBypCodeBackMapRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：AgrQueryBypCodeBackMapServiceImpl
 * 说明：
 * 时间：2022/7/8 13:03
 * 作者：huzhongbao
 */
@HTServiceImpl
@Slf4j
public class AgrQueryBypCodeBackMapServiceImpl implements AgrQueryBypCodeBackMapService {
    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;
    @Override
    public AgrQueryBypCodeBackMapRspBO queryBypCodeBackPo(AgrQueryBypCodeBackMapReqBO reqBO) {
        AgrQueryBypCodeBackMapRspBO AgrQueryBypCodeBackMapRspBO = AgrRu.success(AgrQueryBypCodeBackMapRspBO.class);
        AgrQueryBypCodeBackMapRspBO.setDicMap(this.iAgrDictionaryModel.queryBypCodeBackMap(new SysDicDictionaryDo(reqBO.getSysCode(), reqBO.getPcode())).getMap());
        return AgrQueryBypCodeBackMapRspBO;
    }
}
