/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.ucc.catalog.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.ucc.catalog.UccCategoryChannelRelatedCategoryListReqDO;
import com.tydic.dyc.pro.ucc.catalog.UccCategoryChannelRelatedCategoryListRspDO;
import com.tydic.dyc.pro.ucc.catalog.UccCategorySelectListPageReqDO;
import com.tydic.dyc.pro.ucc.catalog.UccCategorySelectListPageRspDO;
import com.tydic.dyc.pro.ucc.catalog.UccChannelRelatedCategoryListQryFrontReqDO;
import com.tydic.dyc.pro.ucc.catalog.UccChannelRelatedCategoryListQryFrontRspDO;
import com.tydic.dyc.pro.ucc.catalog.UccGuideCatalogDO;
import com.tydic.dyc.pro.ucc.catalog.api.UccCatalogRepository;
import com.tydic.dyc.pro.ucc.constant.CatalogLevelEnum;
import com.tydic.dyc.pro.ucc.constant.CommodityConstants;
import com.tydic.dyc.pro.ucc.constant.PublicStatusEnum;
import com.tydic.dyc.pro.ucc.dao.UccCommodityTypeMapper;
import com.tydic.dyc.pro.ucc.dao.UccGuideCatalogMapper;
import com.tydic.dyc.pro.ucc.dao.UccRCatalogCommodityTypeMapper;
import com.tydic.dyc.pro.ucc.dao.UccRelChannelCatalogMapper;
import com.tydic.dyc.pro.ucc.po.UccCommodityTypePO;
import com.tydic.dyc.pro.ucc.po.UccGuideCatalogPO;
import com.tydic.dyc.pro.ucc.po.UccRCatalogCommodityTypePO;
import com.tydic.dyc.pro.ucc.po.UccRelChannelCatalogPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccCatalogRepositoryImpl
implements UccCatalogRepository {
    @Autowired
    @Qualifier(value="newUccGuideCatalogMapper")
    private UccGuideCatalogMapper uccCatalogDealMapper;
    @Autowired
    @Qualifier(value="newUccRCatalogCommodityTypeMapper")
    private UccRCatalogCommodityTypeMapper uccCatalogReCommodityTypeMapper;
    @Autowired
    @Qualifier(value="newUccCommodityTypeMapper")
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    @Qualifier(value="newUccRelChannelCatalogMapper")
    private UccRelChannelCatalogMapper uccRelChannelCatalogMapper;

    @Override
    public UccCategorySelectListPageRspDO selectCategoryList(UccCategorySelectListPageReqDO reqDO) {
        UccCategorySelectListPageRspDO rspDO = new UccCategorySelectListPageRspDO();
        Page page = new Page();
        List rows = new ArrayList();
        UccGuideCatalogPO uccGuideCatalogPo = (UccGuideCatalogPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqDO)), UccGuideCatalogPO.class);
        ArrayList result = new ArrayList();
        List<UccGuideCatalogPO> queryAllCatalog = this.uccCatalogDealMapper.queryAllCatalog(null);
        List uccCatalogDOList = JSON.parseArray((String)JSON.toJSONString(queryAllCatalog), UccGuideCatalogDO.class);
        if (CommodityConstants.CategorySelectType.CONDITION_QUERY.equals(reqDO.getQryFlag())) {
            page.setPageNo(-1);
            page.setPageSize(-1);
            List<UccGuideCatalogPO> guideCatalogPOS = this.uccCatalogDealMapper.getListPage(uccGuideCatalogPo, (Page<UccGuideCatalogPO>)page);
            if (CollectionUtils.isEmpty(guideCatalogPOS)) {
                rspDO.setRows(rows);
                rspDO.setPageNo(page.getPageNo());
                rspDO.setTotal(page.getTotalPages());
                rspDO.setRecordsTotal(page.getTotalCount());
                return rspDO;
            }
            rows = JSON.parseArray((String)JSON.toJSONString(guideCatalogPOS), UccGuideCatalogDO.class);
            List<UccGuideCatalogDO> sortByLeveleList = rows.stream().sorted(Comparator.comparing(UccGuideCatalogDO::getCatalogLevel).reversed()).collect(Collectors.toList());
            Map<Long, List<UccGuideCatalogDO>> pIdGroupMap = rows.stream().collect(Collectors.groupingBy(UccGuideCatalogDO::getUpperCatalogId));
            sortByLeveleList.forEach(e -> this.buildTree((UccGuideCatalogDO)e, uccCatalogDOList, result, pIdGroupMap));
            List resultList = result.stream().sorted(Comparator.comparing(UccGuideCatalogDO::getViewOrder)).collect(Collectors.toList());
            rspDO.setRecordsTotal(resultList.size());
            rspDO.setRecordsTotal(resultList.size());
            int startIndex = (reqDO.getPageNo() - 1) * reqDO.getPageSize();
            int endIndex = Math.min(startIndex + reqDO.getPageSize(), resultList.size());
            List paginatedResult = resultList.subList(startIndex, endIndex);
            rspDO.setRows(paginatedResult);
            rspDO.setPageNo(rspDO.getPageNo());
            rspDO.setTotal(resultList.size() % reqDO.getPageSize() == 0 ? resultList.size() / reqDO.getPageSize() : resultList.size() / reqDO.getPageSize() + 1);
        } else {
            page.setPageNo(reqDO.getPageNo());
            page.setPageSize(reqDO.getPageSize());
            if (uccGuideCatalogPo.getUpperCatalogId() == null) {
                uccGuideCatalogPo.setUpperCatalogId(0L);
            }
            uccGuideCatalogPo.setOrderBy("VIEW_ORDER");
            List<UccGuideCatalogPO> guideCatalogPOS = this.uccCatalogDealMapper.getListPage(uccGuideCatalogPo, (Page<UccGuideCatalogPO>)page);
            rows = JSON.parseArray((String)JSON.toJSONString(guideCatalogPOS), UccGuideCatalogDO.class);
            for (UccGuideCatalogDO uccGuideCatalogDO : rows) {
                boolean hasChild;
                PublicStatusEnum publicStatusEnum;
                CatalogLevelEnum catalogLevel = CatalogLevelEnum.getCatalogLevel(uccGuideCatalogDO.getCatalogLevel());
                if (catalogLevel != null) {
                    uccGuideCatalogDO.setCatalogLevelDesc(catalogLevel.desc);
                }
                if ((publicStatusEnum = PublicStatusEnum.getPublicStatusDesc(uccGuideCatalogDO.getCatalogStatus())) != null) {
                    uccGuideCatalogDO.setCatalogStatusDesc(publicStatusEnum.desc);
                }
                if (hasChild = queryAllCatalog.stream().anyMatch(catalog -> catalog.getUpperCatalogId().equals(uccGuideCatalogDO.getGuideCatalogId()))) {
                    uccGuideCatalogDO.setChildFlag(CommodityConstants.ChildFlag.CHILD_FLAG);
                    continue;
                }
                uccGuideCatalogDO.setChildFlag(CommodityConstants.ChildFlag.CHILD_FLAG_NO);
            }
            rspDO.setRecordsTotal(page.getTotalCount());
            rspDO.setRows(rows);
            rspDO.setPageNo(page.getPageNo());
            rspDO.setTotal(page.getTotalPages());
        }
        return rspDO;
    }

    @Override
    public void addCategory(UccGuideCatalogDO addCategoryDO) {
        UccGuideCatalogPO uccGuideCatalogPO = new UccGuideCatalogPO();
        uccGuideCatalogPO.setCatalogName(addCategoryDO.getCatalogName());
        UccGuideCatalogPO catalogName = this.uccCatalogDealMapper.getModelBy(uccGuideCatalogPO);
        if (!ObjectUtils.isEmpty((Object)catalogName)) {
            throw new ZTBusinessException("\u7c7b\u76ee\u540d\u79f0\u5df2\u5b58\u5728");
        }
        uccGuideCatalogPO.setCatalogCode(addCategoryDO.getCatalogCode());
        uccGuideCatalogPO.setCatalogName(null);
        UccGuideCatalogPO catalogCode = this.uccCatalogDealMapper.getModelBy(uccGuideCatalogPO);
        if (!ObjectUtils.isEmpty((Object)catalogCode)) {
            throw new ZTBusinessException("\u7c7b\u76ee\u7f16\u7801\u5df2\u5b58\u5728");
        }
        addCategoryDO.setViewOrder(addCategoryDO.getViewOrder() + 1);
        uccGuideCatalogPO.setCatalogCode(null);
        uccGuideCatalogPO.setUpperCatalogId(addCategoryDO.getUpperCatalogId());
        uccGuideCatalogPO.setViewOrder(addCategoryDO.getViewOrder());
        Integer viewOrderCount = this.uccCatalogDealMapper.updateViewOrder(uccGuideCatalogPO);
        if (ObjectUtils.isEmpty((Object)viewOrderCount)) {
            throw new ZTBusinessException("\u7c7b\u76ee\u6392\u5e8f\u5b57\u6bb5\u4fee\u6539\u5931\u8d25");
        }
        UccGuideCatalogPO addCatalogPO = (UccGuideCatalogPO)JSON.parseObject((String)JSON.toJSONString((Object)addCategoryDO), UccGuideCatalogPO.class);
        Integer insertCount = this.uccCatalogDealMapper.insert(addCatalogPO);
        if (ObjectUtils.isEmpty((Object)insertCount) || insertCount == 0) {
            throw new ZTBusinessException("\u7c7b\u76ee\u6dfb\u52a0\u5931\u8d25");
        }
    }

    @Override
    public void updateCategory(UccGuideCatalogDO updateCategoryDO) {
        if (ObjectUtils.isEmpty((Object)updateCategoryDO.getMobileFlag())) {
            UccGuideCatalogPO uccGuideCatalogPO = new UccGuideCatalogPO();
            uccGuideCatalogPO.setCatalogName(updateCategoryDO.getCatalogName());
            UccGuideCatalogPO catalogName = this.uccCatalogDealMapper.getModelBy(uccGuideCatalogPO);
            if (!ObjectUtils.isEmpty((Object)catalogName) && !updateCategoryDO.getGuideCatalogId().equals(catalogName.getGuideCatalogId())) {
                throw new ZTBusinessException("\u7c7b\u76ee\u540d\u79f0\u5df2\u5b58\u5728");
            }
            UccGuideCatalogPO updateCatalogPO = (UccGuideCatalogPO)JSON.parseObject((String)JSON.toJSONString((Object)updateCategoryDO), UccGuideCatalogPO.class);
            UccGuideCatalogPO updateCatalogViewOrderPO = new UccGuideCatalogPO();
            updateCatalogViewOrderPO.setUpperCatalogId(updateCategoryDO.getUpperCatalogId());
            updateCatalogViewOrderPO.setViewOrder(updateCategoryDO.getViewOrder());
            Integer viewOrderCount = this.uccCatalogDealMapper.updateViewOrder(updateCatalogViewOrderPO);
            if (ObjectUtils.isEmpty((Object)viewOrderCount)) {
                throw new ZTBusinessException("\u7c7b\u76ee\u6392\u5e8f\u5b57\u6bb5\u4fee\u6539\u5931\u8d25");
            }
            Integer updateCount = this.uccCatalogDealMapper.updateById(updateCatalogPO);
            if (ObjectUtils.isEmpty((Object)updateCount) || updateCount == 0) {
                throw new ZTBusinessException("\u7c7b\u76ee\u4fee\u6539\u5931\u8d25");
            }
            this.updateCategoryStatus(updateCategoryDO);
        } else {
            this.moveCatalog(updateCategoryDO);
        }
    }

    @Override
    public void deleteCategory(Long guideCatalogId) {
        UccGuideCatalogPO selectGuideCatalogPO = new UccGuideCatalogPO();
        selectGuideCatalogPO.setUpperCatalogId(guideCatalogId);
        Integer count = this.uccCatalogDealMapper.getCheckBy(selectGuideCatalogPO);
        if (count > 0) {
            throw new ZTBusinessException("\u6b64\u7c7b\u76ee\u6709\u5b50\u7c7b\u76ee\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        UccRCatalogCommodityTypePO uccRCatalogCommodityTypePo = new UccRCatalogCommodityTypePO();
        uccRCatalogCommodityTypePo.setGuideCatalogId(guideCatalogId);
        List<UccRCatalogCommodityTypePO> list = this.uccCatalogReCommodityTypeMapper.getList(uccRCatalogCommodityTypePo);
        if (!CollectionUtils.isEmpty(list)) {
            throw new ZTBusinessException("\u6b64\u7c7b\u76ee\u6709\u5173\u8054\u5546\u54c1\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        UccGuideCatalogPO uccGuideCatalogPo = new UccGuideCatalogPO();
        uccGuideCatalogPo.setGuideCatalogId(guideCatalogId);
        Integer deleteCount = this.uccCatalogDealMapper.deleteBy(uccGuideCatalogPo);
        if (ObjectUtils.isEmpty((Object)deleteCount) || deleteCount == 0) {
            throw new ZTBusinessException("\u7c7b\u76ee\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void addCategoryRelatedGoods(List<Long> commodityTypeIds, Long guideCatalogId) {
        UccGuideCatalogPO uccGuideCatalogPO = new UccGuideCatalogPO();
        uccGuideCatalogPO.setGuideCatalogId(guideCatalogId);
        UccGuideCatalogPO modelBy = this.uccCatalogDealMapper.getModelBy(uccGuideCatalogPO);
        if (modelBy == null) {
            throw new ZTBusinessException("\u7c7b\u76ee\u4e0d\u5b58\u5728");
        }
        if (!CommodityConstants.CatalogLevel.CATALOG_LEVEL_THREE.equals(modelBy.getCatalogLevel())) {
            throw new ZTBusinessException("\u7c7b\u76ee\u4e0d\u662f\u4e09\u7ea7\u7c7b\u76ee");
        }
        UccCommodityTypePO uccCommodityTypePO = new UccCommodityTypePO();
        uccCommodityTypePO.setCommodityTypeIds(commodityTypeIds);
        Integer checkIsHave = this.uccCommodityTypeMapper.getCheckBy(uccCommodityTypePO);
        if (ObjectUtils.isEmpty((Object)checkIsHave) || checkIsHave == 0) {
            throw new ZTBusinessException("\u5546\u54c1\u7c7b\u578bid\u4e0d\u5b58\u5728");
        }
        if (checkIsHave.intValue() != commodityTypeIds.size()) {
            throw new ZTBusinessException("\u5546\u54c1\u7c7b\u578bid\u6709" + (commodityTypeIds.size() - checkIsHave) + "\u4e2a\u4e0d\u5b58\u5728");
        }
        UccRCatalogCommodityTypePO uccRCatalogCommodityTypePO = new UccRCatalogCommodityTypePO();
        uccRCatalogCommodityTypePO.setGuideCatalogId(guideCatalogId);
        uccRCatalogCommodityTypePO.setCommodityTypeIds(commodityTypeIds);
        Integer checkIsRelated = this.uccCatalogReCommodityTypeMapper.getCheckBy(uccRCatalogCommodityTypePO);
        if (checkIsRelated != 0) {
            throw new ZTBusinessException(checkIsRelated + "\u4e2a\u5546\u54c1\u7c7b\u578b\u5df2\u7ecf\u5173\u8054\u76ee\u5f55");
        }
        ArrayList<UccRCatalogCommodityTypePO> list = new ArrayList<UccRCatalogCommodityTypePO>();
        for (Long commodityTypeId : commodityTypeIds) {
            UccRCatalogCommodityTypePO itemPO = new UccRCatalogCommodityTypePO();
            itemPO.setRelId(Sequence.getInstance().nextId());
            itemPO.setGuideCatalogId(guideCatalogId);
            itemPO.setCommodityTypeId(commodityTypeId);
            list.add(itemPO);
        }
        try {
            this.uccCatalogReCommodityTypeMapper.insertBatch(list);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7c7b\u76ee\u5173\u8054\u5546\u54c1\u589e\u52a0\u5931\u8d25");
        }
    }

    @Override
    public void removeCategoryRelatedGoods(List<Long> relIds) {
        UccRCatalogCommodityTypePO removeCategoryRelatedGoodsPO = new UccRCatalogCommodityTypePO();
        removeCategoryRelatedGoodsPO.setRelIds(relIds);
        Integer deleteCount = this.uccCatalogReCommodityTypeMapper.deleteBy(removeCategoryRelatedGoodsPO);
        if (ObjectUtils.isEmpty((Object)deleteCount)) {
            throw new ZTBusinessException("\u7c7b\u76ee\u5173\u8054\u5546\u54c1\u79fb\u9664\u5931\u8d25");
        }
    }

    @Override
    public UccCategoryChannelRelatedCategoryListRspDO selectChannelRelatedCategory(UccCategoryChannelRelatedCategoryListReqDO selectDO) {
        UccCategoryChannelRelatedCategoryListRspDO rspDO = new UccCategoryChannelRelatedCategoryListRspDO();
        UccRelChannelCatalogPO uccRelChannelCatalogPO = new UccRelChannelCatalogPO();
        uccRelChannelCatalogPO.setChannelId(selectDO.getChannelId());
        List<UccRelChannelCatalogPO> list = this.uccRelChannelCatalogMapper.getList(uccRelChannelCatalogPO);
        UccGuideCatalogPO uccGuideCatalogPO = (UccGuideCatalogPO)JSON.parseObject((String)JSON.toJSONString((Object)selectDO), UccGuideCatalogPO.class);
        ArrayList<Long> guideCatalogIds = new ArrayList();
        if (!CollectionUtils.isEmpty(list)) {
            guideCatalogIds = list.stream().map(UccRelChannelCatalogPO::getGuideCatalogId).collect(Collectors.toList());
            uccGuideCatalogPO.setGuideCatalogIds(guideCatalogIds);
        }
        List<Object> listPage = new ArrayList();
        try {
            listPage = this.uccCatalogDealMapper.getList(uccGuideCatalogPO);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7c7b\u76ee\u67e5\u8be2\u5931\u8d25");
        }
        List rows = JSON.parseArray((String)JSON.toJSONString(listPage), UccGuideCatalogDO.class);
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            for (UccGuideCatalogDO uccGuideCatalogDO : rows) {
                if (guideCatalogIds.contains(uccGuideCatalogDO.getGuideCatalogId())) {
                    uccGuideCatalogDO.setIsRel(1);
                    continue;
                }
                uccGuideCatalogDO.setIsRel(0);
            }
        }
        rspDO.setData(rows);
        rspDO.setSelected(guideCatalogIds);
        return rspDO;
    }

    @Override
    public UccChannelRelatedCategoryListQryFrontRspDO selectChannelRelatedFrontCategory(UccChannelRelatedCategoryListQryFrontReqDO selectChannelReFrontCategoryDO) {
        UccChannelRelatedCategoryListQryFrontRspDO rspDO = new UccChannelRelatedCategoryListQryFrontRspDO();
        Page page = new Page(selectChannelReFrontCategoryDO.getPageNo(), selectChannelReFrontCategoryDO.getPageSize());
        UccRelChannelCatalogPO uccRelChannelCatalogPO = new UccRelChannelCatalogPO();
        uccRelChannelCatalogPO.setChannelId(selectChannelReFrontCategoryDO.getChannelId());
        List<UccRelChannelCatalogPO> list = this.uccRelChannelCatalogMapper.getList(uccRelChannelCatalogPO);
        ArrayList<Long> guideCatalogIds = new ArrayList();
        if (CollectionUtils.isEmpty(list)) {
            rspDO.setRows(new ArrayList());
            rspDO.setTotal(0);
            rspDO.setPageNo(selectChannelReFrontCategoryDO.getPageNo());
            rspDO.setRecordsTotal(0);
            return rspDO;
        }
        guideCatalogIds = list.stream().map(UccRelChannelCatalogPO::getGuideCatalogId).collect(Collectors.toList());
        UccGuideCatalogPO uccGuideCatalogPO = (UccGuideCatalogPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)selectChannelReFrontCategoryDO)), UccGuideCatalogPO.class);
        if (!CollectionUtils.isEmpty(guideCatalogIds)) {
            uccGuideCatalogPO.setGuideCatalogIds(guideCatalogIds);
        }
        ArrayList<UccGuideCatalogPO> listPage = new ArrayList();
        try {
            uccGuideCatalogPO.setCatalogLevel(3);
            listPage = this.uccCatalogDealMapper.getListPage(uccGuideCatalogPO, (Page<UccGuideCatalogPO>)page);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7c7b\u76ee\u67e5\u8be2\u5931\u8d25");
        }
        List<UccGuideCatalogDO> rows = this.convertList(listPage);
        rspDO.setRows(rows);
        rspDO.setPageNo(page.getPageNo());
        rspDO.setRecordsTotal(page.getTotalCount());
        rspDO.setTotal(page.getTotalPages());
        return rspDO;
    }

    private void moveCatalog(UccGuideCatalogDO updateCategoryDO) {
        UccGuideCatalogPO selectGuideCatalogPO = new UccGuideCatalogPO();
        selectGuideCatalogPO.setUpperCatalogId(updateCategoryDO.getUpperCatalogId());
        selectGuideCatalogPO.setOrderBy("VIEW_ORDER");
        List<UccGuideCatalogPO> uccCatalogPOList = this.uccCatalogDealMapper.queryAllCatalog(selectGuideCatalogPO);
        if (!ObjectUtils.isEmpty(uccCatalogPOList)) {
            for (int i = 0; i < uccCatalogPOList.size(); ++i) {
                if (!updateCategoryDO.getViewOrder().equals(uccCatalogPOList.get(i).getViewOrder())) continue;
                if (updateCategoryDO.getMobileFlag() == 1) {
                    if (i == 0) break;
                    UccGuideCatalogPO catalogUpPO = new UccGuideCatalogPO();
                    catalogUpPO.setGuideCatalogId(updateCategoryDO.getGuideCatalogId());
                    catalogUpPO.setViewOrder(uccCatalogPOList.get(i - 1).getViewOrder());
                    Integer updateUpCount = this.uccCatalogDealMapper.updateById(catalogUpPO);
                    if (ObjectUtils.isEmpty((Object)updateUpCount) || updateUpCount == 0) {
                        throw new ZTBusinessException("\u7c7b\u76ee\u4fee\u6539\u5931\u8d25");
                    }
                    UccGuideCatalogPO catalogDownPO = new UccGuideCatalogPO();
                    catalogDownPO.setGuideCatalogId(uccCatalogPOList.get(i - 1).getGuideCatalogId());
                    catalogDownPO.setViewOrder(updateCategoryDO.getViewOrder());
                    Integer updateDownCount = this.uccCatalogDealMapper.updateById(catalogDownPO);
                    if (!ObjectUtils.isEmpty((Object)updateDownCount) && updateDownCount != 0) break;
                    throw new ZTBusinessException("\u7c7b\u76ee\u4fee\u6539\u5931\u8d25");
                }
                if (i == uccCatalogPOList.size() - 1) break;
                UccGuideCatalogPO catalogUpPO = new UccGuideCatalogPO();
                catalogUpPO.setGuideCatalogId(updateCategoryDO.getGuideCatalogId());
                catalogUpPO.setViewOrder(uccCatalogPOList.get(i + 1).getViewOrder());
                Integer updateUpCount = this.uccCatalogDealMapper.updateById(catalogUpPO);
                if (ObjectUtils.isEmpty((Object)updateUpCount) || updateUpCount == 0) {
                    throw new ZTBusinessException("\u7c7b\u76ee\u987a\u5e8f\u4fee\u6539\u5931\u8d25");
                }
                UccGuideCatalogPO catalogDownPO = new UccGuideCatalogPO();
                catalogDownPO.setGuideCatalogId(uccCatalogPOList.get(i + 1).getGuideCatalogId());
                catalogDownPO.setViewOrder(updateCategoryDO.getViewOrder());
                Integer updateDownCount = this.uccCatalogDealMapper.updateById(catalogDownPO);
                if (!ObjectUtils.isEmpty((Object)updateDownCount) && updateDownCount != 0) break;
                throw new ZTBusinessException("\u7c7b\u76ee\u987a\u5e8f\u4fee\u6539\u5931\u8d25");
            }
        }
    }

    private void updateCategoryStatus(UccGuideCatalogDO updateCategoryDO) {
        if (updateCategoryDO.getCatalogStatus() == 0) {
            ArrayList<Long> catalogStatusIds = new ArrayList<Long>();
            List<Long> idLevel2 = new ArrayList<Long>();
            switch (updateCategoryDO.getCatalogLevel()) {
                case 1: {
                    catalogStatusIds.add(updateCategoryDO.getGuideCatalogId());
                    idLevel2 = this.uccCatalogDealMapper.queryAllCatalogByUpperCatalogId(catalogStatusIds);
                    catalogStatusIds.addAll(idLevel2);
                }
                case 2: {
                    if (CollectionUtils.isEmpty(idLevel2)) {
                        idLevel2.add(updateCategoryDO.getGuideCatalogId());
                    }
                    List<Long> idLevel3 = this.uccCatalogDealMapper.queryAllCatalogByUpperCatalogId(idLevel2);
                    catalogStatusIds.addAll(idLevel3);
                }
                case 3: {
                    break;
                }
                default: {
                    throw new ZTBusinessException("\u7c7b\u76ee\u7ea7\u522b\u9519\u8bef");
                }
            }
            this.uccCatalogDealMapper.updateCatalogStatus(catalogStatusIds);
        } else {
            UccGuideCatalogPO modelByLeve2PO = null;
            UccGuideCatalogPO updateStatusPO = new UccGuideCatalogPO();
            updateStatusPO.setCatalogStatus(1);
            switch (updateCategoryDO.getCatalogLevel()) {
                case 3: {
                    updateStatusPO.setGuideCatalogId(updateCategoryDO.getUpperCatalogId());
                    this.uccCatalogDealMapper.updateById(updateStatusPO);
                    modelByLeve2PO = this.uccCatalogDealMapper.getModelBy(updateStatusPO);
                }
                case 2: {
                    if (modelByLeve2PO == null) {
                        updateStatusPO.setGuideCatalogId(updateCategoryDO.getUpperCatalogId());
                    } else {
                        updateStatusPO.setGuideCatalogId(modelByLeve2PO.getUpperCatalogId());
                    }
                    this.uccCatalogDealMapper.updateById(updateStatusPO);
                }
                case 1: {
                    break;
                }
                default: {
                    throw new ZTBusinessException("\u7c7b\u76ee\u7ea7\u522b\u9519\u8bef");
                }
            }
        }
    }

    private void buildTree(UccGuideCatalogDO uccGuideCatalogDO, List<UccGuideCatalogDO> uccCatalogDOList, List<UccGuideCatalogDO> result, Map<Long, List<UccGuideCatalogDO>> pIdGroupMap) {
        UccGuideCatalogDO parent;
        PublicStatusEnum publicStatusEnum;
        if (ObjectUtils.isEmpty(uccGuideCatalogDO.getChilds())) {
            uccGuideCatalogDO.setChildFlag(CommodityConstants.ChildFlag.CHILD_FLAG_NO);
        } else {
            uccGuideCatalogDO.setChildFlag(CommodityConstants.ChildFlag.CHILD_FLAG);
        }
        CatalogLevelEnum catalogLevel = CatalogLevelEnum.getCatalogLevel(uccGuideCatalogDO.getCatalogLevel());
        if (catalogLevel != null) {
            uccGuideCatalogDO.setCatalogLevelDesc(catalogLevel.desc);
        }
        if ((publicStatusEnum = PublicStatusEnum.getPublicStatusDesc(uccGuideCatalogDO.getCatalogStatus())) != null) {
            uccGuideCatalogDO.setCatalogStatusDesc(publicStatusEnum.desc);
        }
        if (ObjectUtils.isEmpty((Object)(parent = (UccGuideCatalogDO)uccCatalogDOList.stream().filter(e -> e.getGuideCatalogId().equals(uccGuideCatalogDO.getUpperCatalogId())).findAny().orElse(null)))) {
            List collect = result.stream().filter(e -> e.getGuideCatalogId().equals(uccGuideCatalogDO.getGuideCatalogId())).collect(Collectors.toList());
            if (collect.isEmpty()) {
                result.add(uccGuideCatalogDO);
            }
            return;
        }
        List<UccGuideCatalogDO> currentList = pIdGroupMap.get(uccGuideCatalogDO.getUpperCatalogId());
        if (CollectionUtils.isEmpty(currentList)) {
            currentList = new ArrayList<UccGuideCatalogDO>();
        }
        currentList.add(uccGuideCatalogDO);
        if (parent.getChilds() == null) {
            parent.setChilds(new ArrayList<UccGuideCatalogDO>());
        }
        if (parent.getChilds().stream().noneMatch(child -> child.getGuideCatalogId().equals(uccGuideCatalogDO.getGuideCatalogId()))) {
            parent.getChilds().add(uccGuideCatalogDO);
        }
        parent.getChilds().sort(Comparator.comparing(UccGuideCatalogDO::getViewOrder));
        this.buildTree(parent, uccCatalogDOList, result, pIdGroupMap);
    }

    private List<UccGuideCatalogDO> convertList(List<UccGuideCatalogPO> listPage) {
        List<UccGuideCatalogPO> queryAllCatalog = this.uccCatalogDealMapper.queryAllCatalog(null);
        ArrayList<UccGuideCatalogDO> rows = new ArrayList<UccGuideCatalogDO>();
        for (UccGuideCatalogPO uccCatalogPO : listPage) {
            List catalogLevel2;
            UccGuideCatalogDO uccChannelCatalogRelQryDO = new UccGuideCatalogDO();
            uccChannelCatalogRelQryDO.setGuideCatalogId(uccCatalogPO.getGuideCatalogId());
            uccChannelCatalogRelQryDO.setCatalogCode(uccCatalogPO.getCatalogCode());
            String catalogName = uccCatalogPO.getCatalogName();
            if (!CollectionUtils.isEmpty(queryAllCatalog) && !CollectionUtils.isEmpty(catalogLevel2 = queryAllCatalog.stream().filter(s -> s.getGuideCatalogId().equals(uccCatalogPO.getUpperCatalogId())).collect(Collectors.toList()))) {
                Long upperCatalog2Id = ((UccGuideCatalogPO)catalogLevel2.get(0)).getUpperCatalogId();
                List catalogLevel1 = queryAllCatalog.stream().filter(s -> s.getGuideCatalogId().equals(upperCatalog2Id)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(catalogLevel1)) {
                    catalogName = ((UccGuideCatalogPO)catalogLevel1.get(0)).getCatalogName() + "/" + ((UccGuideCatalogPO)catalogLevel2.get(0)).getCatalogName() + "/" + catalogName;
                }
            }
            uccChannelCatalogRelQryDO.setCatalogName(catalogName);
            uccChannelCatalogRelQryDO.setCatalogLevel(uccCatalogPO.getCatalogLevel());
            uccChannelCatalogRelQryDO.setUpperCatalogId(uccCatalogPO.getUpperCatalogId());
            uccChannelCatalogRelQryDO.setCatalogStatus(uccCatalogPO.getCatalogStatus());
            PublicStatusEnum publicStatusEnum = PublicStatusEnum.getPublicStatusDesc(uccCatalogPO.getCatalogStatus());
            if (publicStatusEnum != null) {
                uccChannelCatalogRelQryDO.setCatalogStatusDesc(publicStatusEnum.desc);
            }
            rows.add(uccChannelCatalogRelQryDO);
        }
        return rows;
    }
}

