/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.ucc.channel.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.ucc.catalog.UccGuideCatalogDO;
import com.tydic.dyc.pro.ucc.channel.UccChannelDO;
import com.tydic.dyc.pro.ucc.channel.UccChannelSelectListPageReqDO;
import com.tydic.dyc.pro.ucc.channel.UccChannelSelectListPageRspDO;
import com.tydic.dyc.pro.ucc.channel.api.UccChannelRepository;
import com.tydic.dyc.pro.ucc.constant.AppTypeEnum;
import com.tydic.dyc.pro.ucc.constant.ChannelRelatedEnum;
import com.tydic.dyc.pro.ucc.constant.PublicStatusEnum;
import com.tydic.dyc.pro.ucc.dao.UccChannelAppTypeMapper;
import com.tydic.dyc.pro.ucc.dao.UccChannelMapper;
import com.tydic.dyc.pro.ucc.dao.UccGuideCatalogMapper;
import com.tydic.dyc.pro.ucc.dao.UccRelChannelCatalogMapper;
import com.tydic.dyc.pro.ucc.po.UccChannelAppTypePO;
import com.tydic.dyc.pro.ucc.po.UccChannelPO;
import com.tydic.dyc.pro.ucc.po.UccGuideCatalogPO;
import com.tydic.dyc.pro.ucc.po.UccRelChannelCatalogPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccChannelRepositoryImpl
implements UccChannelRepository {
    @Autowired
    @Qualifier(value="newUccChannelMapper")
    private UccChannelMapper uccChannelMapper;
    @Autowired
    @Qualifier(value="newUccChannelAppTypeMapper")
    private UccChannelAppTypeMapper uccChannelAppTypeMapper;
    @Autowired
    @Qualifier(value="newUccRelChannelCatalogMapper")
    private UccRelChannelCatalogMapper uccRelChannelCatalogMapper;
    @Autowired
    @Qualifier(value="newUccGuideCatalogMapper")
    private UccGuideCatalogMapper uccCatalogDealMapper;

    @Override
    public UccChannelSelectListPageRspDO selectListPage(UccChannelSelectListPageReqDO reqDO) {
        Page page = new Page(reqDO.getPageNo(), reqDO.getPageSize());
        UccChannelPO uccChannelPO = (UccChannelPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqDO)), UccChannelPO.class);
        uccChannelPO.setOrderBy("VIEW_ORDER");
        List<UccChannelPO> listPagePO = this.uccChannelMapper.getListPage(uccChannelPO, (Page<UccChannelPO>)page);
        List uccChannelDOS = JSON.parseArray((String)JSON.toJSONString(listPagePO), UccChannelDO.class);
        if (!CollectionUtils.isEmpty(listPagePO)) {
            List<Long> channelIds = listPagePO.stream().map(UccChannelPO::getChannelId).collect(Collectors.toList());
            UccChannelAppTypePO channelAppTypePO = new UccChannelAppTypePO();
            channelAppTypePO.setChannelIds(channelIds);
            List<UccChannelAppTypePO> channelAppTypeList = this.uccChannelAppTypeMapper.getList(channelAppTypePO);
            for (UccChannelDO channelItem : uccChannelDOS) {
                PublicStatusEnum publicStatusDesc = PublicStatusEnum.getPublicStatusDesc(channelItem.getChannelStatus());
                if (publicStatusDesc != null) {
                    channelItem.setChannelStatusDesc(publicStatusDesc.desc);
                }
                ArrayList<Integer> sceneIds = new ArrayList<Integer>();
                ArrayList<String> sceneNames = new ArrayList<String>();
                for (UccChannelAppTypePO appTypeItem : channelAppTypeList) {
                    ChannelRelatedEnum channelRelatedType;
                    if (channelItem.getChannelId().equals(appTypeItem.getChannelId())) {
                        sceneIds.add(appTypeItem.getAppTypes());
                        AppTypeEnum appType = AppTypeEnum.getAppType(appTypeItem.getAppTypes());
                        if (appType != null) {
                            sceneNames.add(appType.desc);
                        }
                    }
                    if ((channelRelatedType = ChannelRelatedEnum.getChannelRelatedType(channelItem.getRelatedType())) == null) continue;
                    channelItem.setRelatedTypeDesc(channelRelatedType.desc);
                }
                channelItem.setSceneIds(sceneIds);
                channelItem.setSceneNames(sceneNames);
            }
        }
        UccChannelSelectListPageRspDO rspDO = new UccChannelSelectListPageRspDO();
        rspDO.setRows(uccChannelDOS);
        rspDO.setPageNo(page.getPageNo());
        rspDO.setRecordsTotal(page.getTotalCount());
        rspDO.setTotal(page.getTotalPages());
        return rspDO;
    }

    @Override
    public void addChannel(UccChannelDO addChannelDO) {
        UccChannelPO uccChannelPO = new UccChannelPO();
        uccChannelPO.setChannelName(addChannelDO.getChannelName());
        UccChannelPO channelName = this.uccChannelMapper.getModelBy(uccChannelPO);
        if (!ObjectUtils.isEmpty((Object)channelName)) {
            throw new ZTBusinessException("\u9891\u9053\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (!ObjectUtils.isEmpty((Object)addChannelDO.getChannelCode())) {
            uccChannelPO.setChannelName(null);
            uccChannelPO.setChannelCode(addChannelDO.getChannelCode());
            UccChannelPO channelCode = this.uccChannelMapper.getModelBy(uccChannelPO);
            if (!ObjectUtils.isEmpty((Object)channelCode)) {
                throw new ZTBusinessException("\u9891\u9053\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
            }
        }
        uccChannelPO = (UccChannelPO)JSON.parseObject((String)JSON.toJSONString((Object)addChannelDO), UccChannelPO.class);
        uccChannelPO.setViewOrder(addChannelDO.getViewOrder() + 1);
        Integer updateCount = this.uccChannelMapper.updateViewOrder(uccChannelPO);
        if (ObjectUtils.isEmpty((Object)updateCount)) {
            throw new ZTBusinessException("\u9891\u9053\u6392\u5e8f\u5b57\u6bb5\u4fee\u6539\u5931\u8d25");
        }
        Integer insertChannel = this.uccChannelMapper.insert(uccChannelPO);
        if (ObjectUtils.isEmpty((Object)insertChannel) || insertChannel == 0) {
            throw new ZTBusinessException("\u9891\u9053\u6dfb\u52a0\u5931\u8d25");
        }
        this.addChannelAppType(addChannelDO, uccChannelPO);
    }

    @Override
    public void updateChannel(UccChannelDO updateChannelDO) {
        Integer updateCount;
        UccChannelPO uccChannelPO = new UccChannelPO();
        uccChannelPO.setChannelId(updateChannelDO.getChannelId());
        UccChannelPO channelPOId = this.uccChannelMapper.getModelBy(uccChannelPO);
        if (ObjectUtils.isEmpty((Object)channelPOId)) {
            throw new ZTBusinessException("\u9891\u9053\u4e0d\u5b58\u5728");
        }
        uccChannelPO.setChannelId(null);
        uccChannelPO.setChannelName(updateChannelDO.getChannelName());
        UccChannelPO channelPOName = this.uccChannelMapper.getModelBy(uccChannelPO);
        if (!ObjectUtils.isEmpty((Object)channelPOName) && !channelPOName.getChannelId().equals(updateChannelDO.getChannelId())) {
            throw new ZTBusinessException("\u9891\u9053\u540d\u79f0\u5df2\u5b58\u5728");
        }
        uccChannelPO.setChannelName(null);
        uccChannelPO.setChannelCode(updateChannelDO.getChannelCode());
        UccChannelPO channelPOCode = this.uccChannelMapper.getModelBy(uccChannelPO);
        if (!ObjectUtils.isEmpty((Object)channelPOCode) && !channelPOCode.getChannelId().equals(updateChannelDO.getChannelId())) {
            throw new ZTBusinessException("\u9891\u9053\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        uccChannelPO = (UccChannelPO)JSON.parseObject((String)JSON.toJSONString((Object)updateChannelDO), UccChannelPO.class);
        if (!channelPOId.getViewOrder().equals(updateChannelDO.getViewOrder())) {
            uccChannelPO.setViewOrder(updateChannelDO.getViewOrder() + 1);
            updateCount = this.uccChannelMapper.updateViewOrder(uccChannelPO);
            if (ObjectUtils.isEmpty((Object)updateCount)) {
                throw new ZTBusinessException("\u9891\u9053\u6392\u5e8f\u5b57\u6bb5\u4fee\u6539\u5931\u8d25");
            }
        }
        if (ObjectUtils.isEmpty((Object)(updateCount = this.uccChannelMapper.updateById(uccChannelPO))) || updateCount == 0) {
            throw new ZTBusinessException("\u9891\u9053\u4fee\u6539\u5931\u8d25");
        }
        this.deleteChannelAppType(updateChannelDO.getChannelId());
        this.addChannelAppType(updateChannelDO, uccChannelPO);
    }

    @Override
    public void deleteChannel(Long channelId) {
        UccChannelPO uccChannelPO = new UccChannelPO();
        uccChannelPO.setChannelId(channelId);
        Integer deleteChannelCount = this.uccChannelMapper.deleteBy(uccChannelPO);
        if (ObjectUtils.isEmpty((Object)deleteChannelCount)) {
            throw new ZTBusinessException("\u9891\u9053\u5220\u9664\u5931\u8d25");
        }
        this.deleteChannelAppType(channelId);
    }

    @Override
    public void addChannelRelatedCategory(Long channelId, List<Long> catalogIds) {
        UccRelChannelCatalogPO deleteChannelRelCatalogPO = new UccRelChannelCatalogPO();
        deleteChannelRelCatalogPO.setChannelId(channelId);
        try {
            this.uccRelChannelCatalogMapper.deleteBy(deleteChannelRelCatalogPO);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u9891\u9053\u5173\u8054\u7c7b\u76ee\u5220\u9664\u5931\u8d25");
        }
        List<Long> upperCatalogIds = this.uccCatalogDealMapper.getUpperCatalogIdListById(catalogIds);
        ArrayList<UccRelChannelCatalogPO> list = new ArrayList<UccRelChannelCatalogPO>();
        catalogIds.addAll(upperCatalogIds);
        for (Long catalogId : catalogIds) {
            UccRelChannelCatalogPO uccRelChannelCatalogPO = new UccRelChannelCatalogPO();
            uccRelChannelCatalogPO.setChannelId(channelId);
            uccRelChannelCatalogPO.setGuideCatalogId(catalogId);
            uccRelChannelCatalogPO.setId(Sequence.getInstance().nextId());
            list.add(uccRelChannelCatalogPO);
        }
        try {
            this.uccRelChannelCatalogMapper.insertBatch(list);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u9891\u9053\u5173\u8054\u7c7b\u76ee\u6dfb\u52a0\u5931\u8d25");
        }
    }

    @Override
    public void deleteChannelRelatedCategory(Long channelId, List<Long> catalogIds) {
        UccRelChannelCatalogPO uccRelChannelCatalogPO = new UccRelChannelCatalogPO();
        uccRelChannelCatalogPO.setChannelId(channelId);
        uccRelChannelCatalogPO.setGuideCatalogIds(catalogIds);
        try {
            this.uccRelChannelCatalogMapper.deleteBy(uccRelChannelCatalogPO);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u9891\u9053\u5173\u8054\u7c7b\u76ee\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public List<UccGuideCatalogDO> selectCatalogByChannel(Long channelId) {
        List<UccGuideCatalogPO> list = this.uccRelChannelCatalogMapper.selectCatalogByChannel(channelId);
        List<UccGuideCatalogDO> listFilterThirdCatalogNull = new ArrayList<UccGuideCatalogDO>();
        if (!CollectionUtils.isEmpty(list)) {
            listFilterThirdCatalogNull = this.createListFilterThirdCatalogNull(list);
        }
        return listFilterThirdCatalogNull;
    }

    private void addChannelAppType(UccChannelDO addChannelDO, UccChannelPO uccChannelPO) {
        ArrayList<UccChannelAppTypePO> list = new ArrayList<UccChannelAppTypePO>();
        for (Integer champion : addChannelDO.getSceneIds()) {
            UccChannelAppTypePO uccChannelAppTypePO = new UccChannelAppTypePO();
            uccChannelAppTypePO.setChannelId(uccChannelPO.getChannelId());
            uccChannelAppTypePO.setAppTypes(champion);
            list.add(uccChannelAppTypePO);
        }
        Integer insertBatchCount = this.uccChannelAppTypeMapper.insertBatch(list);
        if (ObjectUtils.isEmpty((Object)insertBatchCount) || insertBatchCount == 0) {
            throw new ZTBusinessException("\u9891\u9053\u5e94\u7528\u7c7b\u578b\u6dfb\u52a0\u5931\u8d25");
        }
    }

    private void deleteChannelAppType(Long channelId) {
        UccChannelAppTypePO uccChannelAppTypePO = new UccChannelAppTypePO();
        uccChannelAppTypePO.setChannelId(channelId);
        Integer deleteCount = this.uccChannelAppTypeMapper.deleteBy(uccChannelAppTypePO);
        if (ObjectUtils.isEmpty((Object)deleteCount) || deleteCount == 0) {
            throw new ZTBusinessException("\u9891\u9053\u5e94\u7528\u8303\u56f4\u5220\u9664\u5931\u8d25");
        }
    }

    private List<UccGuideCatalogDO> createListFilterThirdCatalogNull(List<UccGuideCatalogPO> list) {
        ArrayList<UccGuideCatalogDO> rows = new ArrayList<UccGuideCatalogDO>();
        List guideCatalogList01 = list.stream().filter(s -> s.getCatalogLevel().equals(1)).map(s -> (UccGuideCatalogDO)JSON.parseObject((String)JSON.toJSONString((Object)s), UccGuideCatalogDO.class)).collect(Collectors.toList());
        Map<Long, List<UccGuideCatalogDO>> uccCatalogDealBOMap = list.stream().filter(s -> !s.getCatalogLevel().equals(1)).map(s -> (UccGuideCatalogDO)JSON.parseObject((String)JSON.toJSONString((Object)s), UccGuideCatalogDO.class)).collect(Collectors.groupingBy(UccGuideCatalogDO::getUpperCatalogId));
        for (UccGuideCatalogDO uccCatalogDealPO : guideCatalogList01) {
            List<UccGuideCatalogDO> uccCatalogDealBOS = uccCatalogDealBOMap.get(uccCatalogDealPO.getGuideCatalogId());
            if (CollectionUtils.isEmpty(uccCatalogDealBOS)) continue;
            boolean addFlag = false;
            ArrayList<UccGuideCatalogDO> secondList = new ArrayList<UccGuideCatalogDO>();
            for (UccGuideCatalogDO catalogDealPO : uccCatalogDealBOS) {
                List<UccGuideCatalogDO> uccMallGuideCatalogBOS = uccCatalogDealBOMap.get(catalogDealPO.getGuideCatalogId());
                if (CollectionUtils.isEmpty(uccMallGuideCatalogBOS)) continue;
                catalogDealPO.setChilds(uccMallGuideCatalogBOS);
                secondList.add(catalogDealPO);
                addFlag = true;
            }
            if (!addFlag) continue;
            uccCatalogDealPO.setChilds(secondList);
            rows.add(uccCatalogDealPO);
        }
        return rows;
    }
}

