/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.ucc.commodity.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.pro.ucc.commodity.UccCommodityTypeDO;
import com.tydic.dyc.pro.ucc.commodity.UccCommodityTypeSelectListPageReqDO;
import com.tydic.dyc.pro.ucc.commodity.UccCommodityTypeSelectListPageRspDO;
import com.tydic.dyc.pro.ucc.commodity.api.UccCommodityRepository;
import com.tydic.dyc.pro.ucc.constant.CommodityConstants;
import com.tydic.dyc.pro.ucc.constant.PublicStatusEnum;
import com.tydic.dyc.pro.ucc.dao.UccCommodityTypeMapper;
import com.tydic.dyc.pro.ucc.dao.UccRCatalogCommodityTypeMapper;
import com.tydic.dyc.pro.ucc.po.UccCommodityTypePO;
import com.tydic.dyc.pro.ucc.po.UccRCatalogCommodityTypePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCommodityRepositoryImpl
implements UccCommodityRepository {
    @Autowired
    @Qualifier(value="newUccCommodityTypeMapper")
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    @Qualifier(value="newUccRCatalogCommodityTypeMapper")
    private UccRCatalogCommodityTypeMapper uccCatalogReCommodityTypeMapper;

    @Override
    public UccCommodityTypeSelectListPageRspDO selectListPage(UccCommodityTypeSelectListPageReqDO reqDO) {
        List uccCommodityTypeDOS;
        List<UccRCatalogCommodityTypePO> list;
        UccRCatalogCommodityTypePO uccRCatalogCommodityTypePo = new UccRCatalogCommodityTypePO();
        uccRCatalogCommodityTypePo.setGuideCatalogId(reqDO.getGuideCatalogId());
        Map<Object, Object> relIdMap = new HashMap();
        try {
            list = this.uccCatalogReCommodityTypeMapper.getList(uccRCatalogCommodityTypePo);
        }
        catch (Exception e2) {
            throw new ZTBusinessException("\u67e5\u8be2\u7c7b\u76ee\u5546\u54c1\u5173\u8054\u8868\u5931\u8d25");
        }
        UccCommodityTypePO uccCommodityTypePo = (UccCommodityTypePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqDO)), UccCommodityTypePO.class);
        if (!CollectionUtils.isEmpty(list)) {
            List<Long> collect = list.stream().map(e -> e.getCommodityTypeId()).collect(Collectors.toList());
            uccCommodityTypePo.setCommodityTypeIds(collect);
            relIdMap = list.stream().collect(Collectors.toMap(e -> e.getCommodityTypeId(), e -> e.getRelId()));
        } else if (CommodityConstants.CommodityQueryType.CATEGORY_RELATED_GOODS.equals(reqDO.getQueryType())) {
            UccCommodityTypeSelectListPageRspDO rspDO = new UccCommodityTypeSelectListPageRspDO();
            rspDO.setRows(new ArrayList());
            rspDO.setPageNo(reqDO.getPageNo());
            rspDO.setRecordsTotal(0);
            rspDO.setTotal(0);
            return rspDO;
        }
        Page page = new Page(reqDO.getPageNo(), reqDO.getPageSize());
        try {
            List<UccCommodityTypePO> uccCommodityTypePos = this.uccCommodityTypeMapper.getListPage(uccCommodityTypePo, (Page<UccCommodityTypePO>)page);
            uccCommodityTypeDOS = JSON.parseArray((String)JSON.toJSONString(uccCommodityTypePos), UccCommodityTypeDO.class);
        }
        catch (Exception e3) {
            throw new ZTBusinessException("\u5206\u9875\u67e5\u8be2\u5931\u8d25");
        }
        for (UccCommodityTypeDO item : uccCommodityTypeDOS) {
            PublicStatusEnum publicStatusDesc = PublicStatusEnum.getPublicStatusDesc(item.getCommodityTypeStatus());
            if (publicStatusDesc != null) {
                item.setCommodityTypeStatusDesc(publicStatusDesc.desc);
            }
            if (!CommodityConstants.CommodityQueryType.CATEGORY_RELATED_GOODS.equals(reqDO.getQueryType())) continue;
            item.setRelId((Long)relIdMap.get(item.getCommodityTypeId()));
        }
        UccCommodityTypeSelectListPageRspDO rspDO = new UccCommodityTypeSelectListPageRspDO();
        rspDO.setRows(uccCommodityTypeDOS);
        rspDO.setPageNo(page.getPageNo());
        rspDO.setRecordsTotal(page.getTotalCount());
        rspDO.setTotal(page.getTotalPages());
        return rspDO;
    }
}

