/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.ucc.measure.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.ucc.constant.PublicStatusEnum;
import com.tydic.dyc.pro.ucc.dao.UccCommodityMeasureMapper;
import com.tydic.dyc.pro.ucc.measure.UccCommodityMeasureDO;
import com.tydic.dyc.pro.ucc.measure.UccCommodityMeasureEditReqDO;
import com.tydic.dyc.pro.ucc.measure.UccCommodityMeasureListQryReqDO;
import com.tydic.dyc.pro.ucc.measure.UccCommodityMeasureListQryRspDO;
import com.tydic.dyc.pro.ucc.measure.api.UccMeasureRepository;
import com.tydic.dyc.pro.ucc.po.UccCommodityMeasurePO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccMeasureRepositoryImpl
implements UccMeasureRepository {
    @Autowired
    @Qualifier(value="newUccCommodityMeasureMapper")
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;

    @Override
    public UccCommodityMeasureListQryRspDO selectMeasureListQry(UccCommodityMeasureListQryReqDO selectDOS) {
        Page page = new Page(selectDOS.getPageNo(), selectDOS.getPageSize());
        UccCommodityMeasurePO uccCommodityMeasurePO = new UccCommodityMeasurePO();
        BeanUtils.copyProperties((Object)((Object)selectDOS), (Object)uccCommodityMeasurePO);
        List<UccCommodityMeasurePO> listPage = null;
        try {
            listPage = this.uccCommodityMeasureMapper.getListPage(uccCommodityMeasurePO, (Page<UccCommodityMeasurePO>)page);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u67e5\u8be2\u8ba1\u91cf\u5355\u4f4d\u5217\u8868\u5931\u8d25");
        }
        ArrayList<UccCommodityMeasureDO> rows = new ArrayList<UccCommodityMeasureDO>();
        if (!CollectionUtils.isEmpty(listPage)) {
            for (UccCommodityMeasurePO item : listPage) {
                UccCommodityMeasureDO uccCommodityMeasureDO = new UccCommodityMeasureDO();
                BeanUtils.copyProperties((Object)item, (Object)uccCommodityMeasureDO);
                PublicStatusEnum publicStatusDesc = PublicStatusEnum.getPublicStatusDesc(item.getStatus());
                if (publicStatusDesc != null) {
                    uccCommodityMeasureDO.setStatusDesc(publicStatusDesc.desc);
                }
                rows.add(uccCommodityMeasureDO);
            }
        }
        UccCommodityMeasureListQryRspDO rspDO = new UccCommodityMeasureListQryRspDO();
        rspDO.setRows(rows);
        rspDO.setPageNo(page.getPageNo());
        rspDO.setRecordsTotal(page.getTotalCount());
        rspDO.setTotal(page.getTotalPages());
        return rspDO;
    }

    @Override
    public void addMeasure(UccCommodityMeasureDO addMeasureDO) {
        UccCommodityMeasurePO uccCommodityMeasurePO = new UccCommodityMeasurePO();
        uccCommodityMeasurePO.setMeasureName(addMeasureDO.getMeasureName());
        UccCommodityMeasurePO wertherHave = this.uccCommodityMeasureMapper.getModelBy(uccCommodityMeasurePO);
        if (!ObjectUtils.isEmpty((Object)wertherHave)) {
            throw new ZTBusinessException("\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0\u5df2\u5b58\u5728");
        }
        BeanUtils.copyProperties((Object)addMeasureDO, (Object)uccCommodityMeasurePO);
        uccCommodityMeasurePO.setMeasureId(Sequence.getInstance().nextId());
        Integer insert = this.uccCommodityMeasureMapper.insert(uccCommodityMeasurePO);
        if (insert == 0 || ObjectUtils.isEmpty((Object)insert)) {
            throw new ZTBusinessException("\u65b0\u589e\u8ba1\u91cf\u5355\u4f4d\u5931\u8d25");
        }
    }

    @Override
    public void editMeasure(UccCommodityMeasureEditReqDO editMeasureDO) {
        List<String> measureNames = editMeasureDO.getMeasureInfo().stream().map(UccCommodityMeasureDO::getMeasureName).collect(Collectors.toList());
        List measureIds = editMeasureDO.getMeasureInfo().stream().map(UccCommodityMeasureDO::getMeasureId).collect(Collectors.toList());
        UccCommodityMeasurePO qryPO = new UccCommodityMeasurePO();
        qryPO.setMeasureNames(measureNames);
        List<UccCommodityMeasurePO> uccCommodityMeasurePOS = this.uccCommodityMeasureMapper.getList(qryPO);
        if (!CollectionUtils.isEmpty(uccCommodityMeasurePOS)) {
            for (String string : measureNames) {
                boolean nameExists = uccCommodityMeasurePOS.stream().anyMatch(po -> po.getMeasureName().equals(string) && !measureIds.contains(po.getMeasureId()));
                if (!nameExists) continue;
                throw new ZTBusinessException("\u8ba1\u91cf\u5355\u4f4d[ " + string + " ]\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        List updatePOS = JSON.parseArray((String)JSON.toJSONString(editMeasureDO.getMeasureInfo()), UccCommodityMeasurePO.class);
        for (UccCommodityMeasurePO item : updatePOS) {
            item.setUpdateTime(new Date());
            item.setUpdateUserId(editMeasureDO.getUserId());
            item.setUpdateUserName(editMeasureDO.getUserName());
            item.setUpdateCompanyId(editMeasureDO.getCompanyId());
            item.setUpdateCompanyName(editMeasureDO.getCompanyName());
            item.setUpdateOrgId(editMeasureDO.getOrgId());
            item.setUpdateOrgName(editMeasureDO.getOrgName());
        }
        Integer n = this.uccCommodityMeasureMapper.updateBatch(updatePOS);
        if (n == null || n == 0) {
            throw new ZTBusinessException("\u8ba1\u91cf\u5355\u4f4d\u4fee\u6539\u5931\u8d25");
        }
    }

    @Override
    public void deleteMeasure(List<Long> measureIds) {
        UccCommodityMeasurePO uccCommodityMeasurePo = new UccCommodityMeasurePO();
        uccCommodityMeasurePo.setMeasureIds(measureIds);
        Integer useCount = this.uccCommodityMeasureMapper.selectSkuByMeasureIds(uccCommodityMeasurePo);
        if (ObjectUtils.isEmpty((Object)useCount) || useCount > 0) {
            throw new ZTBusinessException("\u8ba1\u91cf\u5355\u4f4d\u5df2\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        Integer deleteCount = this.uccCommodityMeasureMapper.deleteBy(uccCommodityMeasurePo);
        if (ObjectUtils.isEmpty((Object)deleteCount)) {
            throw new ZTBusinessException("\u8ba1\u91cf\u5355\u4f4d\u5220\u9664\u5931\u8d25");
        }
    }
}

