/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.ucc.sku.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.ucc.constant.ApprovalStatusEnum;
import com.tydic.dyc.pro.ucc.constant.UccConstants;
import com.tydic.dyc.pro.ucc.dao.ComBatchDealOrderMapper;
import com.tydic.dyc.pro.ucc.dao.ComBatchDealRecordMapper;
import com.tydic.dyc.pro.ucc.po.ComBatchDealOrderPO;
import com.tydic.dyc.pro.ucc.po.ComBatchDealRecordPO;
import com.tydic.dyc.pro.ucc.sku.SkuApprovalStatusDO;
import com.tydic.dyc.pro.ucc.sku.SkuApprovalStatusReqDO;
import com.tydic.dyc.pro.ucc.sku.SkuApprovalStatusRspDO;
import com.tydic.dyc.pro.ucc.sku.api.UccSkuRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccSkuRepositoryImpl
implements UccSkuRepository {
    @Autowired
    private ComBatchDealRecordMapper comBatchDealRecordMapper;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;

    @Override
    public SkuApprovalStatusRspDO skuApprovalStatus(SkuApprovalStatusReqDO reqDO) {
        SkuApprovalStatusRspDO rspDO = this.judge(reqDO);
        HashMap<Long, SkuApprovalStatusDO> objMap = new HashMap();
        ComBatchDealRecordPO dealRecordPO = new ComBatchDealRecordPO();
        dealRecordPO.setObjIdList(reqDO.getObjList().stream().map(SkuApprovalStatusDO::getObjId).distinct().collect(Collectors.toList()));
        dealRecordPO.setObjType(reqDO.getObjType());
        List<ComBatchDealRecordPO> comBatchDealRecordPOList = this.comBatchDealRecordMapper.getList(dealRecordPO);
        if (!CollectionUtils.isEmpty(comBatchDealRecordPOList)) {
            ComBatchDealOrderPO qryPO = new ComBatchDealOrderPO();
            qryPO.setBatchNoList(comBatchDealRecordPOList.stream().map(ComBatchDealRecordPO::getBatchNo).distinct().collect(Collectors.toList()));
            List<ComBatchDealOrderPO> comBatchDealOrderPOList = this.comBatchDealOrderMapper.getList(qryPO);
            HashMap orderPoMap = new HashMap();
            if (!CollectionUtils.isEmpty(comBatchDealOrderPOList)) {
                comBatchDealOrderPOList.stream().collect(Collectors.toMap(ComBatchDealOrderPO::getBatchNo, o -> o, (o1, o2) -> o1));
            }
            Map<Long, ComBatchDealRecordPO> recordPOMap = comBatchDealRecordPOList.stream().collect(Collectors.toMap(ComBatchDealRecordPO::getObjId, o -> o, (o1, o2) -> o1));
            for (SkuApprovalStatusDO skuApprovalStatusDO : reqDO.getObjList()) {
                objMap.put(skuApprovalStatusDO.getObjId(), skuApprovalStatusDO);
                ComBatchDealRecordPO comBatchDealRecordPO = recordPOMap.get(skuApprovalStatusDO.getObjId());
                if (null == comBatchDealRecordPO) continue;
                ComBatchDealOrderPO comBatchDealOrderPO = (ComBatchDealOrderPO)orderPoMap.get(comBatchDealRecordPO.getBatchNo());
                if (null == comBatchDealOrderPO) {
                    if (this.getAuditFlag(comBatchDealRecordPO.getDealType())) {
                        skuApprovalStatusDO.setApprovalStatus(ApprovalStatusEnum.DATA_ING.getApprovalStatus());
                        skuApprovalStatusDO.setApprovalStatusDesc(ApprovalStatusEnum.DATA_ING.getBeforTranslateStr());
                        continue;
                    }
                    skuApprovalStatusDO.setObjStatus(ApprovalStatusEnum.DATA_ING.getApprovalStatus());
                    skuApprovalStatusDO.setObjStatusDesc(ApprovalStatusEnum.DATA_ING.getBeforTranslateStr());
                    continue;
                }
                ApprovalStatusEnum approvalStatusEnum = ApprovalStatusEnum.find(comBatchDealOrderPO.getBusiType() + "-" + comBatchDealOrderPO.getOrderStatus());
                if (null == approvalStatusEnum || approvalStatusEnum.getApprovalStatus().equals(skuApprovalStatusDO.getApprovalStatus())) continue;
                skuApprovalStatusDO.setApprovalStatus(ApprovalStatusEnum.DATA_ING.getApprovalStatus());
                skuApprovalStatusDO.setApprovalStatusDesc(ApprovalStatusEnum.DATA_ING.getBeforTranslateStr());
            }
        } else {
            objMap = reqDO.getObjList().stream().collect(Collectors.toMap(SkuApprovalStatusDO::getObjId, o -> o, (o1, o2) -> o1));
        }
        rspDO.setObjMap(objMap);
        rspDO.setRespCode("0000");
        rspDO.setRespDesc("\u6210\u529f");
        return rspDO;
    }

    private SkuApprovalStatusRspDO judge(SkuApprovalStatusReqDO reqDO) {
        if (CollectionUtils.isEmpty(reqDO.getObjList())) {
            throw new ZTBusinessException("objList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqDO.getObjType())) {
            throw new ZTBusinessException("objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new SkuApprovalStatusRspDO();
    }

    private boolean getAuditFlag(Integer dealType) {
        if (null == dealType) {
            return false;
        }
        ArrayList<Integer> notNeedAuditList = new ArrayList<Integer>();
        notNeedAuditList.add(UccConstants.BatchDealType.COMM_DELETE);
        notNeedAuditList.add(UccConstants.BatchDealType.SKU_FROCE_PUT_OFF);
        notNeedAuditList.add(UccConstants.BatchDealType.SKU_REJECT);
        notNeedAuditList.add(UccConstants.BatchDealType.SKU_RE_TO_PUT_ON);
        notNeedAuditList.add(UccConstants.BatchDealType.SKU_STRATEGY_REJECT);
        notNeedAuditList.add(UccConstants.BatchDealType.SKU_STRATEGY_PASS);
        notNeedAuditList.add(UccConstants.BatchDealType.SKU_RESTORE_STRATEGY);
        notNeedAuditList.add(UccConstants.BatchDealType.SKU_DELETE);
        return !notNeedAuditList.contains(dealType);
    }
}

