/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.ucc.stock.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.pro.ucc.constant.SkuStatusEnum;
import com.tydic.dyc.pro.ucc.dao.UccSaleNumProMapper;
import com.tydic.dyc.pro.ucc.dao.UccSkuStockInfoLogMapper;
import com.tydic.dyc.pro.ucc.dao.UccSkuStockInfoMapper;
import com.tydic.dyc.pro.ucc.po.UccSkuStockInfoDealPO;
import com.tydic.dyc.pro.ucc.po.UccSkuStockInfoPO;
import com.tydic.dyc.pro.ucc.sku.SkuApprovalStatusDO;
import com.tydic.dyc.pro.ucc.sku.SkuApprovalStatusReqDO;
import com.tydic.dyc.pro.ucc.sku.SkuApprovalStatusRspDO;
import com.tydic.dyc.pro.ucc.sku.api.UccSkuRepository;
import com.tydic.dyc.pro.ucc.stock.UccRepositorySkuInfoDO;
import com.tydic.dyc.pro.ucc.stock.UccRepositorySkuStockQryListReqDO;
import com.tydic.dyc.pro.ucc.stock.UccRepositorySkuStockQryListRspDO;
import com.tydic.dyc.pro.ucc.stock.UccSkuStockInfoDO;
import com.tydic.dyc.pro.ucc.stock.UccSkuStockInfoDealDO;
import com.tydic.dyc.pro.ucc.stock.api.UccSkuStockInfoRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSkuStockInfoRepositoryImpl
implements UccSkuStockInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(UccSkuStockInfoRepositoryImpl.class);
    @Autowired
    private UccSkuStockInfoMapper uccSkuStockInfoMapper;
    @Autowired
    private UccSkuStockInfoLogMapper uccSkuStockInfoLogMapper;
    @Autowired
    private UccSaleNumProMapper uccSaleNumMapper;
    @Autowired
    private UccSkuRepository uccSkuRepository;

    @Override
    public void insertSkuStockDeal(List<UccSkuStockInfoDealDO> insertDOS) {
        List insertPOS = JSON.parseArray((String)JSON.toJSONString(insertDOS), UccSkuStockInfoDealPO.class);
        Integer insertCount = this.uccSkuStockInfoMapper.insertBatch(insertPOS);
        if (insertCount == null) {
            throw new ZTBusinessException("\u5e93\u5b58\u8868\u65b0\u589e\u5931\u8d25");
        }
    }

    @Override
    public void updateSkuStockDeal(List<UccSkuStockInfoDealDO> updateDOS) {
        List updatePOS = JSON.parseArray((String)JSON.toJSONString(updateDOS), UccSkuStockInfoDealPO.class);
        Integer updateCount = this.uccSkuStockInfoMapper.updateBatch(updatePOS);
        if (updateCount == null) {
            throw new ZTBusinessException("\u5e93\u5b58\u8868\u4fee\u6539\u5931\u8d25");
        }
        this.addSaleNum(updateDOS);
        Integer insertCount = this.uccSkuStockInfoLogMapper.insertBatch(updatePOS);
        if (insertCount == null) {
            throw new ZTBusinessException("\u5e93\u5b58\u65e5\u5fd7\u8868\u4fee\u6539\u5931\u8d25");
        }
    }

    @Override
    public void deleteSkuStockDeal(List<UccSkuStockInfoDealDO> deleteDOS) {
        List deletePOS = JSON.parseArray((String)JSON.toJSONString(deleteDOS), UccSkuStockInfoDealPO.class);
        Integer deleteCount = this.uccSkuStockInfoMapper.deleteBatch(deletePOS);
        if (deleteCount == null) {
            throw new ZTBusinessException("\u5e93\u5b58\u8868\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public List<UccSkuStockInfoDO> selectSkuStock(List<Long> skuIdList) {
        List<UccSkuStockInfoPO> selectStockPOList = this.uccSkuStockInfoMapper.selectSkuStock(skuIdList);
        List selectStockDOList = null;
        if (selectStockPOList == null || CollectionUtils.isEmpty(selectStockPOList)) {
            throw new ZTBusinessException("\u5e93\u5b58\u8868\u67e5\u8be2\u4e3a\u7a7a");
        }
        selectStockDOList = JSON.parseArray((String)JSON.toJSONString(selectStockPOList), UccSkuStockInfoDO.class);
        return selectStockDOList;
    }

    @Override
    public UccRepositorySkuStockQryListRspDO skuStockQryList(UccRepositorySkuStockQryListReqDO reqDO) {
        UccRepositorySkuStockQryListRspDO uccManageSkuStockQryListRspDO = new UccRepositorySkuStockQryListRspDO();
        Page page = new Page(reqDO.getPageNo(), reqDO.getPageSize());
        List<UccRepositorySkuInfoDO> uccRepositorySkuInfoDOS = this.uccSkuStockInfoMapper.selectAll(reqDO, (Page<UccRepositorySkuInfoDO>)page);
        ArrayList<UccRepositorySkuInfoDO> infoDOList = new ArrayList<UccRepositorySkuInfoDO>();
        SkuApprovalStatusReqDO skuApprovalStatusReqDO = new SkuApprovalStatusReqDO();
        skuApprovalStatusReqDO.setObjType(1);
        ArrayList<SkuApprovalStatusDO> objList = new ArrayList<SkuApprovalStatusDO>();
        for (UccRepositorySkuInfoDO uccRepositorySkuInfoDO : uccRepositorySkuInfoDOS) {
            SkuApprovalStatusDO skuApprovalStatusDO = new SkuApprovalStatusDO();
            if (uccRepositorySkuInfoDO.getSkuStatus() != null) {
                SkuStatusEnum skuStatusEnum = SkuStatusEnum.getSkustatusDesc(uccRepositorySkuInfoDO.getSkuStatus());
                uccRepositorySkuInfoDO.setSkuStatusDesc(skuStatusEnum.desc);
            }
            skuApprovalStatusDO.setObjId(uccRepositorySkuInfoDO.getSkuId());
            skuApprovalStatusDO.setObjStatus(uccRepositorySkuInfoDO.getSkuStatus());
            skuApprovalStatusDO.setObjStatusDesc(uccRepositorySkuInfoDO.getSkuStatusDesc());
            objList.add(skuApprovalStatusDO);
            infoDOList.add(uccRepositorySkuInfoDO);
        }
        skuApprovalStatusReqDO.setObjList(objList);
        SkuApprovalStatusRspDO rspDO = this.uccSkuRepository.skuApprovalStatus(skuApprovalStatusReqDO);
        if (!"0000".equals(rspDO.getRespCode())) {
            new ZTBusinessException(rspDO.getRespDesc());
        }
        if (CollectionUtils.isEmpty(rspDO.getObjMap())) {
            throw new ZTBusinessException("\u5ba1\u6279\u72b6\u6001\u67e5\u8be2\u4e3a\u7a7a");
        }
        for (UccRepositorySkuInfoDO uccRepositorySkuInfoDO : infoDOList) {
            uccRepositorySkuInfoDO.setSkuApproveStatus(rspDO.getObjMap().get(uccRepositorySkuInfoDO.getSkuId()).getApprovalStatus());
        }
        List list = infoDOList.stream().map(a -> {
            a.setSkuApproveStatusDesc(rspDO.getObjMap().get(a.getSkuId()).getApprovalStatusDesc());
            a.setSkuApproveStatus(rspDO.getObjMap().get(a.getSkuId()).getApprovalStatus());
            return a;
        }).collect(Collectors.toList());
        uccManageSkuStockQryListRspDO.setRows(list);
        uccManageSkuStockQryListRspDO.setTotal(page.getTotalPages());
        uccManageSkuStockQryListRspDO.setPageNo(page.getPageNo());
        uccManageSkuStockQryListRspDO.setRecordsTotal(page.getTotalCount());
        return uccManageSkuStockQryListRspDO;
    }

    @Override
    public Long selectStockIdBySkuId(Long skuId) {
        Long stockId = this.uccSkuStockInfoMapper.selectStockIdBySkuId(skuId);
        if (stockId == null) {
            throw new ZTBusinessException(skuId + "\u4e0b\u7684\u5e93\u5b58id\u4e3a\u7a7a");
        }
        return stockId;
    }

    public void addSaleNum(List<UccSkuStockInfoDealDO> addSaleList) {
        List uccSkuStockInfoDealPOS = JSON.parseArray((String)JSON.toJSONString(addSaleList), UccSkuStockInfoDealPO.class);
        List addSaleCollect = uccSkuStockInfoDealPOS.stream().map(a -> {
            a.setDealNum(a.getDealNum().negate());
            return a;
        }).collect(Collectors.toList());
        Long aLong = this.uccSaleNumMapper.addSaleNum(uccSkuStockInfoDealPOS);
        if (aLong <= 0L) {
            throw new ZTBusinessException("\u589e\u52a0\u9500\u91cf\u5931\u8d25");
        }
    }
}

