package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.core.dictionary.annotation.DictField;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocQryChngOrderDetailsRspInfoBo
 * 说明:详情信息
 * 时间:2022/3/14 21:35
 * 作者:罗有
 */

@Data
@EqualsAndHashCode(callSuper=false)
public class UocQryChngOrderDetailsRspInfoBo implements Serializable {
    private static final long serialVersionUID = -6639128337078748521L;

    //变更单id")
    private Long chngOrderId;

    //订单id")
    private Long orderId;

    //销售单id")
    private Long saleOrderId;

    //销售单编码")
    private String saleOrderNo;

    //销售单状态")
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.SALE_ORD_STATE.P_CODE)
    private String saleOrderState;

    //销售单状态翻译")
    private String saleOrderStateStr;

    //发货单编号")
    private String shipOrderNo;

    //业务类型 1:异常变更 2订单调价3订单取消")
    private Integer busiType;

    //变更类型 1:状态变更 2:采购价变更 3:销售价变更 4:加价率变更")
    @DictField(busiCenter = "UOC_PRO",pCode = UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE)
    private Integer chngType;

    //变更类型翻译")
    private String chngTypeStr;

    //变更单编号")
    private String chngOrderNo;

    //变更单状态")
    private String chngOrderState;

    //变更单状态 翻译")
    private String chngOrderStateStr;

    //租户ID")
    private String tenantId;

    //申请时间")
    private Date createTime;

    //申请人工号")
    private String createOperId;

    //申请人名称")
    private String createOperName;

    //创建手机号")
    private String createOperMobile;

    //更新时间")
    private Date updateTime;

    //更新工号")
    private String updateOperId;

    //更新人名称")
    private String updateOperName;

    //备注")
    private String remark;

    //删除标志1已删除")
    private Integer delTag;

    //撤单时间")
    private Date cancelTime;

    //撤单工号")
    private String cancelOperId;

    //撤单人名称")
    private String cancelOperName;

    //取消原因")
    private String cancelReason;

    //回复原因")
    private String rejectReason;

    //回复时间")
    private Date rejectTime;

    //订单编号")
    private String orderNo;

    //订单时间")
    private Date orderTime;

    //订单状态")
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.ORD_STATE.P_CODE)
    private String orderState;

    //订单状态翻译")
    private String orderStateStr;

    //运费")
    private BigDecimal totalTransFee;

    //销售金额")
    private BigDecimal totalSaleFee;

    //商品金额")
    private BigDecimal commodityFee;

    //采购方机构名称")
    private String purOrgName;

    //供应商名称")
    private String supName;

    //交易模式")
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.MODEL_SETTLE.P_CODE)
    private Integer modelSettle;

    //交易模式翻译")
    private String modelSettleStr;

    //退款/扣款标志  0 扣款  1 退款")
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.INTER_TYPE.P_CODE)
    private Integer interType;

    //退款/扣款标志翻译")
    private String interTypeStr;

    //实付金额")
    private BigDecimal payFee;

    //发货单明细IDList")
    private List<Long> shipOrderItemIdList;

    //订单来源  1 自营单品   2 电商导入   3 协议生成    ")
    private Integer orderSource;

    //协议信息")
    private UocQryChngOrderDetailsRspInfoAgreementDataBo chngAgreementInfo;

    //商品明细")
    private List<UocQryChngOrderDetailsRspInfoItemBo> chngOrderItemList;

    //附件")
    private List<UocBaseOrderAccessoryTypeDetailBo> chngOrderAccessoryList;
    
    
    //商品金额(采购价)")
    private BigDecimal commodityPurchaseFee;
    
    //销售金额（采购价）")
    private BigDecimal totalPurchasefFee;
    //验收单号")
    private String inspOrderNo;
    
}
