package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.core.dictionary.annotation.DictField;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 标题:UocQryOrderCreateResultServiceRspProcessDataBo
 * 说明:
 * 时间:2022/2/22 10:59
 * 作者:田桂银
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocQryOrderCreateResultServiceRspProcessDataBo implements Serializable {

    private static final long serialVersionUID = -1807759717649377866L;

    //销售单id", required = true)
    private Long saleOrderId;

    //销售订单编码", required = true)
    private String saleOrderNo;

    //供应商id", required = true)
    private String supNo;

    //供应商名称", required = true)
    private String supName;

    //处理消息，如果失败，则返回")
    private String msg;

    //金额")
    private BigDecimal fee;

    //订单来源")
    private Integer orderSource;

    //支付类型")
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.PAY_TYPE.P_CODE, targetField = "payTypeName")
    private String payType;

    private String payTypeStr;

    //支付类型名称")
    private String payTypeName;

    //结果描述编码 1：成功  2：处理中  3：失败")
    private Integer resultCode;

    //结果描述(成功，失败，处理中)")
    private String resultDescription;

    //卖方")
    private String seller;
    
    /**
     * 销售单明细信息
     */
    private List<UocGetSaleOrderDetailServiceRspItemBo> commodityInfo;

}


