package com.tydic.dyc.oc.service.order.bo;


import com.tydic.dyc.base.core.dictionary.annotation.DictField;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题：UocProOrderEffectiveInfoBo
 * 说明：订单时效类配置列表分页查询API 信息
 * 时间：2021/4/2 14:42
 * 作者 何秀全
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocProOrderEffectiveInfoBo implements Serializable {
    private static final long serialVersionUID = 7019209603165847129L;
    /**
     * 时效配置ID 主键
     */
    //时效配置ID 主键//
    private Long effectiveId;
    /**
     * 时效配置编码
     * 1：电商预占库存时限；2：订单确认付款时限
     */
    //时效配置编码 1：电商预占库存时限；2：订单确认付款时限//
    @DictField(busiCenter = "UOC_PRO",pCode = UocConstant.EFFECTIVE_CODE,targetField = "effectiveName")
    private String effectiveCode;
    /**
     * 时效配置名称
     */
    //时效配置名称//
    private String effectiveName;
    /**
     * 业务类型编码
     */
    //业务类型编码//
    @DictField(busiCenter = "UOC_PRO",pCode = UocDicConstant.ORDER_SOURCE_EFFECTIVE.P_CODE,targetField = "businessTypeName")
    private String businessTypeCode;
    /**
     * 业务类型名称
     */
    //业务类型名称//
    private String businessTypeName;
    /**
     * 供应商编码
     */
    //供应商编码//
    private String supplierNo;
    /**
     * 供应商名称
     */
    //供应商名称//
    private String supplierName;
    /**
     * 时效 毫秒数
     */
    //时效 毫秒数//
    private Long aging;
    /**
     * 来源编码
     * 0：系统；1：自定义
     */
    //来源编码 0：系统；1：自定义//
    @DictField(busiCenter = "UOC_PRO",pCode = UocConstant.SOURCE_CODE,targetField = "sourceName")
    private String sourceCode;
    /**
     * 来源名称
     */
    //来源名称//
    private String sourceName;
    /**
     * 操作时间
     */
    //操作时间//
    private Date operatingTime;
    /**
     * 操作人ID
     */
    //操作人ID//
    private String operatorId;
    /**
     * 操作人名称
     */
    //操作人名称//
    private String operatorName;
}
