/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderObjQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class UocEsSyncShip
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncShip.class);
    private static final String SHIP_ORDER_ITEM_KEY = "shipOrderItemBoList";
    private static final String SHIP_ORDER_ITEM_ID_KEY = "shipOrderItemIdList";
    private static final String BUSI_TYPE = "busiType";
    private static final String STREAM_FEE = "streamFee";
    private static final String ES_SHIP_ARRIVAL_ORDER_ACCESSORY_KEY = "orderArrivalAccessoryBoList";
    private static final String ES_SHIP_REGIST_ORDER_ACCESSORY_KEY = "orderRegistAccessoryBoList";
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getShipOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocShipOrderDo uocShipOrderDo = this.getShipOrderMain(reqBo);
        if (null == uocShipOrderDo) {
            return iUocEsSyncQryRspBo;
        }
        if (uocShipOrderDo.getShipTime() == null) {
            uocShipOrderDo.setShipTime(uocShipOrderDo.getCreateTime());
        }
        JSONObject shipOrder = JSON.parseObject((String)JSON.toJSONString((Object)uocShipOrderDo));
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getExtParallelBoList())) {
            uocShipOrderDo.getExtParallelBoList().forEach(uocShipOrderMap -> shipOrder.put(uocShipOrderMap.getFieldCode(), (Object)uocShipOrderMap.getFieldValue()));
        }
        UocShipOrderDo uocShipOrderDoItem = this.getShipOrderItem(uocShipOrderDo);
        uocShipOrderDo.setShipOrderItemBoList(uocShipOrderDoItem.getShipOrderItemBoList());
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            Map<Long, UocSaleOrderItem> saleItemMap = this.getSaleItem(uocShipOrderDo);
            JSONArray shipOrdeItemArray = new JSONArray();
            BigDecimal[] saleFee = new BigDecimal[]{BigDecimal.ZERO};
            BigDecimal[] purFee = new BigDecimal[]{BigDecimal.ZERO};
            uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
                JSONObject shipOrderItemJson = JSON.parseObject((String)JSON.toJSONString((Object)uocShipOrderItem));
                if (!CollectionUtils.isEmpty(uocShipOrderItem.getItemExtParallelBoList())) {
                    uocShipOrderItem.getItemExtParallelBoList().forEach(uocShipItemMap -> shipOrderItemJson.put(uocShipItemMap.getFieldCode(), (Object)uocShipItemMap.getFieldValue()));
                }
                if (ObjectUtil.isNotEmpty((Object)saleItemMap) && saleItemMap.containsKey(uocShipOrderItem.getSaleOrderItemId())) {
                    this.putSaleItem(shipOrderItemJson, (UocSaleOrderItem)((Object)((Object)saleItemMap.get(uocShipOrderItem.getSaleOrderItemId()))), (UocShipOrderItem)uocShipOrderItem, uocShipOrderDo);
                    if (!Objects.isNull(shipOrderItemJson.getBigDecimal("purFee"))) {
                        purFee[0] = purFee[0].add(shipOrderItemJson.getBigDecimal("purFee"));
                    }
                    if (!Objects.isNull(shipOrderItemJson.getBigDecimal("saleFee"))) {
                        saleFee[0] = saleFee[0].add(shipOrderItemJson.getBigDecimal("saleFee"));
                    }
                }
                shipOrdeItemArray.add((Object)shipOrderItemJson);
            });
            shipOrder.put(SHIP_ORDER_ITEM_KEY, (Object)shipOrdeItemArray);
            List shipOrderItemList = uocShipOrderDoItem.getShipOrderItemIdList().stream().map(Objects::toString).collect(Collectors.toList());
            shipOrder.put(SHIP_ORDER_ITEM_ID_KEY, shipOrderItemList);
            shipOrder.put("saleFee", (Object)saleFee[0]);
            shipOrder.put("purFee", (Object)purFee[0]);
        }
        this.putOutOrderInfo(reqBo, shipOrder);
        this.putSaleOrder(uocShipOrderDo, shipOrder);
        this.putAfOrder(uocShipOrderDo, shipOrder);
        this.putAfInspOrder(uocShipOrderDoItem, shipOrder);
        this.putTask(reqBo, shipOrder);
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        accessoryQryBo.setObjId(uocShipOrderDo.getShipOrderId());
        accessoryQryBo.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_CONFIRM);
        List<UocOrderAccessory> accessoryList = this.iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            shipOrder.put(ES_SHIP_ARRIVAL_ORDER_ACCESSORY_KEY, (Object)JSONArray.parseArray((String)JSON.toJSONString(accessoryList)));
        }
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        accessoryQryBo.setObjId(uocShipOrderDo.getShipOrderId());
        accessoryQryBo.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_REGIST);
        accessoryList = this.iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            shipOrder.put(ES_SHIP_REGIST_ORDER_ACCESSORY_KEY, (Object)JSONArray.parseArray((String)JSON.toJSONString(accessoryList)));
        }
        this.putStr(shipOrder, uocShipOrderDo);
        this.putEnableStateChngFlag(uocShipOrderDo, shipOrder);
        this.putArriveRegistAccessoryList(uocShipOrderDo, shipOrder);
        iUocEsSyncQryRspBo.setJsonObj(shipOrder);
        log.info("\u53d1\u8d27\u5355ES\u6570\u636e:{}", (Object)shipOrder.toJSONString());
        return iUocEsSyncQryRspBo;
    }

    private void putEnableStateChngFlag(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder) {
        BigDecimal decimal;
        shipOrder.put("enableStatChng", (Object)true);
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocAfOrderObjQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        List<UocAfOrderObj> afOrderObjList = this.iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
        if (CollectionUtil.isNotEmpty(afOrderObjList)) {
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
            uocAfOrderQryBo.setAfOrderId(afOrderObjList.get(0).getAfOrderId());
            UocAfOrder afOrderById = this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
            Integer servState = afOrderById.getServState();
            if (!UocDicConstant.SERVICE_STATE.CANCEL.equals(servState)) {
                shipOrder.put("enableStatChng", (Object)false);
            }
        }
        shipOrder.put("progressChngFlag", (Object)((decimal = uocShipOrderDo.getShipOrderItemBoList().stream().map(UocShipOrderItem::getChngingCount).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.ZERO) != 0 ? 1 : 0));
    }

    private void putArriveRegistAccessoryList(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder) {
        UocOrderAccessoryQryBo bo = new UocOrderAccessoryQryBo();
        bo.setOrderId(uocShipOrderDo.getOrderId());
        bo.setObjId(uocShipOrderDo.getShipOrderId());
        bo.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_REGIST);
        List<UocOrderAccessory> orderAccessoryList = this.iUocOrderModel.getOrderAccessoryList(bo);
        log.info("\u5230\u8d27\u767b\u8bb0\u9644\u4ef6\u51fa\u53c2\uff1a" + JSON.toJSONString(orderAccessoryList));
        if (!CollectionUtils.isEmpty(orderAccessoryList)) {
            shipOrder.put("arriveRegistAccessoryList", orderAccessoryList);
        }
    }

    private void putAfOrder(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder) {
        List<UocAfOrder> afOrderList = this.getAfOrderList(uocShipOrderDo);
        Boolean isAfFinishFlag = false;
        if (ObjectUtil.isNotEmpty(afOrderList)) {
            for (UocAfOrder afOrder : afOrderList) {
                if (!Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.SUMIT_APPLICATION) && !Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.APPROVAL_PASS) && !Objects.equals(afOrder.getServState(), UocDicConstant.SERVICE_STATE.REMARK_COMPLATE)) continue;
                isAfFinishFlag = true;
            }
        }
        shipOrder.put("isExistFinishAfOrderExt", (Object)isAfFinishFlag);
        shipOrder.put("isExistFinishAfOrderExtStr", (Object)(isAfFinishFlag != false ? "\u662f" : "\u5426"));
    }

    private List<UocAfOrder> getAfOrderList(UocShipOrderDo uocShipOrderDo) {
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocAfOrderObjQryBo.setOrderId(uocShipOrderDo.getOrderId());
        uocAfOrderObjQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        List<UocAfOrderObj> afOrderObjList = this.iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
        List<UocAfOrder> afOrderList = new ArrayList<UocAfOrder>();
        if (!CollectionUtils.isEmpty(afOrderObjList)) {
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
            uocAfOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
            uocAfOrderQryBo.setAfOrderIds(afOrderObjList.stream().map(obj -> obj.getAfOrderId()).collect(Collectors.toList()));
            afOrderList = this.iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
        }
        return afOrderList;
    }

    private void putOutOrderInfo(IUocEsSyncQryReqBo reqBo, JSONObject shipOrder) {
        List<UocOrderQueryIndex> queryIndexs = this.getQueryIndexs(reqBo);
        if (ObjectUtil.isNotEmpty(queryIndexs)) {
            UocOrderQueryIndex queryIndex = queryIndexs.get(0);
            shipOrder.put("outOrderId", (Object)queryIndex.getOutObjId());
        }
    }

    private void putAfInspOrder(UocShipOrderDo shipItem, JSONObject shipOrder) {
        List<UocShipOrderItem> shipList = shipItem.getShipOrderItemBoList();
        long sum = shipList.stream().collect(Collectors.summarizingInt(obj -> obj.getInspCount().intValue())).getSum();
        if ("FH_FH_YDH".equals(shipItem.getShipOrderState()) && sum > 0L) {
            shipOrder.put("shipAfFlag", (Object)"0");
        } else {
            shipOrder.put("shipAfFlag", (Object)"1");
        }
    }

    private void putTask(IUocEsSyncQryReqBo reqBo, JSONObject shipOrder) {
        UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = this.getProcInst(reqBo, false);
        shipOrder.put("busiTaskList", (Object)busiProcInst.getTaskList());
    }

    private void putSaleOrder(UocShipOrderDo uocShipOrderDo, JSONObject shipOrder) {
        List<UocSaleOrderMap> saleOrderMapList;
        UocSaleOrderDo uocSaleOrderDo = this.getSaleOrder(uocShipOrderDo);
        if (null != uocSaleOrderDo) {
            UocSaleStakeholder stakeholder;
            shipOrder.put("saleOrderNo", (Object)uocSaleOrderDo.getSaleOrderNo());
            shipOrder.put("saleOrderNoExt", (Object)uocSaleOrderDo.getSaleOrderNoExt());
            shipOrder.put("saleOrderState", (Object)uocSaleOrderDo.getSaleOrderState());
            shipOrder.put("saleOrderStateStr", DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"UOC_SALE_ORDER_STATE", (String)uocSaleOrderDo.getSaleOrderState()) == null ? null : DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"UOC_SALE_ORDER_STATE", (String)uocSaleOrderDo.getSaleOrderState()).getValue());
            shipOrder.put("orderCreateTime", (Object)uocSaleOrderDo.getCreateTime());
            shipOrder.put("orderCreateOperName", (Object)uocSaleOrderDo.getCreateOperName());
            shipOrder.put("orderSource", (Object)uocSaleOrderDo.getOrderSource().toString());
            shipOrder.put("payType", (Object)uocSaleOrderDo.getPayType());
            shipOrder.put("payTypeStr", DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"UOC_SALE_ORDER_PAY_TYPE", (String)uocSaleOrderDo.getPayType()) == null ? null : DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"UOC_SALE_ORDER_PAY_TYPE", (String)uocSaleOrderDo.getPayType()).getValue());
            if (null != uocSaleOrderDo.getJdCz()) {
                shipOrder.put("vendorOrderType", (Object)uocSaleOrderDo.getJdCz());
                shipOrder.put("vendorOrderTypeStr", DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"VENDOR_ORDER_TYPE", (String)uocSaleOrderDo.getJdCz().toString()) == null ? null : DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"VENDOR_ORDER_TYPE", (String)uocSaleOrderDo.getJdCz().toString()).getValue());
            }
            if (null != (stakeholder = uocSaleOrderDo.getStakeholder())) {
                shipOrder.put("supId", (Object)stakeholder.getSupId());
                shipOrder.put("supName", (Object)stakeholder.getSupName());
                shipOrder.put("proId", (Object)stakeholder.getProId());
                shipOrder.put("purCompanyId", (Object)stakeholder.getPurCompanyId());
                shipOrder.put("purCompanyName", (Object)stakeholder.getPurCompanyName());
                shipOrder.put("purCompanyNo", (Object)stakeholder.getPurCompanyNo());
                shipOrder.put("purUserId", (Object)stakeholder.getPurUserId());
                shipOrder.put("purOrgId", (Object)stakeholder.getPurOrgId());
                shipOrder.put("purOrgName", (Object)stakeholder.getPurOrgName());
                shipOrder.put("purOrgNo", (Object)stakeholder.getPurOrgNo());
                shipOrder.put("purOrgPath", (Object)stakeholder.getPurOrgPath());
                shipOrder.put("supOrgPath", (Object)stakeholder.getSupOrgPath());
                shipOrder.put("proOrgPath", (Object)stakeholder.getProOrgPath());
            }
        }
        if (null != (saleOrderMapList = this.getSaleOrderMapList(uocShipOrderDo))) {
            saleOrderMapList.forEach(each -> shipOrder.put(each.getFieldCode(), (Object)each.getFieldValue()));
        }
    }

    private List<UocSaleOrderMap> getSaleOrderMapList(UocShipOrderDo reqBo) {
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        return this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    private void putStr(JSONObject shipOrder, UocShipOrderDo uocShipOrderDo) {
        shipOrder.put("shipOrderStateStr", (Object)(DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"SHIP_ORDER_STATE", (String)uocShipOrderDo.getShipOrderState()) == null ? "" : DictFrameworkUtils.getDictDataByCode((String)"UOC_PRO", (String)"SHIP_ORDER_STATE", (String)uocShipOrderDo.getShipOrderState()).getValue()));
    }

    private void putSaleItem(JSONObject shipOrderItemJson, UocSaleOrderItem uocSaleOrderItem, UocShipOrderItem uocShipOrderItem, UocShipOrderDo uocShipOrderDo) {
        if (null != uocSaleOrderItem) {
            shipOrderItemJson.put("supplierId", (Object)uocSaleOrderItem.getSupplierId());
            shipOrderItemJson.put("supplierShopId", (Object)uocSaleOrderItem.getSupplierShopId());
            shipOrderItemJson.put("commodityId", (Object)uocSaleOrderItem.getCommodityId());
            shipOrderItemJson.put("commodityCode", (Object)uocSaleOrderItem.getCommodityCode());
            shipOrderItemJson.put("commodityName", (Object)uocSaleOrderItem.getCommodityName());
            shipOrderItemJson.put("commodityTypeId", (Object)uocSaleOrderItem.getCommodityTypeId());
            shipOrderItemJson.put("skuName", (Object)uocSaleOrderItem.getSkuName());
            shipOrderItemJson.put("skuId", (Object)uocSaleOrderItem.getSkuId());
            shipOrderItemJson.put("skuCode", (Object)uocSaleOrderItem.getSkuCode());
            shipOrderItemJson.put("skuMaterialId", (Object)uocSaleOrderItem.getSkuMaterialId());
            shipOrderItemJson.put("skuMaterialCode", (Object)uocSaleOrderItem.getSkuMaterialCode());
            shipOrderItemJson.put("skuMainPicUrl", (Object)uocSaleOrderItem.getSkuMainPicUrl());
            shipOrderItemJson.put("skuMaterialName", (Object)uocSaleOrderItem.getSkuMaterialName());
            shipOrderItemJson.put("skuMaterialTypeId", (Object)uocSaleOrderItem.getSkuMaterialTypeId());
            shipOrderItemJson.put("skuMaterialTypeName", (Object)uocSaleOrderItem.getSkuMaterialTypeName());
            shipOrderItemJson.put("model", (Object)uocSaleOrderItem.getModel());
            shipOrderItemJson.put("spec", (Object)uocSaleOrderItem.getSpec());
            shipOrderItemJson.put("tax", (Object)uocSaleOrderItem.getTax());
            shipOrderItemJson.put("taxId", (Object)uocSaleOrderItem.getTaxId());
            shipOrderItemJson.put("taxPrice", (Object)uocSaleOrderItem.getTaxPrice());
            shipOrderItemJson.put("l1Catalog", (Object)uocSaleOrderItem.getL1Catalog());
            shipOrderItemJson.put("l1CatalogName", (Object)uocSaleOrderItem.getL1CatalogName());
            shipOrderItemJson.put("l2Catalog", (Object)uocSaleOrderItem.getL2Catalog());
            shipOrderItemJson.put("l2CatalogName", (Object)uocSaleOrderItem.getL2CatalogName());
            shipOrderItemJson.put("l3Catalog", (Object)uocSaleOrderItem.getL3Catalog());
            shipOrderItemJson.put("l3CatalogName", (Object)uocSaleOrderItem.getL3CatalogName());
            shipOrderItemJson.put("salePrice", (Object)uocSaleOrderItem.getSalePrice());
            shipOrderItemJson.put("unitDigit", (Object)(StringUtils.isEmpty((Object)uocSaleOrderItem.getUnitDigit()) ? "" : uocSaleOrderItem.getUnitDigit()));
            shipOrderItemJson.put("skuExtSkuId", (Object)uocSaleOrderItem.getSkuExtSkuId());
            BigDecimal afterCountEnable = BigDecimal.ZERO;
            if (uocShipOrderItem.getSendCount() != null && uocShipOrderItem.getReturnCount() != null && uocShipOrderItem.getAfterServingCount() != null) {
                afterCountEnable = uocShipOrderItem.getSendCount().subtract(uocShipOrderItem.getReturnCount()).subtract(uocShipOrderItem.getAfterServingCount());
            }
            shipOrderItemJson.put("availableAfServCount", (Object)afterCountEnable);
            if (null != uocSaleOrderItem.getSalePrice() && null != uocShipOrderItem.getSendCount()) {
                shipOrderItemJson.put("saleFee", (Object)uocSaleOrderItem.getSalePrice().multiply(uocShipOrderItem.getSendCount()));
            }
            if (null != uocSaleOrderItem.getPurchasePrice() && null != uocShipOrderItem.getSendCount()) {
                shipOrderItemJson.put("purFee", (Object)uocSaleOrderItem.getPurchasePrice().multiply(uocShipOrderItem.getSendCount()));
            }
            shipOrderItemJson.put("purPrice", (Object)uocSaleOrderItem.getPurchasePrice());
            shipOrderItemJson.put("purchaseCount", (Object)uocSaleOrderItem.getPurchaseCount());
            shipOrderItemJson.put("rejectAllowDate", (Object)uocSaleOrderItem.getRejectAllowDate());
            shipOrderItemJson.put("exchangeAllowDate", (Object)uocSaleOrderItem.getExchangeAllowDate());
            shipOrderItemJson.put("maintainAllowDate", (Object)uocSaleOrderItem.getMaintainAllowDate());
            shipOrderItemJson.put("arrivalTime", (Object)uocSaleOrderItem.getPreOfferTime());
        }
    }

    private Map<Long, UocSaleOrderItem> getSaleItem(UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        }
        return new HashMap<Long, UocSaleOrderItem>();
    }

    private UocSaleOrderDo getSaleOrder(UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocOrderQueryIndex> getQueryIndexs(IUocEsSyncQryReqBo reqBo) {
        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderId(reqBo.getOrderId());
        queryIndexQryBo.setObjId(reqBo.getObjId());
        queryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        return this.iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
    }

    private UocShipOrderDo getShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
    }

    private UocShipOrderDo getShipOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderId(reqBo.getObjId());
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    private List<UocGetSaleOrderDetailServiceRspTaskBo> getBusiTaskInstList(IUocEsSyncQryReqBo reqBo) {
        List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<UocGetSaleOrderDetailServiceRspTaskBo>();
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getOrderId());
        taskInstQryBo.setObjId(reqBo.getObjId());
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        ArrayList<Integer> finishTagList = new ArrayList<Integer>();
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
        taskInstQryBo.setFinishTagList(finishTagList);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
            taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
        }
        return taskBoList;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit.booleanValue()) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getObjId());
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            ArrayList<Integer> finishTagList = new ArrayList<Integer>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
                procInst.setProcInstId(uocOrderTaskInsts.get(0).getProcInstId());
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }
}

