/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.ordSourceProcessor.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UocOrderSourceProcessorAgr
implements UocOrderSourceProcessor {
    private static final Logger log = LoggerFactory.getLogger(UocOrderSourceProcessorAgr.class);

    @Override
    public List<List<UocSaleOrderItem>> splitSaleOrder(List<UocSaleOrderItem> reqSaleItemList) {
        ArrayList<List<UocSaleOrderItem>> retList = new ArrayList<List<UocSaleOrderItem>>();
        Map<String, List<UocSaleOrderItem>> supMap = reqSaleItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSupplierId));
        for (Map.Entry<String, List<UocSaleOrderItem>> entry : supMap.entrySet()) {
            Map<String, List<UocSaleOrderItem>> agrMap = entry.getValue().stream().collect(Collectors.groupingBy(UocSaleOrderItem::getAgreementId));
            for (Map.Entry<String, List<UocSaleOrderItem>> agrEntry : agrMap.entrySet()) {
                List itemList = agrEntry.getValue().stream().filter(item -> !ObjectUtil.isEmpty((Object)item.getItemType())).collect(Collectors.toList());
                if (!ObjectUtil.isNotEmpty(itemList)) continue;
                retList.addAll(itemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getItemType)).values());
            }
        }
        log.debug("\u534f\u8bae\u8ba2\u5355\uff1a" + JSON.toJSONString(retList));
        return retList;
    }

    @Override
    public Integer skuSource() {
        return UocDicConstant.ORDER_SOURCE.AGR_GENERATE;
    }
}

