/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.common.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.base.core.approve.repository.api.ApproveRepository;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskHandleDo;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskInfoDo;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskQryDo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQryMateriaOrderNoBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQryOrderStateChngLogBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQrySaleOrderStageBO;
import com.tydic.dyc.oc.model.common.qrybo.UocQryStateCalculatorBo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigItemDo;
import com.tydic.dyc.oc.model.common.sub.UocConfSupplierDO;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.model.common.sub.UocOutLogSaveDo;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.order.sub.UocTodo;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.repository.UocAfOrderRepository;
import com.tydic.dyc.oc.repository.UocAuditOrderRepository;
import com.tydic.dyc.oc.repository.UocChngOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocOrderRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.repository.UocShipOrderRepository;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryInspAmountServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryInspAmountServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryInspItemsServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryInspItemsServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTaskBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCandidatesBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocFinishTaskInfoBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocCommonModelImpl
implements IUocCommonModel {
    private static final Logger log = LoggerFactory.getLogger(UocCommonModelImpl.class);
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private UocInitConfig uocInitConfig;
    @Autowired
    private UocShipOrderRepository uocShipOrderRepository;
    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;
    @Autowired
    private UocChngOrderRepository uocChngOrderRepository;
    @Autowired
    private UocAuditOrderRepository uocAuditOrderRepository;
    @Autowired
    private UocOrderRepository uocOrderRepository;
    @Autowired
    private UocAfOrderRepository uocAfOrderRepository;
    private ProxyMessageProducer proxyMessageProducer;
    private String uocEcOrderTodoTopic;
    private String uocProcessTodoTag;
    @Autowired
    private ApproveRepository approveRepository;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Override
    public UocConfSupplierBo qryConfSupplier(String goodsSupplierNo) {
        return this.uocCommonRepository.qryConfSupplier(goodsSupplierNo);
    }

    @Override
    public List<UocConfSupplierDO> qryConfSupplierList(UocConfSupplierDO uocConfSupplierDO) {
        return this.uocCommonRepository.qryConfSupplierList(uocConfSupplierDO);
    }

    @Override
    public UocCommonDo uploadFile(UocCommonDo uocCommonDo) {
        if (null == uocCommonDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCommonDo.getUocFile()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61uocFile\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCommonDo.getUocFile().getFilename()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[filename]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCommonDo.getUocFile().getPath()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[path]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCommonDo.getUocFile().getInputStream()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[inputStream]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCommonDo.getUocFile().getFileType()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[fileType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UocFile uocFile = this.uocCommonRepository.uploadFile(uocCommonDo.getUocFile());
        UocCommonDo commonDo = new UocCommonDo();
        commonDo.setUocFile(uocFile);
        return commonDo;
    }

    @Override
    public int saveOrderQueryIndex(UocOrderQueryIndex index) {
        return this.uocCommonRepository.saveOrderQueryIndex(index);
    }

    @Override
    public UocCommonDo dealTask(UocCommonDo uocCommonDo) {
        List<UocTaskBO> recallTaskInfos;
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> nextTaskInfos;
        log.info("\u8ba2\u5355\u5904\u7406\u4efb\u52a1\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocCommonDo));
        ArrayList<UocFinishTaskInfoBo> finishTaskInfoBos = new ArrayList<UocFinishTaskInfoBo>();
        if (!CollectionUtils.isEmpty(uocCommonDo.getCompleteTaskInfos())) {
            uocCommonDo.getCompleteTaskInfos().forEach(completeTaskBo -> {
                UocOrderTaskInst qryInst = new UocOrderTaskInst();
                qryInst.setOrderId(uocCommonDo.getOrderId());
                qryInst.setTaskInstId(completeTaskBo.getTaskId());
                qryInst.setCenterCode("UOC");
                List<UocOrderTaskInst> uocOrderTaskInsts = UocRu.jsl(this.approveRepository.queryFlowTask(UocRu.js(qryInst, FlowTaskQryDo.class)), UocOrderTaskInst.class);
                if (ObjectUtil.isEmpty(uocOrderTaskInsts)) {
                    throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u4e0d\u5b58\u5728");
                }
                if (uocOrderTaskInsts.size() != 1) {
                    throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u5b58\u5728\u591a\u6761\u6570\u636e");
                }
                if (UocDicConstant.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
                    throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u5df2\u5b8c\u7ed3");
                }
                completeTaskBo.setBusiObjType(uocOrderTaskInsts.get(0).getObjType());
                completeTaskBo.setBusiObjId(uocOrderTaskInsts.get(0).getObjId());
                FlowTaskHandleDo flowTaskHandleDo = new FlowTaskHandleDo();
                flowTaskHandleDo.setTaskInstId(completeTaskBo.getTaskId());
                if (null != completeTaskBo.getDealResult()) {
                    flowTaskHandleDo.setDealResult(completeTaskBo.getDealResult().toString());
                }
                flowTaskHandleDo.setDealRemark(completeTaskBo.getDealRemark());
                flowTaskHandleDo.setDealUserId(uocCommonDo.getUserId());
                flowTaskHandleDo.setDealUserName(uocCommonDo.getUsername());
                flowTaskHandleDo.setCenterCode("UOC");
                if (null != completeTaskBo.getAuditStepFinish()) {
                    flowTaskHandleDo.setLinkJudge(completeTaskBo.getAuditStepFinish().toString());
                }
                flowTaskHandleDo.setIsFinish(completeTaskBo.getFinish());
                flowTaskHandleDo.setStepCode(uocOrderTaskInsts.get(0).getStepCode());
                this.approveRepository.completeFlowTask(flowTaskHandleDo);
                UocFinishTaskInfoBo bo = (UocFinishTaskInfoBo)JSON.parseObject((String)JSON.toJSONString((Object)completeTaskBo), UocFinishTaskInfoBo.class);
                bo.setDealOperId(uocCommonDo.getUserId() + "");
                bo.setDealOperName(uocCommonDo.getUsername());
                bo.setCenter("UOC_PRO");
                finishTaskInfoBos.add(bo);
                if (null != completeTaskBo.getFinish() && completeTaskBo.getFinish().booleanValue()) {
                    List<UocApprovalObj> uocApprovalObjs;
                    UocApprovalObjQryBo selectuocApprovalObjQryBo;
                    if (completeTaskBo.getBusiObjType().equals(UocDicConstant.OBJ_TYPE.APPROVE) && completeTaskBo.getDealResult().equals(UocDicConstant.APPROVE_RESULT.APPROVED)) {
                        selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
                        selectuocApprovalObjQryBo.setAuditOrderId(uocOrderTaskInsts.get(0).getObjId());
                        selectuocApprovalObjQryBo.setOrderId(uocCommonDo.getOrderId());
                        uocApprovalObjs = this.uocAuditOrderRepository.qryApprovealObj(selectuocApprovalObjQryBo);
                        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
                            throw new BaseBusinessException("101005", "\u67e5\u8be2\u5ba1\u6279\u4efb\u52a1\u5bf9\u8c61\u8868\u4e3a\u7a7a\uff01");
                        }
                        if (UocConstant.OBJ_BUSI_TYPE.PRICE.equals(uocApprovalObjs.get(0).getObjBusiType())) {
                            UocChngOrderObjQryBo selectUocChngOrderObjQryBo = new UocChngOrderObjQryBo();
                            selectUocChngOrderObjQryBo.setOrderId(uocCommonDo.getOrderId());
                            selectUocChngOrderObjQryBo.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                            List<UocChngOrderObj> uocChngOrderObjs = this.uocChngOrderRepository.getListChngOrderObjWithOutItem(selectUocChngOrderObjQryBo);
                            if (CollectionUtils.isEmpty(uocChngOrderObjs)) {
                                throw new BaseBusinessException("101005", "\u67e5\u8be2\u53d8\u66f4\u5355\u5bf9\u8c61\u8868\u4e3a\u7a7a\uff01");
                            }
                            log.debug("\u53d8\u66f4\u5bf9\u8c61\u8868\u96c6\u5408\uff1a" + JSON.toJSONString(uocChngOrderObjs));
                            if (uocChngOrderObjs.size() > 1) {
                                uocChngOrderObjs.sort((m1, m2) -> m2.getCreateTime().compareTo(m1.getCreateTime()));
                            }
                            UocChngOrderItemObjQryBo selectUocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
                            selectUocChngOrderItemObjQryBo.setChngOrderId(uocChngOrderObjs.get(0).getChngOrderId());
                            List<UocChngOrderItemObj> uocChngOrderItemObjList = this.uocChngOrderRepository.getListChngOrderItemObj(selectUocChngOrderItemObjQryBo);
                            if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
                                throw new BaseBusinessException("101008", "\u67e5\u8be2\u53d8\u66f4\u660e\u7ec6\u5bf9\u8c61\u4e3a\u7a7a");
                            }
                            this.updateSaleOrderDomainSalePrice(uocCommonDo.getOrderId(), Long.valueOf(uocApprovalObjs.get(0).getObjId()), uocChngOrderItemObjList);
                            this.updateOrderDomainSalePrice(uocCommonDo.getOrderId(), uocChngOrderItemObjList);
                            if (null != uocChngOrderItemObjList.get(0).getChngPurchaseFee()) {
                                this.updateSaleOrderDomainPurchasePrice(uocCommonDo.getOrderId(), Long.valueOf(uocApprovalObjs.get(0).getObjId()), uocChngOrderItemObjList);
                                this.updateOrderDomainPurchasePrice(uocCommonDo.getOrderId(), uocChngOrderItemObjList);
                            }
                        }
                    }
                    if (completeTaskBo.getBusiObjType().equals(UocDicConstant.OBJ_TYPE.APPROVE) && completeTaskBo.getDealResult().equals(UocDicConstant.APPROVE_RESULT.REJECT)) {
                        selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
                        selectuocApprovalObjQryBo.setAuditOrderId(uocOrderTaskInsts.get(0).getObjId());
                        selectuocApprovalObjQryBo.setOrderId(uocCommonDo.getOrderId());
                        uocApprovalObjs = this.uocAuditOrderRepository.qryApprovealObj(selectuocApprovalObjQryBo);
                        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
                            throw new BaseBusinessException("101005", "\u67e5\u8be2\u5ba1\u6279\u4efb\u52a1\u5bf9\u8c61\u8868\u4e3a\u7a7a\uff01");
                        }
                        if (UocConstant.OBJ_BUSI_TYPE.ORDER.equals(uocApprovalObjs.get(0).getObjBusiType())) {
                            String dealRemark = completeTaskBo.getDealRemark();
                            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
                            uocSaleOrderDo.setCancelReason(dealRemark);
                            uocSaleOrderDo.setCancelReasonFlag(UocConstant.CancelReasonFlag.APPROVE_CANCEL);
                            uocSaleOrderDo.setOrderId(uocCommonDo.getOrderId());
                            uocSaleOrderDo.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                            uocSaleOrderDo.setSaleOrderState("XS_QX_QX");
                            uocSaleOrderDo.setCancelTime(new Date());
                            if (null != uocCommonDo.getUserId()) {
                                uocSaleOrderDo.setCancelOperId(uocCommonDo.getUserId().toString());
                            }
                            uocSaleOrderDo.setCancelOperName(uocCommonDo.getName());
                            this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo);
                        }
                    }
                }
            });
        }
        if (ObjectUtil.isNotEmpty(nextTaskInfos = uocCommonDo.getNextTaskInfos()) && StringUtils.isBlank((CharSequence)uocCommonDo.getPreTaskId()) && ObjectUtil.isEmpty(uocCommonDo.getRecallTaskInfos())) {
            ArrayList<FlowTaskInfoDo> flowTaskInfoDoList = new ArrayList<FlowTaskInfoDo>();
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo : nextTaskInfos) {
                FlowTaskInfoDo flowTaskInfoDo = new FlowTaskInfoDo();
                flowTaskInfoDo.setCenterCode("UOC");
                flowTaskInfoDo.setCenterCodeStr("\u8ba2\u5355");
                flowTaskInfoDo.setTaskInstId(nextTaskInfo.getTaskId());
                flowTaskInfoDo.setProcInstId(nextTaskInfo.getProcInstId());
                flowTaskInfoDo.setProcName(nextTaskInfo.getProcDefName());
                flowTaskInfoDo.setProcDefKey(nextTaskInfo.getProcDefKey());
                if (UocDicConstant.OBJ_TYPE.APPROVE.equals(nextTaskInfo.getBusiObjType())) {
                    flowTaskInfoDo.setProcType("APPROVE");
                    flowTaskInfoDo.setProcTypeStr("\u5ba1\u6279\u6d41");
                } else {
                    flowTaskInfoDo.setProcType("BUSINESS");
                    flowTaskInfoDo.setProcTypeStr("\u4e1a\u52a1\u6d41");
                }
                flowTaskInfoDo.setObjId(nextTaskInfo.getBusiObjId());
                flowTaskInfoDo.setObjType(nextTaskInfo.getBusiObjType());
                flowTaskInfoDo.setTaskSignTag(nextTaskInfo.getTaskSignTag());
                if (flowTaskInfoDo.getTaskSignTag() == null) {
                    flowTaskInfoDo.setTaskSignTag(UocDicConstant.TASK_SING_TAG.TACHE_TASK);
                }
                flowTaskInfoDo.setStepCode(nextTaskInfo.getStepId());
                if (ObjectUtil.isNotEmpty((Object)nextTaskInfo.getCandidates())) {
                    List candidates = nextTaskInfo.getCandidates();
                    UocCandidatesBO uocCandidatesBO = (UocCandidatesBO)candidates.get(0);
                    flowTaskInfoDo.setTaskUserId(Long.valueOf(uocCandidatesBO.getCandidateId()));
                    flowTaskInfoDo.setTaskUserName(uocCandidatesBO.getCandidateName());
                }
                flowTaskInfoDoList.add(flowTaskInfoDo);
                String state = this.uocInitConfig.getStateByTachecode(nextTaskInfo.getStepId(), nextTaskInfo.getBusiObjType());
                this.updateState(uocCommonDo, nextTaskInfo, state);
            }
            this.approveRepository.addFlowTask(flowTaskInfoDoList);
        }
        if (StringUtils.isNotBlank((CharSequence)uocCommonDo.getPreTaskId())) {
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo = uocCommonDo.getNextTaskInfos().get(0);
            this.dealPreOrRecallTask(nextTaskInfo, uocCommonDo.getPreTaskId());
        }
        if (uocCommonDo.getUpdateTaskCandidate() != null && ObjectUtil.isNotEmpty((Object)uocCommonDo.getUpdateTaskCandidate().getTaskId())) {
            UocCandidatesBO uocCandidatesBO = (UocCandidatesBO)uocCommonDo.getUpdateTaskCandidate().getCandidates().get(0);
            FlowTaskInfoDo flowTaskInfoDo = new FlowTaskInfoDo();
            flowTaskInfoDo.setTaskInstId(uocCommonDo.getUpdateTaskCandidate().getTaskId());
            flowTaskInfoDo.setTaskUserId(Long.valueOf(uocCandidatesBO.getCandidateId()));
            flowTaskInfoDo.setTaskUserName(uocCandidatesBO.getCandidateName());
            this.approveRepository.transfFlowTask(flowTaskInfoDo);
        }
        if (ObjectUtil.isNotEmpty(recallTaskInfos = uocCommonDo.getRecallTaskInfos())) {
            log.info("\u8ba2\u5355\u5904\u7406\u64a4\u56de\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(recallTaskInfos));
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo = uocCommonDo.getNextTaskInfos().get(0);
            this.dealPreOrRecallTask(nextTaskInfo, recallTaskInfos.get(0).getTaskId());
        }
        UocCommonDo rsp = new UocCommonDo();
        rsp.setFinishTaskInfoBos(finishTaskInfoBos);
        this.buildSyncInfo(uocCommonDo, rsp);
        return rsp;
    }

    private void dealPreOrRecallTask(UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo, String preTaskId) {
        FlowTaskHandleDo flowTaskHandleDo = new FlowTaskHandleDo();
        flowTaskHandleDo.setCenterCode("UOC");
        flowTaskHandleDo.setOldTaskInstId(preTaskId);
        flowTaskHandleDo.setTaskInstId(nextTaskInfo.getTaskId());
        flowTaskHandleDo.setProcInstId(nextTaskInfo.getProcInstId());
        flowTaskHandleDo.setProcName(nextTaskInfo.getProcDefName());
        flowTaskHandleDo.setProcDefKey(nextTaskInfo.getProcDefKey());
        if (UocDicConstant.OBJ_TYPE.APPROVE.equals(nextTaskInfo.getBusiObjType())) {
            flowTaskHandleDo.setProcType("BUSINESS");
        } else {
            flowTaskHandleDo.setProcType("APPROVE");
        }
        flowTaskHandleDo.setObjId(nextTaskInfo.getBusiObjId());
        flowTaskHandleDo.setObjType(nextTaskInfo.getBusiObjType());
        flowTaskHandleDo.setTaskSignTag(nextTaskInfo.getTaskSignTag());
        if (flowTaskHandleDo.getTaskSignTag() == null) {
            flowTaskHandleDo.setTaskSignTag(UocDicConstant.TASK_SING_TAG.TACHE_TASK);
        }
        flowTaskHandleDo.setStepCode(nextTaskInfo.getStepId());
        List candidates = nextTaskInfo.getCandidates();
        UocCandidatesBO uocCandidatesBO = (UocCandidatesBO)candidates.get(0);
        flowTaskHandleDo.setTaskUserId(Long.valueOf(uocCandidatesBO.getCandidateId()));
        flowTaskHandleDo.setTaskUserName(uocCandidatesBO.getCandidateName());
        this.approveRepository.beforeJoinFlowTask(flowTaskHandleDo);
    }

    private void buildSyncInfo(UocCommonDo uocCommonDo, UocCommonDo rsp) {
        UocEsSyncBO saleEsSyncBO;
        UocEsSyncBO saleEsSyncBO2;
        List<UocApprovalObj> uocApprovalObjs;
        UocApprovalObjQryBo selectuocApprovalObjQryBo;
        List<UocOrderTaskInst> uocOrderTaskInsts;
        UocOrderTaskInst qryInst;
        ArrayList<UocEsSyncBO> syncSaleOrderList = new ArrayList<UocEsSyncBO>();
        ArrayList<UocEsSyncBO> syncChngOrderList = new ArrayList<UocEsSyncBO>();
        ArrayList<UocEsSyncBO> syncShipOrderList = new ArrayList<UocEsSyncBO>();
        ArrayList<UocEsSyncBO> syncInspOrderList = new ArrayList<UocEsSyncBO>();
        ArrayList<UocEsSyncBO> syncAfterOrderList = new ArrayList<UocEsSyncBO>();
        if (ObjectUtil.isNotEmpty(uocCommonDo.getCompleteTaskInfos())) {
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo bo : uocCommonDo.getCompleteTaskInfos()) {
                qryInst = new UocOrderTaskInst();
                qryInst.setTaskInstId(bo.getTaskId());
                qryInst.setCenterCode("UOC");
                uocOrderTaskInsts = UocRu.jsl(this.approveRepository.queryFlowTask(UocRu.js(qryInst, FlowTaskQryDo.class)), UocOrderTaskInst.class);
                if (uocOrderTaskInsts.size() != 1) {
                    throw new BaseBusinessException("101005", "\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff01");
                }
                if (!UocDicConstant.OBJ_TYPE.APPROVE.equals(uocOrderTaskInsts.get(0).getObjType())) continue;
                selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
                selectuocApprovalObjQryBo.setAuditOrderId(uocOrderTaskInsts.get(0).getObjId());
                selectuocApprovalObjQryBo.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                uocApprovalObjs = this.uocAuditOrderRepository.qryApprovealObj(selectuocApprovalObjQryBo);
                saleEsSyncBO2 = new UocEsSyncBO();
                saleEsSyncBO2.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                saleEsSyncBO2.setOrderId(uocApprovalObjs.get(0).getOrderId());
                syncSaleOrderList.add(saleEsSyncBO2);
            }
        }
        if (ObjectUtil.isNotEmpty(uocCommonDo.getNextTaskInfos())) {
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo bo : uocCommonDo.getNextTaskInfos()) {
                qryInst = new UocOrderTaskInst();
                qryInst.setTaskInstId(bo.getTaskId());
                qryInst.setCenterCode("UOC");
                uocOrderTaskInsts = UocRu.jsl(this.approveRepository.queryFlowTask(UocRu.js(qryInst, FlowTaskQryDo.class)), UocOrderTaskInst.class);
                if (uocOrderTaskInsts.size() != 1) {
                    throw new BaseBusinessException("101005", "\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff01");
                }
                if (UocDicConstant.OBJ_TYPE.SALE.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    saleEsSyncBO = new UocEsSyncBO();
                    saleEsSyncBO.setSaleOrderId(uocOrderTaskInsts.get(0).getObjId());
                    saleEsSyncBO.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    syncSaleOrderList.add(saleEsSyncBO);
                }
                if (UocDicConstant.OBJ_TYPE.CHNG.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    UocEsSyncBO chngEsSyncBO = new UocEsSyncBO();
                    chngEsSyncBO.setChngOrderId(uocOrderTaskInsts.get(0).getObjId());
                    chngEsSyncBO.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    syncChngOrderList.add(chngEsSyncBO);
                }
                if (UocDicConstant.OBJ_TYPE.SHIP.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    UocEsSyncBO shipEsSyncBO = new UocEsSyncBO();
                    shipEsSyncBO.setShipOrderId(uocOrderTaskInsts.get(0).getObjId());
                    shipEsSyncBO.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    syncShipOrderList.add(shipEsSyncBO);
                    UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
                    uocShipOrderQryBo.setShipOrderId(uocOrderTaskInsts.get(0).getObjId());
                    uocShipOrderQryBo.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    List<UocShipOrderDo> shipOrderDos = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
                    if (!CollectionUtils.isEmpty(shipOrderDos)) {
                        UocEsSyncBO saleEsSyncBO3 = new UocEsSyncBO();
                        saleEsSyncBO3.setSaleOrderId(shipOrderDos.get(0).getSaleOrderId());
                        saleEsSyncBO3.setOrderId(shipOrderDos.get(0).getOrderId());
                        syncSaleOrderList.add(saleEsSyncBO3);
                    }
                }
                if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    UocEsSyncBO inspEsSyncBO = new UocEsSyncBO();
                    inspEsSyncBO.setInspOrderId(uocOrderTaskInsts.get(0).getObjId());
                    inspEsSyncBO.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    syncInspOrderList.add(inspEsSyncBO);
                }
                if (UocDicConstant.OBJ_TYPE.AFTER.equals(uocOrderTaskInsts.get(0).getObjType())) {
                    UocEsSyncBO afterEsSyncBO = new UocEsSyncBO();
                    afterEsSyncBO.setAfterOrderId(uocOrderTaskInsts.get(0).getObjId());
                    afterEsSyncBO.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                    syncAfterOrderList.add(afterEsSyncBO);
                }
                if (!UocDicConstant.OBJ_TYPE.APPROVE.equals(uocOrderTaskInsts.get(0).getObjType())) continue;
                selectuocApprovalObjQryBo = new UocApprovalObjQryBo();
                selectuocApprovalObjQryBo.setAuditOrderId(uocOrderTaskInsts.get(0).getObjId());
                selectuocApprovalObjQryBo.setOrderId(uocOrderTaskInsts.get(0).getOrderId());
                uocApprovalObjs = this.uocAuditOrderRepository.qryApprovealObj(selectuocApprovalObjQryBo);
                saleEsSyncBO2 = new UocEsSyncBO();
                saleEsSyncBO2.setSaleOrderId(Long.valueOf(uocApprovalObjs.get(0).getObjId()));
                saleEsSyncBO2.setOrderId(uocApprovalObjs.get(0).getOrderId());
                syncSaleOrderList.add(saleEsSyncBO2);
            }
        }
        if (null != uocCommonDo.getUpdateTaskCandidate() && StringUtils.isNotBlank((CharSequence)uocCommonDo.getUpdateTaskCandidate().getTaskId())) {
            UocOrderTaskInst qryInst2 = new UocOrderTaskInst();
            qryInst2.setTaskInstId(uocCommonDo.getUpdateTaskCandidate().getTaskId());
            qryInst2.setCenterCode("UOC");
            List<UocOrderTaskInst> uocOrderTaskInsts2 = UocRu.jsl(this.approveRepository.queryFlowTask(UocRu.js(qryInst2, FlowTaskQryDo.class)), UocOrderTaskInst.class);
            if (uocOrderTaskInsts2.size() != 1) {
                throw new BaseBusinessException("101005", "\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff01");
            }
            if (UocDicConstant.OBJ_TYPE.APPROVE.equals(uocOrderTaskInsts2.get(0).getObjType())) {
                UocApprovalObjQryBo selectuocApprovalObjQryBo2 = new UocApprovalObjQryBo();
                selectuocApprovalObjQryBo2.setAuditOrderId(uocOrderTaskInsts2.get(0).getObjId());
                selectuocApprovalObjQryBo2.setOrderId(uocOrderTaskInsts2.get(0).getOrderId());
                List<UocApprovalObj> uocApprovalObjs2 = this.uocAuditOrderRepository.qryApprovealObj(selectuocApprovalObjQryBo2);
                saleEsSyncBO = new UocEsSyncBO();
                saleEsSyncBO.setSaleOrderId(Long.valueOf(uocApprovalObjs2.get(0).getObjId()));
                saleEsSyncBO.setOrderId(uocApprovalObjs2.get(0).getOrderId());
                syncSaleOrderList.add(saleEsSyncBO);
            }
        }
        rsp.setSyncSaleOrderList(syncSaleOrderList);
        rsp.setSyncChngOrderList(syncChngOrderList);
        rsp.setSyncShipOrderList(syncShipOrderList);
        rsp.setSyncInspOrderList(syncInspOrderList);
        rsp.setSyncAfterOrderList(syncAfterOrderList);
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInst(UocOrderTaskInst uocOrderTaskInst) {
        uocOrderTaskInst.setCenterCode("UOC");
        return UocRu.jsl(this.approveRepository.queryFlowTask(UocRu.js(uocOrderTaskInst, FlowTaskQryDo.class)), UocOrderTaskInst.class);
    }

    private void updateOrderDomainPurchasePrice(Long orderId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(orderId);
        ArrayList<UocOrderItem> orderItems = new ArrayList<UocOrderItem>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if (uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)) {
                UocOrderItem uocOrderItem = new UocOrderItem();
                uocOrderItem.setOrderId(orderId);
                uocOrderItem.setOrderItemId(uocChngOrderItemObj.getOrderItemId());
                uocOrderItem.setPurchasePrice(uocChngOrderItemObj.getChngPurchaseFee());
                uocOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderItem.setUpdateTime(updateTime);
                orderItems.add(uocOrderItem);
                uocOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderDo.setUpdateTime(updateTime);
            }
        });
        if (!CollectionUtils.isEmpty(orderItems)) {
            uocOrderDo.setOrderItems(orderItems);
            this.uocOrderRepository.modifyBatchItemPurchasePrice(uocOrderDo);
            UocOrderDo uocOrderDo2 = new UocOrderDo();
            uocOrderDo2.setOrderId(uocOrderDo.getOrderId());
            UocOrderDo uocOrderDo4 = this.uocOrderRepository.getOrderItemTotalPrice(uocOrderDo2);
            UocOrderDo uocOrderDo3 = new UocOrderDo();
            uocOrderDo3.setOrderId(uocOrderDo.getOrderId());
            uocOrderDo3.setTotalPurchaseFee(uocOrderDo4.getTotalPurchaseFee());
            uocOrderDo3.setUpdateOperId(uocOrderDo.getUpdateOperId());
            uocOrderDo3.setUpdateTime(uocOrderDo.getUpdateTime());
            this.uocOrderRepository.modifyOrderMain(uocOrderDo3);
        }
    }

    private void updateSaleOrderDomainPurchasePrice(Long orderId, Long saleOrderId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo.setSaleOrderId(saleOrderId);
        ArrayList<UocSaleOrderItem> saleOrderItems = new ArrayList<UocSaleOrderItem>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if (uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)) {
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setOrderId(orderId);
                uocSaleOrderItem.setSaleOrderId(saleOrderId);
                uocSaleOrderItem.setSaleOrderItemId(uocChngOrderItemObj.getSaleOrderItemId());
                uocSaleOrderItem.setPurchasePrice(uocChngOrderItemObj.getChngPurchaseFee());
                uocSaleOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderItem.setUpdateTime(updateTime);
                saleOrderItems.add(uocSaleOrderItem);
                uocSaleOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderDo.setUpdateTime(updateTime);
            }
        });
        if (!CollectionUtils.isEmpty(saleOrderItems)) {
            uocSaleOrderDo.setSaleOrderItems(saleOrderItems);
            this.uocSaleOrderRepository.modifyBatchItemPurchasePrice(uocSaleOrderDo);
            UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
            uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            UocSaleOrderDo uocSaleOrderDo4 = this.uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
            UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
            uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            uocSaleOrderDo3.setTotalPurchaseFee(uocSaleOrderDo4.getTotalPurchaseFee());
            uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
            uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
            this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
            this.updatePayConfMoney(uocSaleOrderDo4.getTotalPurchaseFee(), uocSaleOrderDo.getOrderId(), uocSaleOrderDo.getSaleOrderId(), UocDicConstant.USE_TYPE.PRO);
        }
    }

    private void updateOrderDomainSalePrice(Long orderId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(orderId);
        ArrayList<UocOrderItem> orderItems = new ArrayList<UocOrderItem>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if (uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)) {
                UocOrderItem uocOrderItem = new UocOrderItem();
                uocOrderItem.setOrderId(orderId);
                uocOrderItem.setOrderItemId(uocChngOrderItemObj.getOrderItemId());
                uocOrderItem.setSalePrice(uocChngOrderItemObj.getChngFee());
                uocOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderItem.setUpdateTime(updateTime);
                orderItems.add(uocOrderItem);
                uocOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocOrderDo.setUpdateTime(updateTime);
            }
        });
        if (!CollectionUtils.isEmpty(orderItems)) {
            uocOrderDo.setOrderItems(orderItems);
            this.uocOrderRepository.modifyBatchItemSalePrice(uocOrderDo);
            UocOrderDo uocOrderDo2 = new UocOrderDo();
            uocOrderDo2.setOrderId(uocOrderDo.getOrderId());
            UocOrderDo uocOrderDo4 = this.uocOrderRepository.getOrderItemTotalPrice(uocOrderDo2);
            UocOrderDo uocOrderDo3 = new UocOrderDo();
            uocOrderDo3.setOrderId(uocOrderDo.getOrderId());
            uocOrderDo3.setTotalSaleFee(uocOrderDo4.getTotalSaleFee());
            uocOrderDo3.setUpdateOperId(uocOrderDo.getUpdateOperId());
            uocOrderDo3.setUpdateTime(uocOrderDo.getUpdateTime());
            this.uocOrderRepository.modifyOrderMain(uocOrderDo3);
        }
    }

    private void updateSaleOrderDomainSalePrice(Long orderId, Long saleOrderId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo.setSaleOrderId(saleOrderId);
        ArrayList<UocSaleOrderItem> saleOrderItems = new ArrayList<UocSaleOrderItem>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            if (uocChngOrderItemObj.getChngType().equals(UocConstant.BUSI_TYPE.PRICE_CHG)) {
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setOrderId(orderId);
                uocSaleOrderItem.setSaleOrderId(saleOrderId);
                uocSaleOrderItem.setSaleOrderItemId(uocChngOrderItemObj.getSaleOrderItemId());
                uocSaleOrderItem.setSalePrice(uocChngOrderItemObj.getChngFee());
                uocSaleOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderItem.setUpdateTime(updateTime);
                saleOrderItems.add(uocSaleOrderItem);
                uocSaleOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
                uocSaleOrderDo.setUpdateTime(updateTime);
            }
        });
        if (!CollectionUtils.isEmpty(saleOrderItems)) {
            uocSaleOrderDo.setSaleOrderItems(saleOrderItems);
            this.uocSaleOrderRepository.modifyBatchItemSalePrice(uocSaleOrderDo);
            UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
            uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            UocSaleOrderDo uocSaleOrderDo4 = this.uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
            UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
            uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            uocSaleOrderDo3.setTotalSaleFee(uocSaleOrderDo4.getTotalSaleFee());
            uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
            uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
            this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
            this.updatePayConfMoney(uocSaleOrderDo4.getTotalSaleFee(), uocSaleOrderDo.getOrderId(), uocSaleOrderDo.getSaleOrderId(), UocDicConstant.USE_TYPE.PUR);
        }
    }

    private void updatePayConfMoney(BigDecimal totalSaleFee, Long orderId, Long saleOrderId, Integer userType) {
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(orderId);
        uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrderId);
        uocSaleOrderPayConfQryBo.setUserType(userType);
        List<UocSaleOrderPayConf> saleOrderPayConfList = this.uocSaleOrderRepository.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        if (ObjectUtil.isEmpty(saleOrderPayConfList)) {
            return;
        }
        if (saleOrderPayConfList.size() != 1) {
            throw new BaseBusinessException("100100", "\u67e5\u8be2\u9500\u552e\u5355\u652f\u4ed8\u914d\u7f6e\u6709\u591a\u6761\uff01");
        }
        UocSaleOrderPayConf payConf = saleOrderPayConfList.get(0);
        if (UocDicConstant.PAY_NODE_RULE.INVOICE_RECEIPT_BEGIN_CALCULATE.equals(payConf.getPayNodeRule()) || UocDicConstant.PAY_NODE_RULE.INVOICE_RECEIPT_BEGIN_CALCULATE.equals(payConf.getPayRule())) {
            return;
        }
        if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
            payConf.setPrePayFee(totalSaleFee);
        } else if (UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) {
            if (ObjectUtil.isNotEmpty((Object)payConf.getPrePaySup())) {
                payConf.setPrePayFee(totalSaleFee.multiply(payConf.getPrePaySup()).multiply(new BigDecimal("0.01")));
            }
            if (ObjectUtil.isNotEmpty((Object)payConf.getVerPaySup())) {
                payConf.setVerPayFee(totalSaleFee.multiply(payConf.getVerPaySup()));
            }
            if (ObjectUtil.isNotEmpty((Object)payConf.getPilPaySup())) {
                payConf.setPilPayFee(totalSaleFee.multiply(payConf.getPilPaySup()));
            }
            if (ObjectUtil.isNotEmpty((Object)payConf.getQuaPaySup())) {
                payConf.setQuaPayFee(totalSaleFee.multiply(payConf.getQuaPaySup()));
            }
        } else if (UocDicConstant.PAY_RULE.SPECIFIED_ACCOUNT_DATE.equals(payConf.getPayRule())) {
            if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                payConf.setVerPayFee(totalSaleFee);
            } else if (UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayAccountDayRule())) {
                payConf.setPilPayFee(totalSaleFee);
            }
        } else if (UocDicConstant.PAY_NODE_RULE.ORD_ARRIVE_CALCULATE.equals(payConf.getPayNodeRule())) {
            payConf.setVerPayFee(totalSaleFee);
        } else if (UocDicConstant.PAY_NODE_RULE.ORD_ACCEPT_CALCULATE.equals(payConf.getPayNodeRule())) {
            payConf.setPilPayFee(totalSaleFee);
        }
        int isUpdate = this.uocSaleOrderRepository.updateSaleOrderPayConfMoney(payConf);
        if (isUpdate != 1) {
            throw new BaseBusinessException("100100", "\u66f4\u65b0\u652f\u4ed8\u914d\u7f6e\u8868\u5e94\u4ed8\u91d1\u989d\u5931\u8d25\uff01");
        }
    }

    private UocOrderTaskDeal assembleTaskDealObj(UocCommonDo uocCommonDo, UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo) {
        UocOrderTaskDeal deal = new UocOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskId());
        deal.setOrderId(uocCommonDo.getOrderId());
        deal.setObjId(nextTaskInfo.getBusiObjId());
        deal.setObjType(nextTaskInfo.getBusiObjType());
        return deal;
    }

    private void updateState(UocCommonDo uocCommonDo, UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo, String state) {
        if (ObjectUtil.isNotEmpty((Object)state)) {
            if (UocDicConstant.OBJ_TYPE.SHIP.equals(taskBo.getBusiObjType())) {
                UocShipOrderDo updateShipDo = new UocShipOrderDo();
                updateShipDo.setUpdateOperId(Convert.toStr((Object)uocCommonDo.getUserId()));
                updateShipDo.setOrderId(uocCommonDo.getOrderId());
                updateShipDo.setShipOrderId(taskBo.getBusiObjId());
                updateShipDo.setShipOrderState(state);
                if (null != taskBo.getFinish() && taskBo.getFinish().booleanValue()) {
                    updateShipDo.setFinishFlag(UocConstant.SHIP_ORDER_FINISH_FLAG.FINISH);
                }
                this.updateShipStatusAndProCode(updateShipDo);
            }
            if (UocDicConstant.OBJ_TYPE.SALE.equals(taskBo.getBusiObjType())) {
                UocSaleOrderDo updateSaleDo = new UocSaleOrderDo();
                updateSaleDo.setUpdateOperId(Convert.toStr((Object)uocCommonDo.getUserId()));
                updateSaleDo.setOrderId(uocCommonDo.getOrderId());
                updateSaleDo.setSaleOrderId(taskBo.getBusiObjId());
                updateSaleDo.setSaleOrderState(state);
                this.updateSaleStatusAndProCode(updateSaleDo);
            }
            if (UocDicConstant.OBJ_TYPE.CHNG.equals(taskBo.getBusiObjType())) {
                UocChngOrderDo updateChngDo = new UocChngOrderDo();
                updateChngDo.setUpdateOperId(Convert.toStr((Object)uocCommonDo.getUserId()));
                updateChngDo.setOrderId(uocCommonDo.getOrderId());
                updateChngDo.setChngOrderId(taskBo.getBusiObjId());
                updateChngDo.setChngOrderState(state);
                this.updateShipStatusAndProCode(updateChngDo);
            }
            if (UocDicConstant.OBJ_TYPE.AFTER.equals(taskBo.getBusiObjType())) {
                UocAfOrderDo updateAfOrderDo = new UocAfOrderDo();
                updateAfOrderDo.setAfOrderId(taskBo.getBusiObjId());
                updateAfOrderDo.setServState(Integer.valueOf(state));
                updateAfOrderDo.setOrderId(uocCommonDo.getOrderId());
                updateAfOrderDo.setUpdateOperId(Convert.toStr((Object)uocCommonDo.getUserId()));
                this.updateAfStatusAndProCode(updateAfOrderDo);
            }
        }
    }

    private void updateAfStatusAndProCode(UocAfOrderDo updateAfOrderDo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(updateAfOrderDo.getAfOrderId());
        uocAfOrderQryBo.setOrderId(updateAfOrderDo.getOrderId());
        UocAfOrder result = this.uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
        if (ObjectUtil.isEmpty((Object)result)) {
            throw new BaseBusinessException("102003", "\u8be5\u552e\u540e\u5355" + updateAfOrderDo.getAfOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(updateAfOrderDo.getAfOrderId());
        uocOrderStateChgLog.setOrderId(updateAfOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        uocOrderStateChgLog.setOldState(result.getServState().toString());
        uocOrderStateChgLog.setNewState(updateAfOrderDo.getServState().toString());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(updateAfOrderDo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        this.uocAfOrderRepository.modifyAfOrderState(updateAfOrderDo);
    }

    private void updateShipStatusAndProCode(UocChngOrderDo uocChngOrderDo) {
        UocChngOrderQryBo qryBo = new UocChngOrderQryBo();
        qryBo.setOrderId(uocChngOrderDo.getOrderId());
        qryBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        UocChngOrderDo chngOrderDo = this.uocChngOrderRepository.getChngOrder(qryBo);
        if (ObjectUtil.isEmpty((Object)chngOrderDo)) {
            throw new BaseBusinessException("102003", "\u8be5\u53d8\u66f4\u5355" + uocChngOrderDo.getChngOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(uocChngOrderDo.getChngOrderId());
        uocOrderStateChgLog.setOrderId(uocChngOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
        uocOrderStateChgLog.setOldState(chngOrderDo.getChngOrderState());
        uocOrderStateChgLog.setNewState(uocChngOrderDo.getChngOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(uocChngOrderDo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        this.uocChngOrderRepository.updateChngStatusAndProCode(uocChngOrderDo);
    }

    private UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo reqBo) {
        this.validateUpdateSaleOrderArg(reqBo);
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.qrySaleOrder(qryBo);
        if (ObjectUtil.isEmpty((Object)((Object)uocSaleOrderDo))) {
            throw new BaseBusinessException("102001", "\u8be5\u9500\u552e\u5355" + reqBo.getSaleOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(reqBo.getSaleOrderId());
        uocOrderStateChgLog.setOrderId(reqBo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderStateChgLog.setOldState(uocSaleOrderDo.getSaleOrderState());
        uocOrderStateChgLog.setNewState(reqBo.getSaleOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(reqBo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        return this.uocSaleOrderRepository.updateSaleStatusAndProCode(reqBo);
    }

    private void validateUpdateSaleOrderArg(UocSaleOrderDo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocUpdateSaleOrderStateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUpdateOperId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u66f4\u65b0\u4ebaid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderState())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355\u72b6\u6001\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (null == uocSaleOrderQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
    }

    private void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderQryBo qryBo = new UocShipOrderQryBo();
        qryBo.setOrderId(uocShipOrderDo.getOrderId());
        qryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo shipOrderDo = this.getShipOrderById(qryBo);
        if (ObjectUtil.isEmpty((Object)shipOrderDo)) {
            throw new BaseBusinessException("102002", "\u8be5\u53d1\u8d27\u5355" + uocShipOrderDo.getShipOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(uocShipOrderDo.getShipOrderId());
        uocOrderStateChgLog.setOrderId(uocShipOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        uocOrderStateChgLog.setOldState(shipOrderDo.getShipOrderState());
        uocOrderStateChgLog.setNewState(uocShipOrderDo.getShipOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(uocShipOrderDo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        this.uocShipOrderRepository.updateShipStatusAndProCode(uocShipOrderDo);
    }

    private UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo) {
        if (null == uocShipOrderQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocShipOrderQryBo.getOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocShipOrderRepository.getShipOrderById(uocShipOrderQryBo);
    }

    @Override
    public int saveTodoInfo(UocTodo uocTodo) {
        if (null == uocTodo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocTodo.getTodoId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5f85\u529eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocTodo.getOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocTodo.getBusiId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocCommonRepository.saveTodoInfo(uocTodo);
    }

    @Override
    public int updateTodoById(UocTodo uocTodo) {
        if (null == uocTodo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocTodo.getTodoId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5f85\u529eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocCommonRepository.updateTodoById(uocTodo);
    }

    @Override
    public UocTodo getTodoInfo(UocTodo uocTodo) {
        if (null == uocTodo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocCommonRepository.getTodoInfo(uocTodo);
    }

    @Override
    public List<UocTodo> getTodoListInfo(UocTodo uocTodo) {
        return this.uocCommonRepository.getTodoListInfo(uocTodo);
    }

    @Override
    public void insertBatchTodo(List<UocTodo> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocTodo uocTodo : list) {
            if (null == uocTodo.getTodoId()) {
                throw new BaseBusinessException("102001", "\u5165\u53c2\u5f85\u529eID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocTodo.getOrderId()) {
                throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != uocTodo.getBusiId()) continue;
            throw new BaseBusinessException("102001", "\u5165\u53c2\u4e1a\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocCommonRepository.insertBatchTodo(list);
    }

    @Override
    public UocCfcParamConfigDo qryCfcParamByCode(String paramCode) {
        return this.uocCommonRepository.qryCfcParamByCode(paramCode);
    }

    @Override
    public UocCfcParamConfigItemDo updateCfcItemValue(UocCfcParamConfigItemDo reqDo) {
        UocCfcParamConfigItemDo updateItemDo = new UocCfcParamConfigItemDo();
        updateItemDo.setItemId(reqDo.getItemId());
        updateItemDo.setItemValue(reqDo.getItemValue());
        updateItemDo.setCreateTime(new Date());
        updateItemDo.setCreateId(reqDo.getCreateId());
        updateItemDo.setCreateName(reqDo.getCreateName());
        this.uocCommonRepository.updateCfcItemValue(updateItemDo);
        return reqDo;
    }

    @Override
    public UocQryMateriaOrderNoBo qryMateriaBySkuIdAndUserId(UocQryMateriaOrderNoBo qryBo) {
        return this.uocCommonRepository.qryMateriaBySkuIdAndUserId(qryBo);
    }

    @Override
    public UocQrySaleOrderStageBO qrySaleOrderStageByOrderStateAndprocState(UocQrySaleOrderStageBO qryBo) {
        return this.uocCommonRepository.qrySaleOrderStageByOrderStateAndprocState(qryBo);
    }

    @Override
    public UocQryStateCalculatorBo qryUocStateCalculatorServerConfig(String callServerClassName) {
        return this.uocCommonRepository.qryUocStateCalculatorServerConfig(callServerClassName);
    }

    @Override
    public UocQryOrderStateChngLogBo qryUocLastChngStateByObjId(UocQryOrderStateChngLogBo qryBo) {
        return this.uocCommonRepository.qryUocLastChngStateByObjId(qryBo);
    }

    @Override
    public UocOutLogSaveDo saveOutLog(UocOutLogSaveDo reqDo) {
        return this.uocCommonRepository.saveOutLog(reqDo);
    }

    @Override
    public UocQryInspItemsServiceRspBo qryInspItems(UocQryInspItemsServiceReqBo reqBo) {
        return this.uocCommonRepository.qryInspItems(reqBo);
    }

    @Override
    public UocQryInspAmountServiceRspBo qryInspAmount(UocQryInspAmountServiceReqBo reqBo) {
        return this.uocCommonRepository.qryInspAmount(reqBo);
    }
}

