/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderCancelService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelRspBo;
import com.tydic.dyc.oc.transactionservice.UocAfterOrderCancelTransaction;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderCancelService"})
public class UocAfterOrderCancelServiceImpl
implements UocAfterOrderCancelService {
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocAfterOrderCancelTransaction uocAfterOrderCancelTransaction;

    @PostMapping(value={"cancelAfterOrder"})
    public UocAfterOrderCancelRspBo cancelAfterOrder(@RequestBody UocAfterOrderCancelReqBo reqBo) {
        UocAfterOrderCancelRspBo rspBo = this.uocAfterOrderCancelTransaction.cancelAfterOrder(reqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            this.syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocAfterOrderCancelReqBo reqBo, UocAfterOrderCancelRspBo rspBo) {
        ArrayList<SyncEsRunnableBo> syncEsRunnableBoList = new ArrayList<SyncEsRunnableBo>();
        SyncEsRunnableBo syncSaleEsRunnableBo = new SyncEsRunnableBo();
        syncSaleEsRunnableBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        syncSaleEsRunnableBo.setOrderId(reqBo.getOrderId());
        syncSaleEsRunnableBo.setObjId(rspBo.getSaleOrderId());
        syncSaleEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        syncEsRunnableBoList.add(syncSaleEsRunnableBo);
        SyncEsRunnableBo syncShipEsRunnableBo = new SyncEsRunnableBo();
        syncShipEsRunnableBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
        syncShipEsRunnableBo.setOrderId(reqBo.getOrderId());
        syncShipEsRunnableBo.setObjId(rspBo.getShipOrderId());
        syncShipEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        syncEsRunnableBoList.add(syncShipEsRunnableBo);
        SyncEsRunnableBo syncAfEsRunnableBo = new SyncEsRunnableBo();
        syncAfEsRunnableBo.setIndexName(this.uocIndexConfig.getAfOrderIndex());
        syncAfEsRunnableBo.setOrderId(reqBo.getOrderId());
        syncAfEsRunnableBo.setObjId(reqBo.getAfOrderId());
        syncAfEsRunnableBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        syncEsRunnableBoList.add(syncAfEsRunnableBo);
        this.uocThreadPool.executeRunnable(new UocSyncEsRunnable(syncEsRunnableBoList));
    }
}

