/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.UocApproveMoveService;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveMoveServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveMoveServiceReqTaskBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveMoveServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocApproveMoveService"})
public class UocApproveMoveServiceImpl
implements UocApproveMoveService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @PostMapping(value={"moveApprove"})
    public UocApproveMoveServiceRspBo moveApprove(@RequestBody UocApproveMoveServiceReqBo reqBo) {
        UocApproveMoveServiceRspBo rspBo = UocRu.success(UocApproveMoveServiceRspBo.class);
        return rspBo;
    }

    private void saveLog(UocApproveMoveServiceReqBo reqBo, Date now, Long auditOrderId, Boolean finished, Integer finalResult) {
        UocApprovalLog approvalLog = new UocApprovalLog();
        approvalLog.setFinish(finished != false ? UocConstant.AUDIT_LOG_FINISH.YES : UocConstant.AUDIT_LOG_FINISH.NO);
        approvalLog.setId(IdUtil.nextId());
        approvalLog.setOperid(reqBo.getUserId().toString());
        approvalLog.setOperName(reqBo.getName());
        approvalLog.setOperDept(reqBo.getOrgId().toString());
        approvalLog.setCreateTime(now);
        approvalLog.setDealTime(now);
        approvalLog.setAuditAdvice(reqBo.getDealReason());
        approvalLog.setAuditResult(finalResult);
        approvalLog.setObjType(reqBo.getObjBusiType());
        approvalLog.setAuditOrderId(auditOrderId);
        approvalLog.setAuditResult(reqBo.getFinalResult());
        UocAuditOrderDo logDo = new UocAuditOrderDo();
        logDo.setApprovalLog(approvalLog);
        this.iUocAuditOrderModel.saveAuditLog(logDo);
    }

    private UocOrderTaskDeal assembleTaskDealObj(UocApproveMoveServiceReqBo reqBo, UocApproveMoveServiceReqTaskBo nextTaskInfo) {
        UocOrderTaskDeal deal = new UocOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskInstId());
        deal.setOrderId(reqBo.getOrderId());
        deal.setObjId(reqBo.getObjId());
        deal.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        return deal;
    }

    private void validateArg(UocApproveMoveServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocApproveMoveServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[objid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProcInstId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6d41\u7a0b\u5b9e\u4f8bid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFinalResult())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5ba1\u6279\u7ed3\u679c 0\u901a\u8fc7 1\u9a73\u56de]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFinished())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5ba1\u6279\u662f\u5426\u7ed3\u675f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOldTaskInstId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u65e7\u4efb\u52a1\u5b9e\u4f8bid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getTaskBoList())) {
            for (UocApproveMoveServiceReqTaskBo uocApproveMoveServiceReqTaskBo : reqBo.getTaskBoList()) {
                this.validateTask(uocApproveMoveServiceReqTaskBo);
            }
        }
    }

    private void validateTask(UocApproveMoveServiceReqTaskBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocApproveMoveServiceReqTaskBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTaskInstId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u65b0\u4efb\u52a1\u5b9e\u4f8bid]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

