/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.insporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.insporder.UocGetInspOrderInfoService;
import com.tydic.dyc.oc.service.insporder.bo.UocGetInspOrderInfoServiceReqBo;
import com.tydic.dyc.oc.service.insporder.bo.UocGetInspOrderInfoServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.insporder.UocGetInspOrderInfoService"})
public class UocGetInspOrderInfoServiceImpl
implements UocGetInspOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(UocGetInspOrderInfoServiceImpl.class);
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"getInspOrderInfo"})
    public UocGetInspOrderInfoServiceRspBo getInspOrderInfo(@RequestBody UocGetInspOrderInfoServiceReqBo reqBo) {
        this.validateParam(reqBo);
        UocGetInspOrderInfoServiceRspBo rspBo = new UocGetInspOrderInfoServiceRspBo();
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        accessoryQryBo.setObjId(reqBo.getObjId());
        List<UocOrderAccessory> accessoryList = this.iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if (ObjectUtil.isNotEmpty(accessoryList)) {
            List<UocOrderAccessory> accessoryOtherList;
            Map<Integer, List<UocOrderAccessory>> accessoryMaps = accessoryList.stream().collect(Collectors.groupingBy(UocOrderAccessory::getAttachmentType));
            List<UocOrderAccessory> accessoryPicList = accessoryMaps.get(UocAttachementTypeConstants.ACCEPTANCE_PICTURE);
            if (ObjectUtil.isNotEmpty(accessoryPicList)) {
                List<UocBaseOrderAccessoryDetailBo> uocBaseAccessoryDetailBoList = UocRu.jsl(accessoryPicList, UocBaseOrderAccessoryDetailBo.class);
                rspBo.setAttchList(uocBaseAccessoryDetailBoList);
            }
            if (ObjectUtil.isNotEmpty(accessoryOtherList = accessoryMaps.get(UocAttachementTypeConstants.ACCEPTANCE_OTHER))) {
                List<UocBaseOrderAccessoryDetailBo> uocBaseOrderAccessoryDetailBoList = UocRu.jsl(accessoryOtherList, UocBaseOrderAccessoryDetailBo.class);
                rspBo.setAttchOtherList(uocBaseOrderAccessoryDetailBoList);
            }
        }
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
        if (ObjectUtil.isNotNull((Object)uocInspOrderDo)) {
            rspBo.setRemark(uocInspOrderDo.getRemark());
            rspBo.setOtherRemark(uocInspOrderDo.getOtherRemark());
        }
        return rspBo;
    }

    private void validateParam(UocGetInspOrderInfoServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new BaseBusinessException("100001", "\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

