/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateForInspReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateForInspRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqInspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqInspItemBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UocNumChngOrderCreateForInspTransaction {
    private static final Logger log = LoggerFactory.getLogger(UocNumChngOrderCreateForInspTransaction.class);
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    private static final Integer CHNG_TYPE_ADD = 1;
    private static final Integer CHNG_TYPE_SUBTRACT = 2;
    @Value(value="${uoc.inspect.allowSupportMoreChng:true}")
    private boolean allowSupportMoreChng;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public UocNumChngOrderCreateForInspRspBo createNumChng(UocNumChngOrderCreateForInspReqBo reqBo) {
        this.validateArg(reqBo);
        String operId = String.valueOf(reqBo.getUserId());
        Date now = new Date();
        List<UocInspOrderItem> inspOrderItemList = this.getInspOrderItemList(reqBo);
        this.checkChngingCount(reqBo, inspOrderItemList);
        List<UocSaleOrderItem> saleOrderItems = this.getImplOrderItemList(inspOrderItemList);
        UocChngOrderDo uocChngOrderDo = this.convertChngOrderDo(reqBo, operId, now, inspOrderItemList, saleOrderItems);
        this.iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        for (UocNumChngOrderCreateReqInspBo uocNumChngOrderCreateReqInspBo : reqBo.getChngItemList()) {
            this.iUocInspOrderModel.modifyInspOrderItemChngingCount(this.convertInspOrderDo(reqBo, uocNumChngOrderCreateReqInspBo, operId, now));
            this.iUocSaleOrderModel.modifyBatchItemChngingCount(this.convertImplOrderDo(reqBo, uocNumChngOrderCreateReqInspBo, inspOrderItemList, operId, now));
        }
        UocNumChngOrderCreateForInspRspBo uocNumChngOrderCreateRspBo = UocRu.success(UocNumChngOrderCreateForInspRspBo.class);
        uocNumChngOrderCreateRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocNumChngOrderCreateRspBo.setInspOrderIdList(reqBo.getChngItemList().stream().map(UocNumChngOrderCreateReqInspBo::getInspOrderId).collect(Collectors.toList()));
        log.debug("\u66f4\u65b0\u5173\u8054\u4fe1\u606f\u5f00\u59cb\uff1a" + JSON.toJSONString((Object)uocNumChngOrderCreateRspBo.getInspOrderIdList()));
        if (!CollectionUtils.isEmpty((Collection)uocNumChngOrderCreateRspBo.getInspOrderIdList())) {
            this.updateRelState(uocNumChngOrderCreateRspBo.getInspOrderIdList(), reqBo.getOrderId(), reqBo.getSaleOrderId());
        }
        log.debug("\u66f4\u65b0\u5173\u8054\u4fe1\u606f\u7ed3\u675f");
        uocNumChngOrderCreateRspBo.setChngOrderNo(uocChngOrderDo.getChngOrderNo());
        return uocNumChngOrderCreateRspBo;
    }

    private void updateRelState(List<Long> inspOrderIdList, Long orderId, Long saleOrderId) {
        for (Long inspOrderId : inspOrderIdList) {
            List<UocOrderRel> updateRelList;
            UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
            uocOrderRelQryBo.setObjId(inspOrderId);
            uocOrderRelQryBo.setOrderId(orderId);
            uocOrderRelQryBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
            List<UocOrderRel> qryRelResult = this.iUocOrderModel.qryListRelInfo(uocOrderRelQryBo);
            if (CollectionUtils.isEmpty(qryRelResult)) continue;
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setOrderId(orderId);
            uocSaleOrderDo.setSaleOrderId(saleOrderId);
            UocSaleOrderDo qrySaleResult = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
            if (null == qrySaleResult) {
                throw new BaseBusinessException("101006", "\u67e5\u8be2\u9500\u552e\u5355\u4e3a\u7a7a\uff01");
            }
            if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(qrySaleResult.getOrderSource())) {
                if (UocDicConstant.MODEL_SETTLE.TRADE.equals(qrySaleResult.getModelSettle())) {
                    updateRelList = qryRelResult.stream().filter(bo -> UocDicConstant.REL_TYPE.COMMON_INVOICE.equals(bo.getRelType()) || UocDicConstant.REL_TYPE.UP_INVOICE.equals(bo.getRelType())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(updateRelList)) continue;
                    this.updateRelStateData(updateRelList, UocDicConstant.REL_STATUS.HANG);
                    continue;
                }
                updateRelList = qryRelResult.stream().filter(bo -> UocDicConstant.REL_TYPE.CH_INVOICE.equals(bo.getRelType())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(updateRelList)) continue;
                this.updateRelStateData(updateRelList, UocDicConstant.REL_STATUS.HANG);
                continue;
            }
            if (UocDicConstant.MODEL_SETTLE.TRADE.equals(qrySaleResult.getModelSettle())) {
                updateRelList = qryRelResult.stream().filter(bo -> (UocDicConstant.REL_TYPE.COMMON_INVOICE.equals(bo.getRelType()) || UocDicConstant.REL_TYPE.UP_INVOICE.equals(bo.getRelType())) && !UocDicConstant.REL_STATUS.SUBMITTED.equals(bo.getRelStatus())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(updateRelList)) continue;
                this.updateRelStateData(updateRelList, UocDicConstant.REL_STATUS.HANG);
                continue;
            }
            updateRelList = qryRelResult.stream().filter(bo -> UocDicConstant.REL_TYPE.CH_INVOICE.equals(bo.getRelType()) && !UocDicConstant.REL_STATUS.SUBMITTED.equals(bo.getRelStatus())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(updateRelList)) continue;
            this.updateRelStateData(updateRelList, UocDicConstant.REL_STATUS.HANG);
        }
    }

    private void updateRelStateData(List<UocOrderRel> updateRelList, Integer relStatus) {
        for (UocOrderRel updateRel : updateRelList) {
            UocOrderRel updateRelPO = new UocOrderRel();
            updateRelPO.setId(updateRel.getId());
            updateRelPO.setRelStatus(relStatus);
            this.iUocOrderModel.dealRelUpdate(updateRelPO);
        }
    }

    private void checkChngingCount(UocNumChngOrderCreateForInspReqBo reqBo, List<UocInspOrderItem> inspOrderItemList) {
        Map<Long, UocInspOrderItem> uocInspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
        reqBo.getChngItemList().forEach(x -> x.getInspOrderItemList().forEach(y -> {
            UocInspOrderItem uocInspOrderItem = (UocInspOrderItem)uocInspOrderItemMap.get(y.getInspOrderItemId());
            if (uocInspOrderItem.getChngingCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException("101006", "\u5b58\u5728\u5f02\u5e38\u53d8\u66f4\u5728\u9014\u6570\u91cf\uff0c\u8bf7\u5f85\u53d8\u66f4\u5b8c\u7ed3\u540e\u518d\u53d1\u8d77");
            }
            Integer addOrDelType = y.getAddOrDelType();
            if (addOrDelType == 1) {
                if (!(this.allowSupportMoreChng || y.getChngCount().compareTo(BigDecimal.ZERO) >= 0 && y.getChngCount().compareTo(uocInspOrderItem.getInitInspCount().subtract(uocInspOrderItem.getRemainInspCount())) <= 0)) {
                    throw new BaseBusinessException("101008", "\u53d8\u66f4\u6570\u91cf\u8d85\u8fc7(\u521d\u59cb\u9a8c\u6536\u6570\u91cf-\u5269\u4f59\u9a8c\u6536\u91cf)\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
                }
            } else if (addOrDelType == 2 && (y.getChngCount().compareTo(BigDecimal.ZERO) < 0 || y.getChngCount().compareTo(uocInspOrderItem.getRemainInspCount()) > 0)) {
                throw new BaseBusinessException("101008", "\u53d8\u66f4\u6570\u91cf\u8d85\u8fc7\u5269\u4f59\u9a8c\u6536\u91cf\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        }));
    }

    private UocSaleOrderDo convertImplOrderDo(UocNumChngOrderCreateForInspReqBo reqBo, UocNumChngOrderCreateReqInspBo uocNumChngOrderCreateReqInspBo, List<UocInspOrderItem> inspOrderItemList, String operId, Date now) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(operId);
        Map<Long, UocInspOrderItem> uocInspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
        HashMap uocImplOrderItemMap = new HashMap();
        uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x -> {
            UocInspOrderItem uocInspOrderItem = (UocInspOrderItem)uocInspOrderItemMap.get(x.getInspOrderItemId());
            UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)((Object)((Object)uocImplOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId())));
            if (null == uocSaleOrderItem) {
                uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setSaleOrderItemId(uocInspOrderItem.getSaleOrderItemId());
                uocSaleOrderItem.setChngingCount(x.getChngCount());
            } else {
                uocSaleOrderItem.setChngingCount(uocSaleOrderItem.getChngingCount().add(x.getChngCount()));
            }
            uocImplOrderItemMap.put(uocInspOrderItem.getSaleOrderItemId(), uocSaleOrderItem);
        });
        uocSaleOrderDo.setSaleOrderItems(new ArrayList<UocSaleOrderItem>(uocImplOrderItemMap.values()));
        return uocSaleOrderDo;
    }

    private UocInspOrderDo convertInspOrderDo(UocNumChngOrderCreateForInspReqBo reqBo, UocNumChngOrderCreateReqInspBo uocNumChngOrderCreateReqInspBo, String operId, Date now) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderDo.setInspOrderId(uocNumChngOrderCreateReqInspBo.getInspOrderId());
        uocInspOrderDo.setUpdateOperId(operId);
        uocInspOrderDo.setUpdateTime(now);
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x -> {
            UocInspOrderItem uocInspOrderItem = new UocInspOrderItem();
            uocInspOrderItem.setInspOrderItemId(x.getInspOrderItemId());
            uocInspOrderItem.setChngingCount(x.getChngCount());
            uocInspOrderItemList.add(uocInspOrderItem);
        });
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        return uocInspOrderDo;
    }

    private UocChngOrderDo convertChngOrderDo(UocNumChngOrderCreateForInspReqBo reqBo, String operId, Date now, List<UocInspOrderItem> inspOrderItemList, List<UocSaleOrderItem> saleOrderItems) {
        Map<Long, UocInspOrderItem> inspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
        Map<Long, UocSaleOrderItem> implOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderState("CHNG_CHNG_QRZ");
        uocChngOrderDo.setCreateOperId(operId);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderDo.setRemark(reqBo.getRemark());
        uocChngOrderDo.setChngOrderNo(this.getChngOrderNo(reqBo));
        ArrayList<UocChngOrderObj> uocChngOrderObjList = new ArrayList<UocChngOrderObj>();
        for (UocNumChngOrderCreateReqInspBo uocNumChngOrderCreateReqInspBo : reqBo.getChngItemList()) {
            UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
            uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
            uocChngOrderObj.setOrderId(reqBo.getOrderId());
            uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
            uocChngOrderObj.setInspOrderId(uocNumChngOrderCreateReqInspBo.getInspOrderId());
            uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
            uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.NUM);
            uocChngOrderObj.setCreateOperId(operId);
            uocChngOrderObj.setCreateTime(now);
            ArrayList<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<UocChngOrderItemObj>();
            uocChngOrderObj.setChngNum(BigDecimal.ZERO);
            uocChngOrderObj.setChngFee(BigDecimal.ZERO);
            uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x -> {
                UocInspOrderItem uocInspOrderItem = (UocInspOrderItem)inspOrderItemMap.get(x.getInspOrderItemId());
                UocSaleOrderItem saleOrderItem = (UocSaleOrderItem)((Object)((Object)implOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId())));
                UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setChngNumPre(x.getRemainInspNum());
                uocChngOrderItemObj.setChngNum(x.getChngCount());
                uocChngOrderItemObj.setChngFee(x.getChngCount().multiply(saleOrderItem.getSalePrice()));
                uocChngOrderItemObj.setChngPurchaseFee(x.getChngCount().multiply(saleOrderItem.getPurchasePrice()));
                uocChngOrderItemObj.setChngOrderId(uocChngOrderObj.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setInspOrderItemId(x.getInspOrderItemId());
                uocChngOrderItemObj.setImplOrderItemId(uocInspOrderItem.getImplOrderItemId());
                uocChngOrderItemObj.setSaleOrderItemId(uocInspOrderItem.getSaleOrderItemId());
                uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.NUM);
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setCreateOperId(operId);
                uocChngOrderItemObj.setCreateTime(now);
                uocChngOrderItemObj.setAddOrSubtractType(x.getAddOrDelType());
                uocChngOrderItemObj.setRemainInspCount(x.getRemainInspNum());
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
                uocChngOrderObj.setChngNum(uocChngOrderObj.getChngNum().add(x.getChngCount()));
                if (x.getAddOrDelType().equals(CHNG_TYPE_ADD)) {
                    uocChngOrderObj.setChngFee(uocChngOrderObj.getChngFee().subtract(uocChngOrderItemObj.getChngFee()));
                } else if (x.getAddOrDelType().equals(CHNG_TYPE_SUBTRACT)) {
                    uocChngOrderObj.setChngFee(uocChngOrderObj.getChngFee().add(uocChngOrderItemObj.getChngFee()));
                }
            });
            uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
            uocChngOrderObjList.add(uocChngOrderObj);
        }
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtParallelBoList())) {
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setOrderId(uocChngOrderDo.getOrderId());
                uocChngOrderMap.setCreateOperId(operId);
                uocChngOrderMap.setCreateTime(now);
                uocChngOrderMap.setId(IdUtil.nextId());
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setAttachmentType(1);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
            });
            uocChngOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        return uocChngOrderDo;
    }

    private String getChngOrderNo(UocNumChngOrderCreateForInspReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u67e5\u8be2\u9500\u552e\u5355\u4e3a\u7a7a");
        }
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = this.iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    private List<UocInspOrderItem> getInspOrderItemList(UocNumChngOrderCreateForInspReqBo reqBo) {
        ArrayList<UocInspOrderItem> inspOrderItems = new ArrayList<UocInspOrderItem>();
        for (UocNumChngOrderCreateReqInspBo uocNumChngOrderCreateReqInspBo : reqBo.getChngItemList()) {
            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
            uocInspOrderItemQryBo.setInspOrderItemIdList(uocNumChngOrderCreateReqInspBo.getInspOrderItemList().stream().map(UocNumChngOrderCreateReqInspItemBo::getInspOrderItemId).collect(Collectors.toList()));
            uocInspOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocInspOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            uocInspOrderItemQryBo.setInspOrderId(uocNumChngOrderCreateReqInspBo.getInspOrderId());
            UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
            if (CollectionUtils.isEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
                throw new BaseBusinessException("101006", "\u67e5\u8be2\u53d1\u8d27\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
            }
            inspOrderItems.addAll(uocInspOrderDo.getUocInspOrderItemList());
        }
        return inspOrderItems;
    }

    private List<UocSaleOrderItem> getImplOrderItemList(List<UocInspOrderItem> uocInspOrderItemList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocInspOrderItemList.get(0).getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(uocInspOrderItemList.stream().map(UocInspOrderItem::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException("101006", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
        }
        return saleOrderItemList;
    }

    private void validateArg(UocNumChngOrderCreateForInspReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getChngItemList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a");
        }
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqInspBo -> {
            if (null == uocNumChngOrderCreateReqInspBo.getInspOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5355ID\u4e3a\u7a7a");
            }
            if (null == uocNumChngOrderCreateReqInspBo.getInspOrderItemList()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5bf9\u8c61\u4e3a\u7a7a");
            }
            uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x -> {
                if (null == x.getInspOrderItemId()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5355\u660e\u7ec6ID\u4e3a\u7a7a");
                }
                if (null == x.getChngCount()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u6570\u91cf\u4e3a\u7a7a");
                }
                if (null == x.getAddOrDelType()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u7c7b\u578b\u4e3a\u7a7a");
                }
                if (null == x.getRemainInspNum()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5269\u4f59\u9a8c\u6536\u6570\u91cf\u4e3a\u7a7a");
                }
                if (1 != x.getAddOrDelType() && 2 != x.getAddOrDelType()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u7c7b\u578b\u9519\u8bef");
                }
            });
        });
    }
}

