/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.transactionservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderDeleteServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class UocSaleOrderDeleteTransaction {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    public UocSaleOrderDeleteServiceRspBo deleteSaleOrder(UocSaleOrderDeleteServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)uocSaleOrderQryBo));
        UocSaleOrderDo querySaleOrderResultDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (null != querySaleOrderResultDo) {
            UocSaleOrderDo deleteSaleOrderDo = new UocSaleOrderDo();
            BeanUtils.copyProperties((Object)reqBo, (Object)((Object)deleteSaleOrderDo));
            this.iUocSaleOrderModel.deleteSaleOrder(deleteSaleOrderDo);
            return UocRu.success(UocSaleOrderDeleteServiceRspBo.class);
        }
        throw new BaseBusinessException("103001", "\u8be5\u9500\u552e\u5355\u4e0d\u5b58\u5728");
    }

    private void validateArg(UocSaleOrderDeleteServiceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

