package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：UocEsSyncOrder
 * 说明：整单同步ES
 * 时间：2022/5/19 16:08
 *
 * @author 文乐
 */
@Slf4j
@Component
public class UocEsSyncOrder implements IUocEsSync {

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    protected static final List<String> pCodeList = ListUtil.list(false);

    public static final String DEFAULT_STATE = "1";
    public static final String DEFAULT_PAY_TYPE = "2";

    static {
        initialize();
    }

    private static void initialize() {
        // 整单状态字典
        pCodeList.add(UocStateConstants.Order.P_CODE);
        pCodeList.add(UocDicConstant.PAY_TYPE.P_CODE);
    }

    @Override
    public String indexName() {
        return uocIndexConfig.getOrderIndex();
    }

//    @Override
//    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
//        log.info("整单同步ES入参,{}", JSON.toJSONString(reqBo));
//        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
//        rspBo.setObjId(reqBo.getOrderId());
//        // 查询订单
//        UocOrderDo uocOrderDo = getOrder(reqBo);
//        if (Objects.isNull(uocOrderDo)) {
//            return rspBo;
//        }
//        //获取字典集合
////        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
//        //订单扩展
//        List<UocOrderMap> orderMapList = getOrderMapList(reqBo.getOrderId());
//        //查询业务流程实例
//        UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = getProcInst(reqBo, false, UocDicConstant.OBJ_TYPE.ORDER);
//        //查询审批流程实例
//        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = getAuditProcInst(reqBo, UocDicConstant.OBJ_TYPE.ORDER);
//        //查询审批单
//        List<UocAuditOrderDo> auditOrderList = getAuditOrderList(reqBo);
//        //查询订单商品明细
//        List<UocOrderItem> uocOrderItemList = getOrderInfoList(reqBo);
//        //查询订单商品明细扩展
//        List<UocOrderItemMap> uocOrderItemMapList = getOrderInfoExtList(reqBo);
//        //订单三方信息
//        List<UocOrderStakeholderQryBo> stakeholderList = getStakeholderList(reqBo.getOrderId());
//
//
//        //订单
//        JSONObject orderObj = JSON.parseObject(JSON.toJSONString(uocOrderDo));
//
//
//        // 订单扩展
//        if (ObjectUtil.isNotEmpty(orderMapList)) {
//            orderMapList.forEach(each -> orderObj.put(each.getFieldCode(), each.getFieldValue()));
//        }
//        // 三方信息
//        orderObj.put(UocConstant.ES_MAIN_OTHER.STAKEHOLDERS, JSON.parseArray(JSON.toJSONString(stakeholderList)));
//        orderObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_ORG_NAME, stakeholderList.get(0).getPurOrgName());
//        orderObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_ORG_ID, stakeholderList.get(0).getPurOrgId());
//        orderObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_COMPANY_NAME, stakeholderList.get(0).getPurCompanyName());
//        orderObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_COMPANY_ID, stakeholderList.get(0).getPurCompanyId());
//        orderObj.put(UocConstant.ES_MAIN_OTHER.PUR_NAME, stakeholderList.get(0).getPurName());
//        orderObj.put(UocConstant.ES_MAIN_OTHER.PUR_USER_NAME, stakeholderList.get(0).getPurUserName());
//        orderObj.put(UocConstant.ES_MAIN_OTHER.PUR_USER_ID, stakeholderList.get(0).getPurUserId());
//        // 供应商ID列表
//        List<String> supIdList = stakeholderList.stream().map(UocOrderStakeholderQryBo::getSupId).distinct().collect(Collectors.toList());
//        orderObj.put(UocConstant.ES_MAIN_OTHER.SUPPLIER_ID_LIST, supIdList);
//        // 审批单列表
//        orderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_ORDER, auditOrderList);
//        // 订单商品信息
//        if (!CollectionUtils.isEmpty(uocOrderItemList)) {
//            JSONArray orderItemArray = new JSONArray();
//            if ( !CollectionUtils.isEmpty(uocOrderItemMapList) ) {
//                Map<Long, List<UocOrderItemMap>> itemMapList = uocOrderItemMapList.stream().collect(Collectors.groupingBy(UocOrderItemMap::getOrderItemId));
//                for (UocOrderItem uocOrderItem : uocOrderItemList) {
//                    JSONObject uocOrderItemObj = JSON.parseObject(JSON.toJSONString(uocOrderItem, SerializerFeature.WriteMapNullValue));
//                    itemMapList.get(uocOrderItem.getOrderItemId()).forEach(itemExt -> uocOrderItemObj.put(itemExt.getFieldCode(), itemExt.getFieldValue()));
//                    orderItemArray.add(uocOrderItemObj);
//                }
//                orderObj.put(UocConstant.ES_MAIN_OTHER.COMMODITY_INFOS, orderItemArray);
//            } else {
//                orderObj.put(UocConstant.ES_MAIN_OTHER.COMMODITY_INFOS, JSON.parseArray(JSON.toJSONString(uocOrderItemList)));
//            }
//        }
//        // 业务流任务信息
//        orderObj.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_INST, busiProcInst.getProcInstId());
//        orderObj.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, busiProcInst.getTaskList());
//        // 审批流程信息
//        orderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_INST, auditProcInst.getProcInstId());
//        orderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_DEF_ID, auditProcInst.getProcDefId());
//        orderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_TASK_INST, auditProcInst.getTaskList());
//        // 订单总金额
//        orderObj.put(UocConstant.ES_MAIN_OTHER.ORDER_TOTAL, uocOrderDo.getTotalSaleFee());
//        // 华润都是帐期支付
//        Map<String, String> payTypeDicMap = dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE);
//        orderObj.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE, DEFAULT_PAY_TYPE);
//        orderObj.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE_STR, payTypeDicMap.get(DEFAULT_PAY_TYPE));
//        //审批处理结果  1:审批通过；0:审批驳回
//        Integer dealResult = 1;
//        List<UocGetSaleOrderDetailServiceRspTaskBo> auditTaskList = auditProcInst.getTaskList();
//        for (UocGetSaleOrderDetailServiceRspTaskBo taskBo: auditTaskList) {
//           if(ObjectUtil.isNotEmpty(taskBo.getDealResult()) && taskBo.getDealResult().equals(0)) {
//               dealResult = 0;
//           }
//        }
//        // 订单状态
//        setState(orderObj, busiProcInst, uocOrderDo.getOrderState(), dictionaryMap,dealResult);
//
//        rspBo.setJsonObj(orderObj);
//        log.info("整单同步ES参数：{}", JSON.toJSONString(rspBo));
//        return rspBo;
//    }

    /**
     * @remark 字典翻译代码重构
     * @author 欧迅
     * @time 2025.1.17
     */
    //todo 待删
    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        log.info("整单同步ES入参,{}", JSON.toJSONString(reqBo));
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getOrderId());
        // 查询订单
        UocOrderDo uocOrderDo = getOrder(reqBo);
        if (Objects.isNull(uocOrderDo)) {
            return rspBo;
        }
        //获取字典集合
//        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        //订单扩展
        List<UocOrderMap> orderMapList = getOrderMapList(reqBo.getOrderId());
        //查询业务流程实例
        UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = getProcInst(reqBo, false, UocDicConstant.OBJ_TYPE.ORDER);
        //查询审批流程实例
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = getAuditProcInst(reqBo, UocDicConstant.OBJ_TYPE.ORDER);
        //查询审批单
        List<UocAuditOrderDo> auditOrderList = getAuditOrderList(reqBo);
        //查询订单商品明细
        List<UocOrderItem> uocOrderItemList = getOrderInfoList(reqBo);
        //查询订单商品明细扩展
        List<UocOrderItemMap> uocOrderItemMapList = getOrderInfoExtList(reqBo);
        //订单三方信息
        List<UocOrderStakeholderQryBo> stakeholderList = getStakeholderList(reqBo.getOrderId());


        //订单
        JSONObject orderObj = JSON.parseObject(JSON.toJSONString(uocOrderDo));


        // 订单扩展
        if (ObjectUtil.isNotEmpty(orderMapList)) {
            orderMapList.forEach(each -> orderObj.put(each.getFieldCode(), each.getFieldValue()));
        }
        // 三方信息
        orderObj.put(UocConstant.ES_MAIN_OTHER.STAKEHOLDERS, JSON.parseArray(JSON.toJSONString(stakeholderList)));
        orderObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_ORG_NAME, stakeholderList.get(0).getPurOrgName());
        orderObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_ORG_ID, stakeholderList.get(0).getPurOrgId());
        orderObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_COMPANY_NAME, stakeholderList.get(0).getPurCompanyName());
        orderObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_COMPANY_ID, stakeholderList.get(0).getPurCompanyId());
        orderObj.put(UocConstant.ES_MAIN_OTHER.PUR_NAME, stakeholderList.get(0).getPurName());
        orderObj.put(UocConstant.ES_MAIN_OTHER.PUR_USER_NAME, stakeholderList.get(0).getPurUserName());
        orderObj.put(UocConstant.ES_MAIN_OTHER.PUR_USER_ID, stakeholderList.get(0).getPurUserId());
        // 供应商ID列表
        List<String> supIdList = stakeholderList.stream().map(UocOrderStakeholderQryBo::getSupId).distinct().collect(Collectors.toList());
        orderObj.put(UocConstant.ES_MAIN_OTHER.SUPPLIER_ID_LIST, supIdList);
        // 审批单列表
        orderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_ORDER, auditOrderList);
        // 订单商品信息
        if (!CollectionUtils.isEmpty(uocOrderItemList)) {
            JSONArray orderItemArray = new JSONArray();
            if ( !CollectionUtils.isEmpty(uocOrderItemMapList) ) {
                Map<Long, List<UocOrderItemMap>> itemMapList = uocOrderItemMapList.stream().collect(Collectors.groupingBy(UocOrderItemMap::getOrderItemId));
                for (UocOrderItem uocOrderItem : uocOrderItemList) {
                    JSONObject uocOrderItemObj = JSON.parseObject(JSON.toJSONString(uocOrderItem, SerializerFeature.WriteMapNullValue));
                    itemMapList.get(uocOrderItem.getOrderItemId()).forEach(itemExt -> uocOrderItemObj.put(itemExt.getFieldCode(), itemExt.getFieldValue()));
                    orderItemArray.add(uocOrderItemObj);
                }
                orderObj.put(UocConstant.ES_MAIN_OTHER.COMMODITY_INFOS, orderItemArray);
            } else {
                orderObj.put(UocConstant.ES_MAIN_OTHER.COMMODITY_INFOS, JSON.parseArray(JSON.toJSONString(uocOrderItemList)));
            }
        }
        // 业务流任务信息
        orderObj.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_INST, busiProcInst.getProcInstId());
        orderObj.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, busiProcInst.getTaskList());
        // 审批流程信息
        orderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_INST, auditProcInst.getProcInstId());
        orderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_DEF_ID, auditProcInst.getProcDefId());
        orderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_TASK_INST, auditProcInst.getTaskList());
        // 订单总金额
        orderObj.put(UocConstant.ES_MAIN_OTHER.ORDER_TOTAL, uocOrderDo.getTotalSaleFee());
        // 华润都是帐期支付
//        Map<String, String> payTypeDicMap = dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE);
        orderObj.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE, DEFAULT_PAY_TYPE);
        orderObj.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE_STR, DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocDicConstant.PAY_TYPE.P_CODE,DEFAULT_PAY_TYPE)==null?null:DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocDicConstant.PAY_TYPE.P_CODE,DEFAULT_PAY_TYPE).getValue());
        //审批处理结果  1:审批通过；0:审批驳回
        Integer dealResult = 1;
        List<UocGetSaleOrderDetailServiceRspTaskBo> auditTaskList = auditProcInst.getTaskList();
        for (UocGetSaleOrderDetailServiceRspTaskBo taskBo: auditTaskList) {
            if(ObjectUtil.isNotEmpty(taskBo.getDealResult()) && taskBo.getDealResult().equals(0)) {
                dealResult = 0;
            }
        }
        // 订单状态
        setState(orderObj, busiProcInst, uocOrderDo.getOrderState(), dealResult);

        rspBo.setJsonObj(orderObj);
        log.info("整单同步ES参数：{}", JSON.toJSONString(rspBo));
        return rspBo;
    }

//    /**
//     * 订单状态
//     * @param orderObj
//     * @param busiProcInst
//     * @param orderState
//     * @param dictionaryMap
//     */
//    private void setState(JSONObject orderObj, UocGetSaleOrderDetailServiceRspPorcBo busiProcInst, String orderState, Map<String, Map<String, String>> dictionaryMap,Integer dealResult) {
//        Map<String, String> orderStateMap = dictionaryMap.get(UocStateConstants.Order.P_CODE);
//        if (StringUtils.isNotBlank(orderState) && !DEFAULT_STATE.equals(orderState)) {
//            orderObj.put(UocConstant.ES_MAIN_OTHER.ORDER_STATE_STR, orderStateMap.get(orderState));
//        } else if (ObjectUtil.isEmpty(orderState) && StringUtils.isNotBlank(busiProcInst.getProcState())) {
//            orderObj.put(UocConstant.ES_MAIN_OTHER.ORDER_STATE_STR, orderStateMap.get(busiProcInst.getProcState()));
//        }else if(dealResult.equals(0)){
//            orderObj.put(UocConstant.ES_MAIN_OTHER.ORDER_STATE_STR, orderStateMap.get(UocStateConstants.Order.ZD_SP_BHQX));
//        }
//    }
    /**
     * @remark 字典翻译代码重构
     * @author 欧迅
     * @time 2025.1.17
     */
    //todo 待删
    /**
     * 订单状态
     * @param orderObj
     * @param busiProcInst
     * @param orderState\
     */
    private void setState(JSONObject orderObj, UocGetSaleOrderDetailServiceRspPorcBo busiProcInst, String orderState, Integer dealResult) {
//        Map<String, String> orderStateMap = dictionaryMap.get(UocStateConstants.Order.P_CODE);
        if (StringUtils.isNotBlank(orderState) && !DEFAULT_STATE.equals(orderState)) {
            orderObj.put(UocConstant.ES_MAIN_OTHER.ORDER_STATE_STR, DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocStateConstants.Order.P_CODE,orderState)==null?null:DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocStateConstants.Order.P_CODE,orderState).getValue());
        } else if (ObjectUtil.isEmpty(orderState) && StringUtils.isNotBlank(busiProcInst.getProcState())) {
            orderObj.put(UocConstant.ES_MAIN_OTHER.ORDER_STATE_STR, DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocStateConstants.Order.P_CODE,busiProcInst.getProcState())==null?null:DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocStateConstants.Order.P_CODE,busiProcInst.getProcState()).getValue());
        }else if(dealResult.equals(0)){
            orderObj.put(UocConstant.ES_MAIN_OTHER.ORDER_STATE_STR, DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocStateConstants.Order.P_CODE,UocStateConstants.Order.ZD_SP_BHQX)==null?null:DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocStateConstants.Order.P_CODE,UocStateConstants.Order.ZD_SP_BHQX).getValue());
        }
    }

    /**
     * 订单三方信息
     */
    private List<UocOrderStakeholderQryBo> getStakeholderList(Long orderId) {
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(orderId);
        return iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
    }

    /**
     * 订单扩展
     * @param orderId
     * @return
     */
    private List<UocOrderMap> getOrderMapList(Long orderId) {
        UocOrderMapQryBo uocOrderMapQryBo = new UocOrderMapQryBo();
        uocOrderMapQryBo.setOrderId(orderId);
        return iUocOrderModel.qryOrderMapList(uocOrderMapQryBo);
    }

    /**
     * 查询订单商品明细扩展
     * @param reqBo
     * @return
     */
    private List<UocOrderItemMap> getOrderInfoExtList(IUocEsSyncQryReqBo reqBo) {
        UocOrderItemMapQryBo uocOrderItemMapQryBo = new UocOrderItemMapQryBo();
        uocOrderItemMapQryBo.setOrderId(reqBo.getOrderId());
        return iUocOrderModel.qryOrderItemMapList(uocOrderItemMapQryBo);
    }

    /**
     * 查询订单商品明细
     * @param reqBo
     * @return
     */
    private List<UocOrderItem> getOrderInfoList(IUocEsSyncQryReqBo reqBo) {
        UocOrderItemQryBo uocOrderItemQryBo = new UocOrderItemQryBo();
        uocOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return iUocOrderModel.qryOrderItemList(uocOrderItemQryBo);
    }

    private UocOrderDo getOrder(IUocEsSyncQryReqBo reqBo) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        return iUocOrderModel.qryOrderBy(uocOrderDo);
    }

    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param objType
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(IUocEsSyncQryReqBo reqBo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        //查询订单对应的审批单id
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setObjId(reqBo.getObjId() + "");
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            //查询审批单对应的任务
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            //taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    /*UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);*/
                    List<UocOrderTaskDeal> uocOrderTaskDeals = new ArrayList<>();
                    UocOrderTaskDeal uocOrderTaskDeal = new UocOrderTaskDeal();
                    BeanUtils.copyProperties(each, uocOrderTaskDeal);
                    uocOrderTaskDeal.setDealId(each.getTaskUserId().toString());
                    uocOrderTaskDeal.setDealName(each.getTaskUserName());
                    uocOrderTaskDeals.add(uocOrderTaskDeal);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDea = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDea.getDealId();
                        String dealName = uocOrderTaskDea.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId()+"_"+each.getObjBusiType();
                    if(each.getDealResult()!=null){
                        auditDealResultQryKey = auditDealResultQryKey+"_"+each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(CollectionUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                    Date finishTime = each.getFinishTime();
                    String dealId = each.getDealId();

                    if (ObjectUtil.isNotEmpty(finishTime) && ObjectUtil.isNotEmpty(dealId)) {
                        each.setFinishTimeStr(dealId + objBusiType + finishTime.getTime());
                    }

                });
                procInst.setTaskList(taskBoList);
                procInst.setProcInstId(uocOrderTaskInsts.get(0).getProcInstId());
            }

        }
        return procInst;
    }

    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param isAudit
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getObjId());
            procInstQryBo.setObjType(objType);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            List<Integer> finishTagList = new ArrayList<>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
//            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                /*taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });*/

                //为了联调，先取第一个环节编码和任务id
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            }

            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    /**
     * 查询审批单
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.audit.sub.UocAuditOrder>
     */
  /*  private List<UocAuditOrderDo> getAuditOrderList(IUocEsSyncQryReqBo reqBo) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(reqBo.getOrderId());
        obj.setObjId(reqBo.getObjId().toString());
        obj.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(obj);
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<>();
        }
        List<Long> auditOrderIdList = new ArrayList<>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(reqBo.getOrderId());
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        List<UocAuditOrder> uocAuditOrders = iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map<Long, List<UocApprovalObj>> approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> {
                each.setApprovalObjs(approvalObjMap.get(each.getAuditOrderId()));
            });
        }
        return uocAuditOrderDoList;
    }*/
    /**
     * 查询审批单
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.audit.sub.UocAuditOrder>
     */
    private List<UocAuditOrderDo> getAuditOrderList(IUocEsSyncQryReqBo reqBo) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(reqBo.getOrderId());
        obj.setObjId(reqBo.getObjId().toString());
        obj.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(obj);
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<>();
        }
        List<Long> auditOrderIdList = new ArrayList<>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(reqBo.getOrderId());
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        List<UocAuditOrder> uocAuditOrders = iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrders.forEach(uocAuditOrder -> {
                // 查询流程实例
                UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
                procInstQryBo.setObjId(uocAuditOrder.getAuditOrderId());
                procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                procInstQryBo.setOrderId(reqBo.getOrderId());
                List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
                if (!CollectionUtils.isEmpty(uocOrderProcInsts)) {
                    uocAuditOrder.setProcInstId(uocOrderProcInsts.get(0).getProcInstId());
                }
            });
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map<Long, List<UocApprovalObj>> approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> {
                each.setApprovalObjs(approvalObjMap.get(each.getAuditOrderId()));
            });
        }
        return uocAuditOrderDoList;
    }
}
