package com.tydic.dyc.oc.model.order.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrderProcInstQryBo
 * 说明:订单流程实例
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocOrderProcInstQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  -4886139875620169114L;

	//id")
	private Long id;

	//订单id")
	private Long orderId;

	//流程实例id")
	private String procInstId;

	//流程key定义")
	private String procDefId;

	//单据id")
	private Long objId;

	//单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//当前环节")
	private String procState;

	//完结标志0未完结1已完结")
	private Integer finishTag;

	//完成时间")
	private Date finishTime;

	//完成时间 开始")
	private Date finishTimeStart;

	//完成时间 结束")
	private Date finishTimeEnd;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//排除的对象类型")
	private List<Integer> objTypeNoInList;

	//单据idList")
	private List<Long> objIdList;
	/**
	 * 所属中心:
	 AGR：协议
	 UOC：订单
	 UMC：会员
	 FSC：结算
	 UCC：商品
	 */
	private String centerCode;
}
