package com.tydic.dyc.oc.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.transactionservice.UocArrvalAcceptanceTransaction;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-到货验收实现〉
 * @author : yuhao
 * @date : 2022/8/26 16:44
 */
@Slf4j
@HTServiceImpl
public class UocArrvalAcceptanceServiceImpl implements UocArrvalAcceptanceService {

    @Autowired
    private UocArrvalAcceptanceTransaction uocArrvalAcceptanceTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;


    @Override
    public UocArrvalAcceptanceRspBo dealArrvalAcceptance(UocArrvalAcceptanceReqBo reqBo) {

        UocArrvalAcceptanceRspBo rspBo = uocArrvalAcceptanceTransaction.dealArrvalAcceptance(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地 线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocArrvalAcceptanceReqBo reqBo, UocArrvalAcceptanceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        SyncEsRunnableBo inspBo = new SyncEsRunnableBo();
        inspBo.setIndexName(uocIndexConfig.getInspOrderIndex());
        inspBo.setOrderId(reqBo.getOrderId());
        inspBo.setObjId(rspBo.getInspOrderId());
        inspBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);

        //同步发货单
        if (!CollectionUtils.isEmpty(reqBo.getShipOrderList())) {
            for (UocCreateInspOrderReqShipBo bo : reqBo.getShipOrderList()) {
                SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
                shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
                shipBo.setOrderId(reqBo.getOrderId());
                shipBo.setObjId(bo.getShipOrderId());
                shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
                list.add(shipBo);
            }
        }

        //同步成交服务费
        /*SyncEsRunnableBo transactionBo = new SyncEsRunnableBo();
        transactionBo.setIndexName(uocIndexConfig.getTransactionIndex());
        transactionBo.setOrderId(reqBo.getOrderId());
        transactionBo.setObjId(rspBo.getInspOrderId());
        transactionBo.setJsonObj(reqBo.getJsonObj());
        transactionBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        transactionBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);*/

        //list.add(transactionBo);
        list.add(saleBo);
        list.add(inspBo);
        log.debug("验收单es同步：" + JSON.toJSONString(list));
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }

}
