package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocEvaluateQryBo;
import com.tydic.dyc.oc.model.order.sub.UocEvaluate;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceRspBo;
import com.tydic.dyc.oc.transactionservice.UocEvaluateDealTransaction;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单评价回调实现〉
 * @author : yuhao
 * @date : 2022/9/9 14:48
 */
@Slf4j
@HTServiceImpl
public class UocEvaluateDealServiceImpl implements UocEvaluateDealService {


    @Autowired
    private UocEvaluateDealTransaction uocEvaluateDealTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocEvaluateDealServiceRspBo dealEvaluate(UocEvaluateDealServiceReqBo reqBo) {
        UocEvaluateDealServiceRspBo rspBo = uocEvaluateDealTransaction.dealEvaluate(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地 线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }


    private void syncEs(UocEvaluateDealServiceReqBo reqBo, UocEvaluateDealServiceRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);
        log.debug("评价es同步：" + JSON.toJSONString(list));
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
