package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.core.approve.repository.api.ApproveRepository;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskQryDo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.service.domainservice.bo.UocWaitTodoParameterQryServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocWaitTodoParameterQryServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocWaitTodoParameterQryServiceRspDataBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题:UocApproveWaitTodoParameterQryServiceImpl
 * 说明:
 * 时间:2023/10/24 14:25
 * 作者:田桂银
 */
@HTServiceImpl
public class UocWaitTodoParameterQryServiceImpl implements UocWaitTodoParameterQryService {

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    //@Autowired
    //private UocCommonRepository uocCommonRepository;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private ApproveRepository approveRepository;

    @Override
    public UocWaitTodoParameterQryServiceRspBo qryApproveWaitTodoParameter(UocWaitTodoParameterQryServiceReqBo reqBo) {
        validateArg(reqBo);
        UocWaitTodoParameterQryServiceRspBo rspBo = UocRu.success(UocWaitTodoParameterQryServiceRspBo.class);
        BeanUtils.copyProperties(reqBo, rspBo);
        if (UocDicConstant.OBJ_TYPE.APPROVE.equals(reqBo.getObjType())) {
            //查询审批单数据处理
            UocAuditOrderQryBo qryAudit = new UocAuditOrderQryBo();
            qryAudit.setOrderId(reqBo.getOrderId());
            qryAudit.setAuditOrderId(reqBo.getObjId());
            UocAuditOrderDo uocAuditOrderDo = iUocAuditOrderModel.qryAuditOrder(qryAudit);
            if (ObjectUtil.isEmpty(uocAuditOrderDo)) {
                rspBo.setRespCode(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR);
                rspBo.setRespDesc("该审批单数据不存在");
                return rspBo;
            }
            //查询taskid
            UocOrderTaskInst qryTaskBo = new UocOrderTaskInst();
            qryTaskBo.setOrderId(reqBo.getOrderId());
            qryTaskBo.setObjId(reqBo.getObjId());
            qryTaskBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            qryTaskBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
            qryTaskBo.setCenterCode(UocConstant.CENTER_CODE);
            //List<UocOrderTaskInst> uocOrderTaskInsts = uocCommonRepository.qryTaskInstList(qryTaskBo);
            List<UocOrderTaskInst> uocOrderTaskInsts = UocRu.jsl(approveRepository.queryFlowTask(UocRu.js(qryTaskBo, FlowTaskQryDo.class)), UocOrderTaskInst.class);
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                String taskInstId = uocOrderTaskInsts.get(0).getTaskInstId();
                UocWaitTodoParameterQryServiceRspDataBo parameter = new UocWaitTodoParameterQryServiceRspDataBo();
                parameter.setKey("taskId");
                parameter.setValue(taskInstId);
                rspBo.getParameterList().add(parameter);
            }

            //查询审批实例id
            UocOrderProcInst qryProcInstBo = new UocOrderProcInst();
            qryProcInstBo.setOrderId(reqBo.getOrderId());
            qryProcInstBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            qryProcInstBo.setCenterCode(UocConstant.CENTER_CODE);
            //List<UocOrderProcInst> uocOrderProcInsts = uocCommonRepository.qryProcInsList(qryProcInstBo);
            List<UocOrderProcInst> uocOrderProcInsts = UocRu.jsl(approveRepository.queryFlowTask(UocRu.js(qryProcInstBo, FlowTaskQryDo.class)), UocOrderProcInst.class);
            if(ObjectUtil.isNotEmpty(uocOrderProcInsts)){
                String procInstId = uocOrderProcInsts.get(0).getProcInstId();
                UocWaitTodoParameterQryServiceRspDataBo parameter = new UocWaitTodoParameterQryServiceRspDataBo();
                parameter.setKey("procInstId");
                parameter.setValue(procInstId);
                rspBo.getParameterList().add(parameter);
            }

        } else if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())){
            //查询销售单数据
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setSaleOrderId(reqBo.getObjId());
            uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
            UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            if (ObjectUtil.isEmpty(saleOrderMainInfo)) {
                rspBo.setRespCode(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR);
                rspBo.setRespDesc("该销售单数据不存在");
                return rspBo;
            }
            //查询taskid
            UocOrderTaskInst qryTaskBo = new UocOrderTaskInst();
            qryTaskBo.setOrderId(reqBo.getOrderId());
            qryTaskBo.setObjId(reqBo.getObjId());
            qryTaskBo.setObjType(reqBo.getObjType());
            qryTaskBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
            qryTaskBo.setCenterCode(UocConstant.CENTER_CODE);
            //List<UocOrderTaskInst> uocOrderTaskInsts = uocCommonRepository.qryTaskInstList(qryTaskBo);
            List<UocOrderTaskInst> uocOrderTaskInsts = UocRu.jsl(approveRepository.queryFlowTask(UocRu.js(qryTaskBo, FlowTaskQryDo.class)), UocOrderTaskInst.class);
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                String taskInstId = uocOrderTaskInsts.get(0).getTaskInstId();
                UocWaitTodoParameterQryServiceRspDataBo parameter = new UocWaitTodoParameterQryServiceRspDataBo();
                parameter.setKey("taskId");
                parameter.setValue(taskInstId);
                rspBo.getParameterList().add(parameter);
            }
            return rspBo;
        } else {
            return rspBo;
        }
        return rspBo;
    }

    private void validateArg(UocWaitTodoParameterQryServiceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象orderId不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象objId不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象objType不能为空");
        }

    }
}


