package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderPayStateServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderPayStateServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 描述: 〈领域服务-更新销售单支付状态服务 实现〉
 * @author : 王钟游
 * @date : 2022-09-08 16:47
 */
@HTServiceImpl
@Slf4j
public class UocUpdateSaleOrderPayStateServiceImpl implements UocUpdateSaleOrderPayStateService {

    protected static final List<String> pCodeList = ListUtil.list(false);

    static {
        initialize();
    }

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private UocEsSyncManager uocEsSyncManager;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

//    @Override
//    public UocUpdateSaleOrderPayStateServiceRspBo updatePayState(UocUpdateSaleOrderPayStateServiceReqBo reqBo) {
//        //参数校验
//        this.verifyParam(reqBo);
//        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
//        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
//        UocSaleOrderDo saleOrderMain = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
//        if (null == saleOrderMain) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "查询销售单为空！");
//        }
//        uocSaleOrderDo.setOrderId(saleOrderMain.getOrderId());
//        uocSaleOrderDo.setPayState(reqBo.getPayState());
//        iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
//        //获取字典集合
////        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
//        String payStateStr = null;
//        //支付状态翻译
//        if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE)) && ObjectUtil.isNotEmpty(reqBo.getPayState())) {
//            payStateStr = dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE).get(reqBo.getPayState().toString());
//        }
//        syncEs(saleOrderMain.getSaleOrderId(), reqBo.getPayState(), payStateStr);
//        UocUpdateSaleOrderPayStateServiceRspBo rspBo = new UocUpdateSaleOrderPayStateServiceRspBo();
//        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
//        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
//        return rspBo;
//    }

    /**
     * @remark 字典翻译代码重构
     * @author 欧迅
     * @time 2025.1.17
     */
    //todo 待删
    @Override
    public UocUpdateSaleOrderPayStateServiceRspBo updatePayState(UocUpdateSaleOrderPayStateServiceReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == saleOrderMain) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "查询销售单为空！");
        }
        uocSaleOrderDo.setOrderId(saleOrderMain.getOrderId());
        uocSaleOrderDo.setPayState(reqBo.getPayState());
        iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        //获取字典集合
//        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        String payStateStr = null;
        //支付状态翻译
        /**
         * 字典翻译
         */
        payStateStr = DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocDicConstant.PAY_STATE.P_CODE,reqBo.getPayState().toString())==null?null:DictFrameworkUtils.getDictDataByCode("UOC_PRO",UocDicConstant.PAY_STATE.P_CODE,reqBo.getPayState().toString()).getValue();
        syncEs(saleOrderMain.getSaleOrderId(), reqBo.getPayState(), payStateStr);
        UocUpdateSaleOrderPayStateServiceRspBo rspBo = new UocUpdateSaleOrderPayStateServiceRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }

    private void verifyParam(UocUpdateSaleOrderPayStateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == (reqBo.getPayState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[payState]属性不能为空");
        }
        if (null == (reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[saleVoucherId]属性不能为空");
        }
    }

    /**
     * 同步ES
     */
    private void syncEs(Long objId, Integer payState, String payStateStr) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        //objId
        uocEsSyncManagerSaveDataReqBo.setObjId(objId);
        //indexName
        uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE, payState);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE_STR, payStateStr);
        //jsonObj
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("更新销售单支付状态uocEsSyncManagerSaveDataReqBo为{}", JSONObject.toJSONString(uocEsSyncManagerSaveDataReqBo));
        uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    /**
     * 初始化pCode集合
     */
    private static void initialize() {
        //支付状态字典
        pCodeList.add(UocDicConstant.PAY_STATE.P_CODE);
    }

}
