package com.tydic.dyc.oc.service.shiporder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.thread.UocThreadPool;
import com.tydic.dyc.oc.components.thread.runnable.UocSyncEsRunnable;
import com.tydic.dyc.oc.components.thread.runnable.bo.SyncEsRunnableBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistReqBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistRspBo;
import com.tydic.dyc.oc.transactionservice.UocSaleShipOrderTransaction;
import com.tydic.dyc.oc.transactionservice.UocShipOrderArrivaRegistTransaction;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-发货单到货登记 实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@Slf4j
@HTServiceImpl
public class UocShipOrderArrivaRegistServiceImpl implements UocShipOrderArrivaRegistService {

    @Autowired
    private UocShipOrderArrivaRegistTransaction uocShipOrderArrivaRegistTransaction;
    @Autowired
    private UocThreadPool uocThreadPool;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocShipOrderArrivaRegistRspBo dealShipOrderArrivaRegist(UocShipOrderArrivaRegistReqBo reqBo) {
        UocShipOrderArrivaRegistRspBo rspBo = uocShipOrderArrivaRegistTransaction.dealShipOrderArrivaRegist(reqBo);

        if (UocRspConstants.RSP_CODE_SUCCESS.equals(rspBo.getRespCode())) {
            //本地 线程同步es
            syncEs(reqBo, rspBo);
        }
        return rspBo;
    }

    private void syncEs(UocShipOrderArrivaRegistReqBo reqBo, UocShipOrderArrivaRegistRspBo rspBo) {
        List<SyncEsRunnableBo> list = new ArrayList<>();
        SyncEsRunnableBo saleBo = new SyncEsRunnableBo();
        saleBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleBo.setOrderId(reqBo.getOrderId());
        saleBo.setObjId(reqBo.getSaleOrderId());
        saleBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
        list.add(saleBo);

        for (Long shipOrderId : reqBo.getShipOrderIdList()) {
            SyncEsRunnableBo shipBo = new SyncEsRunnableBo();
            shipBo.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipBo.setOrderId(reqBo.getOrderId());
            shipBo.setObjId(shipOrderId);
            shipBo.setOpFlag(UocConstant.ES_SYNC_OP_FLAG.SAVE);
            list.add(shipBo);
        }

        log.debug("到货登记es同步：" + JSON.toJSONString(list));
        uocThreadPool.executeRunnable(new UocSyncEsRunnable(list));
    }
}
