package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocAfOrderItemPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocAfOrderItemMapper
 * 说明:售后服务明细
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocAfOrderItemMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocAfOrderItemPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocAfOrderItemPo uocAfOrderItemPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocAfOrderItemPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocAfOrderItemPo uocAfOrderItemPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocAfOrderItemPo set, @Param("where") UocAfOrderItemPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocAfOrderItemPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocAfOrderItemPo uocAfOrderItemPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocAfOrderItemPo 参数对象
	 * @return UocAfOrderItemPo 结果对象
	 */
	UocAfOrderItemPo getModelBy(UocAfOrderItemPo uocAfOrderItemPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocAfOrderItemPo 参数对象
	 * @return List<UocAfOrderItemPo> 结果对象
	 */
	List<UocAfOrderItemPo> getList(UocAfOrderItemPo uocAfOrderItemPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocAfOrderItemPo 参数对象
	 * @param page 分页参数
	 * @return List<UocAfOrderItemPo> 结果对象
	 */
	List<UocAfOrderItemPo> getListPage(UocAfOrderItemPo uocAfOrderItemPo, Page<UocAfOrderItemPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocAfOrderItemPo> list);

}
