package com.tydic.dyc.oc.repository.daobak;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocOrderTaskInstPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocOrderTaskInstMapper
 * 说明:订单任务实例
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocOrderTaskInstMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocOrderTaskInstPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocOrderTaskInstPo uocOrderTaskInstPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocOrderTaskInstPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocOrderTaskInstPo uocOrderTaskInstPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocOrderTaskInstPo set, @Param("where") UocOrderTaskInstPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocOrderTaskInstPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocOrderTaskInstPo uocOrderTaskInstPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocOrderTaskInstPo 参数对象
	 * @return UocOrderTaskInstPo 结果对象
	 */
	UocOrderTaskInstPo getModelBy(UocOrderTaskInstPo uocOrderTaskInstPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocOrderTaskInstPo 参数对象
	 * @return List<UocOrderTaskInstPo> 结果对象
	 */
	List<UocOrderTaskInstPo> getList(UocOrderTaskInstPo uocOrderTaskInstPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocOrderTaskInstPo 参数对象
	 * @param page 分页参数
	 * @return List<UocOrderTaskInstPo> 结果对象
	 */
	List<UocOrderTaskInstPo> getListPage(UocOrderTaskInstPo uocOrderTaskInstPo, Page<UocOrderTaskInstPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocOrderTaskInstPo> list);

	int deleteTaskInstByStepIdAndFinshTag(UocOrderTaskInstPo where);

	int deleteProcTaskInstByIds(UocOrderTaskInstPo where);

	int deleteTaskInstByTaskId(UocOrderTaskInstPo where);

}
