package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocChngOrderObjPo
 * 说明:变更单对象
 * 时间:2022-04-12 10:34
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocChngOrderObjPo implements Serializable {
	private static final long serialVersionUID = 5537139252444804156L;

	//变更单对象id")
	private Long chngOrderObjId;

	//变更单id")
	private Long chngOrderId;

	//订单id")
	private Long orderId;

	//销售单id")
	private Long saleOrderId;

	//发货单id")
	private Long shipOrderId;

	//验收单id")
	private Long inspOrderId;

	//变更类型 1:状态变更 2:采购价变更 3:销售价变更 4:加价率变更")
	private Integer chngType;

	//变更数量")
	private BigDecimal chngNum;

	//变更金额")
	private BigDecimal chngFee;

	//变更状态")
	private String chngState;

	//其他变更")
	private String otherChngValue;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//排序")
	private String orderBy;

	//变更单idList")
	private List<Long> chngOrderIdList;

	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;
}
