package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 标题:UocConfTabOrdStatePo
 * 说明:页面每个sheet页对应的实际订单状态映射规则配置
 * 时间:2022-05-12 22:04
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocConfTabOrdStatePo implements Serializable {
	private static final long serialVersionUID = -449029896110076696L;

	//id")
	private Long id;

	//tab标签id")
	private Integer tabId;

	//菜单编码")
	private String menuCode;

	//菜单编码")
	private String menuPathName;

	//tab标签名称")
	private String tabName;

	//排序")
	private Integer sort;

	//单据类型             1订单             2.销售单             3 发货单             4.收货单             5.售后服务单             6.支付单                          99.其他")
	private Integer objType;

	//字典编码")
	private String pCode;

	//环节编码")
	private String orderStatusCode;

	//环节说明")
	private String orderStatusName;

	//子环节订单环节编码，逗号分隔")
	private String subOrderStatusCode;

	//子环节订单环节说明")
	private String subOrderStatusName;

	//单据状态")
	private String orderStatus;

	//tab标签idList")
	private List<String> tabIdList;

	//已办任务环节编码")
	private String doneTacheCode;

	//订单来源  1 专区 2 电子超市  3 框架协议  4 一单一采 10 店铺下单  20 app下单")
	private String orderSource;

	//订单来源名称")
	private String orderSourceName;

	//订单系统")
	private String orderSystem;

	//订单系统名称")
	private String orderSystemName;

	//索引名")
	private String indexName;

	//参数JSON串")
	private String paramJson;

	//排序")
	private String orderBy;

}
