/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.repository.config.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.tydic.dyc.smc.dao.SmcBpmConfigMapper;
import com.tydic.dyc.smc.po.SmcBpmConfigPO;
import com.tydic.dyc.smc.repository.config.api.SmcBpmConfigRepository;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmcBpmConfigRepositoryImpl
implements SmcBpmConfigRepository {
    @Resource
    private SmcBpmConfigMapper smcBpmConfigMapper;

    @Override
    public List<SmcBpmConfigPO> getBpmConfigByCompanyIds(List<Long> companyIds) {
        return this.smcBpmConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery(SmcBpmConfigPO.class).in(SmcBpmConfigPO::getCompanyId, companyIds));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean configBpmByCompanyId(Long companyId, List<SmcBpmConfigPO> configPOS) {
        if (CollectionUtil.isEmpty(configPOS)) {
            return Boolean.FALSE;
        }
        this.smcBpmConfigMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(SmcBpmConfigPO::getCompanyId, (Object)companyId));
        if (CollectionUtil.isNotEmpty(configPOS)) {
            for (SmcBpmConfigPO smcBpmConfigPO : configPOS) {
                smcBpmConfigPO.setCreateTime(new Date());
                smcBpmConfigPO.setUpdateTime(new Date());
                smcBpmConfigPO.setDelFlag(0);
                this.smcBpmConfigMapper.insert(smcBpmConfigPO);
            }
        }
        return Boolean.TRUE;
    }
}

