/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.repository.config.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.smc.dao.SmcSystemConfigMapper;
import com.tydic.dyc.smc.dao.SmcSystemConfigValueMapper;
import com.tydic.dyc.smc.po.SmcSystemConfigPO;
import com.tydic.dyc.smc.po.SmcSystemConfigValuePO;
import com.tydic.dyc.smc.repository.config.api.SmcSystemConfigRepository;
import com.tydic.dyc.smc.repository.config.bo.SmcSystemConfigReqDO;
import com.tydic.dyc.smc.repository.config.bo.SmcSystemConfigValueDO;
import com.tydic.dyc.smc.repository.config.bo.SmcSystemConfigValueReqDO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmcSystemConfigRepositoryImpl
implements SmcSystemConfigRepository {
    @Resource
    private SmcSystemConfigMapper smcSystemConfigMapper;
    @Resource
    private SmcSystemConfigValueMapper smcSystemConfigValueMapper;

    @Override
    public List<SmcSystemConfigPO> queryConfig(SmcSystemConfigReqDO reqDO) {
        return this.smcSystemConfigMapper.selectList((Wrapper)Wrappers.lambdaQuery(SmcSystemConfigPO.class).eq(reqDO.getType() != null, SmcSystemConfigPO::getType, (Object)reqDO.getType()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean configValue(SmcSystemConfigValueReqDO reqBO) {
        if (reqBO.getConfigId() == null) {
            throw new ZTBusinessException("configId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.smcSystemConfigValueMapper.delete((Wrapper)Wrappers.lambdaQuery(SmcSystemConfigValuePO.class).eq(SmcSystemConfigValuePO::getConfigId, (Object)reqBO.getConfigId()));
        if (CollectionUtil.isNotEmpty(reqBO.getConfigValueList())) {
            for (SmcSystemConfigValueDO systemConfigValueDO : reqBO.getConfigValueList()) {
                SmcSystemConfigValuePO smcSystemConfigValuePO = new SmcSystemConfigValuePO();
                smcSystemConfigValuePO.setConfigId(reqBO.getConfigId());
                smcSystemConfigValuePO.setConfigValue(systemConfigValueDO.getConfigValue());
                smcSystemConfigValuePO.setCreateTime(new Date());
                smcSystemConfigValuePO.setUpdateTime(new Date());
                smcSystemConfigValuePO.setCreateUserId(reqBO.getCreateUserId());
                smcSystemConfigValuePO.setCreateUserName(reqBO.getCreateUserName());
                smcSystemConfigValuePO.setUpdateUserId(reqBO.getUpdateUserId());
                smcSystemConfigValuePO.setUpdateUserName(reqBO.getUpdateUserName());
                smcSystemConfigValuePO.setDelFlag(0);
                this.smcSystemConfigValueMapper.insert(smcSystemConfigValuePO);
            }
        }
        return true;
    }

    @Override
    public List<SmcSystemConfigValuePO> getConfigValue(Long configId) {
        if (configId == null) {
            throw new ZTBusinessException("configId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.smcSystemConfigValueMapper.selectList((Wrapper)Wrappers.lambdaQuery(SmcSystemConfigValuePO.class).eq(SmcSystemConfigValuePO::getConfigId, (Object)configId));
    }

    @Override
    public SmcSystemConfigPO getByConfigId(Long configId) {
        return (SmcSystemConfigPO)this.smcSystemConfigMapper.selectById(configId);
    }
}

