/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ReflectUtil;
import com.tydic.commodity.busibase.atom.api.UccOrderSplitAtomService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccOrderSplitAtomServiceImpl
implements UccOrderSplitAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccOrderSplitAtomServiceImpl.class);
    @Value(value="${split.enable:false}")
    private boolean splitEnable;

    @Override
    public <T> List<List<T>> splitListByFields(List<T> list, List<String> groupKeys, boolean enable) {
        if (this.splitEnable) {
            if (enable) {
                if (list.size() == 1) {
                    return Collections.singletonList(list);
                }
                if (CollectionUtils.isEmpty(groupKeys)) {
                    return Collections.singletonList(list);
                }
                return new ArrayList<List<T>>(list.stream().collect(Collectors.groupingBy(obj -> {
                    StringBuilder splitKey = new StringBuilder();
                    for (String groupKey : groupKeys) {
                        splitKey.append(Convert.toStr((Object)ReflectUtil.getFieldValue((Object)obj, (String)groupKey), (String)"-"));
                    }
                    return splitKey.toString();
                })).values());
            }
            return Collections.singletonList(list);
        }
        return Collections.singletonList(list);
    }
}

