/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccSkuBatchAddRecordBO;
import com.tydic.commodity.base.constant.CommodityStatusConstants;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuBatchAddRecordAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuBatchAddRecordAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuBatchAddRecordAtomRspBO;
import com.tydic.commodity.busibase.busi.bo.UccBatchRecordObjBo;
import com.tydic.commodity.busibase.busi.bo.UccBatchRecordObjRspBo;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.ComBatchDealTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ComBatchDealRecordPO;
import com.tydic.commodity.po.ComBatchDealTaskPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccSkuBatchAddRecordAtomServiceImpl
implements UccSkuBatchAddRecordAtomService {
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Autowired
    private ComBatchDealTaskMapper comBatchDealTaskMapper;
    @Value(value="${ucc.batch.record.submit.size:5000}")
    private int submitSize;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccSkuBatchAddRecordAtomRspBO addRecrod(UccSkuBatchAddRecordAtomReqBO reqBO) {
        this.validReqParam(reqBO);
        UccSkuBatchAddRecordAtomRspBO rspBO = new UccSkuBatchAddRecordAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<UccBatchRecordObjRspBo> uccBatchRecordObjRspBoList = new ArrayList<UccBatchRecordObjRspBo>();
        for (UccBatchRecordObjBo uccBatchRecordObjBo : reqBO.getUccBatchRecordObjBos()) {
            UccBatchRecordObjRspBo uccBatchRecordObjRspBo = new UccBatchRecordObjRspBo();
            this.addRecord(uccBatchRecordObjBo, uccBatchRecordObjRspBo);
            uccBatchRecordObjRspBoList.add(uccBatchRecordObjRspBo);
        }
        rspBO.setUccBatchRecordObjRspBoList(uccBatchRecordObjRspBoList);
        return rspBO;
    }

    private void addRecord(UccBatchRecordObjBo reqBO, UccBatchRecordObjRspBo rspBO) {
        String batchNo = String.valueOf(Sequence.getInstance().nextId());
        Date now = new Date();
        List<Long> objIdList = reqBO.getBatchObjList().stream().map(UccSkuBatchAddRecordBO::getObjId).collect(Collectors.toList());
        ComBatchDealRecordPO insertBatchDealRecordPO = new ComBatchDealRecordPO();
        insertBatchDealRecordPO.setDealType(reqBO.getDealType());
        insertBatchDealRecordPO.setBatchNo(batchNo);
        insertBatchDealRecordPO.setCreateTime(now);
        insertBatchDealRecordPO.setCreateUserId(reqBO.getUserId());
        insertBatchDealRecordPO.setCreateUserName(reqBO.getName());
        insertBatchDealRecordPO.setStatus(UccConstants.SkuBatchDealStatus.TO_CHECK);
        insertBatchDealRecordPO.setObjType(reqBO.getObjType());
        ArrayList<Integer> objStatusList = new ArrayList<Integer>();
        this.getCommodityTypeInfo(reqBO, objIdList);
        if (!UccConstants.BatchObjType.AUDIT_ORDER.equals(reqBO.getObjType())) {
            this.statusConvert(reqBO, insertBatchDealRecordPO, objStatusList);
            if (CollectionUtils.isEmpty(objStatusList)) {
                throw new BaseBusinessException("8888", "\u72b6\u6001\u8f6c\u6362\u4e3a\u7a7a");
            }
        }
        this.submitBatch(reqBO, objIdList, insertBatchDealRecordPO);
        int reqCount = reqBO.getBatchObjList().size();
        ComBatchDealRecordPO comBatchDealRecordPO = new ComBatchDealRecordPO();
        comBatchDealRecordPO.setBatchNo(batchNo);
        int batchCount = this.comBatchDealRrecordMapper.getCheckBy(comBatchDealRecordPO);
        Long batchTaskId = this.insertBatchDeal(reqBO, batchNo, now, reqCount, batchCount);
        rspBO.setBatchTaskId(batchTaskId);
        rspBO.setDealType(reqBO.getDealType());
        rspBO.setFailNum(reqCount - batchCount);
        rspBO.setSuccessNum(batchCount);
        rspBO.setTotalNum(reqCount);
        rspBO.setBatchNo(batchNo);
    }

    private void getCommodityTypeInfo(UccBatchRecordObjBo reqBO, List<Long> objIdList) {
        if (!CollectionUtils.isEmpty(objIdList)) {
            List<UccCommodityPo> uccCommodityPos;
            if (UccConstants.BatchObjType.SKU.equals(reqBO.getObjType())) {
                List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qeryBatchSkus(objIdList);
                if (!CollectionUtils.isEmpty(uccSkuPos)) {
                    reqBO.setCommodityTypeId(uccSkuPos.get(0).getCommodityTypeId());
                }
            } else if (UccConstants.BatchObjType.COMMODITY.equals(reqBO.getObjType()) && !CollectionUtils.isEmpty(uccCommodityPos = this.uccCommodityMapper.qeryBatchCommdity(objIdList))) {
                reqBO.setCommodityTypeId(uccCommodityPos.get(0).getCommodityTypeId());
            }
        }
    }

    private void statusConvert(UccBatchRecordObjBo reqBO, ComBatchDealRecordPO insertBatchDealRecordPO, List<Integer> objStatusList) {
        if (UccConstants.BatchObjType.SKU.equals(reqBO.getObjType())) {
            if (UccConstants.BatchDealType.SKU_DELETE.equals(reqBO.getDealType())) {
                if (UccConstants.Source.ECOM.equals(reqBO.getSource())) {
                    objStatusList.add(SkuStatusConstants.SKU_STATUS_INVALID);
                } else {
                    objStatusList.add(SkuStatusConstants.SKU_STATUS_DRAFT);
                    objStatusList.add(SkuStatusConstants.SKU_STATUS_INVALID);
                }
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_REJECT.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_WAIT_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_RE_TO_PUT_ON.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_REJECT);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_RESTORE_STRATEGY.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_REJECT_STRATEGY);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_STRATEGY_PASS.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_WAIT_STRATEGY);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_STRATEGY_REJECT.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_WAIT_STRATEGY);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_EDIT_SUBMIT_DRAFT.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_DRAFT);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_EDIT_SUBMIT_NOT_DRAFT_TO_PUT_ON.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_WAIT_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_EDIT_SUBMIT_NOT_DRAFT_ON_SHELF.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_ON_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_EDIT_SUBMIT_NOT_DRAFT_DOWN_SHELF.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_DOWN_SHELF);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_WAIT_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            this.sameLevelSkuStatusConvert(reqBO, insertBatchDealRecordPO, objStatusList);
        }
        if (UccConstants.BatchObjType.COMMODITY.equals(reqBO.getObjType())) {
            if (UccConstants.BatchDealType.COMM_EDIT_SUBMIT.equals(reqBO.getDealType())) {
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_DRAFT);
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_ON_SHELF);
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_DOWN_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT_TO_PUT_ON.equals(reqBO.getDealType())) {
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_WAIT_SHELF);
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_ON_SHELF);
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_DOWN_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.COMM_DELETE.equals(reqBO.getDealType())) {
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_DRAFT);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.COMM_PUT_ON.equals(reqBO.getDealType())) {
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_WAIT_SHELF);
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_DRAFT);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.COMM_PUT_ON_TIME.equals(reqBO.getDealType())) {
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_WAIT_SHELF);
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_DRAFT);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT_ON_SHELF.equals(reqBO.getDealType())) {
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_ON_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT_DOWN_SHELF.equals(reqBO.getDealType())) {
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_DOWN_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.IsSameLevelCommodity.YES.equals(reqBO.getSameLevel())) {
                this.sameLevelSkuStatusConvert(reqBO, insertBatchDealRecordPO, objStatusList);
            }
        }
    }

    private void sameLevelSkuStatusConvert(UccBatchRecordObjBo reqBO, ComBatchDealRecordPO insertBatchDealRecordPO, List<Integer> objStatusList) {
        if (UccConstants.BatchDealType.SKU_PUT_ON.equals(reqBO.getDealType())) {
            objStatusList.add(SkuStatusConstants.SKU_STATUS_WAIT_SHELF);
            insertBatchDealRecordPO.setObjStatusList(objStatusList);
        }
        if (UccConstants.BatchDealType.COMM_PUT_ON_TIME.equals(reqBO.getDealType())) {
            objStatusList.add(SkuStatusConstants.SKU_STATUS_WAIT_SHELF);
            insertBatchDealRecordPO.setObjStatusList(objStatusList);
        }
        if (UccConstants.BatchDealType.SKU_PUT_OFF.equals(reqBO.getDealType())) {
            objStatusList.add(SkuStatusConstants.SKU_STATUS_ON_SHELF);
            insertBatchDealRecordPO.setObjStatusList(objStatusList);
        }
        if (UccConstants.BatchDealType.SKU_RE_PUT_ON.equals(reqBO.getDealType())) {
            objStatusList.add(SkuStatusConstants.SKU_STATUS_DOWN_SHELF);
            insertBatchDealRecordPO.setObjStatusList(objStatusList);
        }
        if (UccConstants.BatchDealType.SKU_FROCE_PUT_OFF.equals(reqBO.getDealType())) {
            objStatusList.add(SkuStatusConstants.SKU_STATUS_ON_SHELF);
            insertBatchDealRecordPO.setObjStatusList(objStatusList);
        }
    }

    private Long insertBatchDeal(UccBatchRecordObjBo reqBO, String batchNo, Date now, int reqCount, int batchCount) {
        ComBatchDealTaskPO uccBatchDealTaskPO = new ComBatchDealTaskPO();
        uccBatchDealTaskPO.setBatchNo(batchNo);
        uccBatchDealTaskPO.setCreateTime(now);
        uccBatchDealTaskPO.setCreateUserId(reqBO.getUserId());
        uccBatchDealTaskPO.setCreateUserName(reqBO.getName());
        uccBatchDealTaskPO.setTotalNum(Long.valueOf(reqCount));
        uccBatchDealTaskPO.setBatchTaskId(Sequence.getInstance().nextId());
        JSONObject json = new JSONObject();
        json.put("sameLevel", (Object)reqBO.getSameLevel());
        json.put("userId", (Object)reqBO.getUserId());
        json.put("name", (Object)reqBO.getName());
        json.put("orgId", (Object)reqBO.getOrgId());
        json.put("orgName", (Object)reqBO.getOrgName());
        json.put("companyId", (Object)reqBO.getCompanyId());
        json.put("companyName", (Object)reqBO.getCompanyName());
        json.put("editBatchId", (Object)reqBO.getEditBatchId());
        json.put("commodityTypeId", (Object)reqBO.getCommodityTypeId());
        if (!StringUtils.isBlank((CharSequence)reqBO.getReqJson())) {
            JSONObject reqJsonObj = JSON.parseObject((String)reqBO.getReqJson());
            json.putAll((Map)reqJsonObj);
        }
        uccBatchDealTaskPO.setReqJson(json.toJSONString());
        uccBatchDealTaskPO.setTotalNum(Convert.toLong((Object)reqCount));
        uccBatchDealTaskPO.setFailNum(Convert.toLong((Object)(reqCount - batchCount)));
        uccBatchDealTaskPO.setSuccessNum(Convert.toLong((Object)batchCount));
        if (uccBatchDealTaskPO.getFailNum() > 0L) {
            uccBatchDealTaskPO.setFailReason("\u72b6\u6001\u4e0d\u5bf9");
        }
        uccBatchDealTaskPO.setDealType(reqBO.getDealType());
        uccBatchDealTaskPO.setSource(reqBO.getSource());
        this.comBatchDealTaskMapper.insert(uccBatchDealTaskPO);
        return uccBatchDealTaskPO.getBatchTaskId();
    }

    private void submitBatch(UccBatchRecordObjBo reqBO, List<Long> objIdList, ComBatchDealRecordPO insertBatchDealRecordPO) {
        int pageCount = objIdList.size() / this.submitSize;
        int modSzie = objIdList.size() % this.submitSize;
        if (objIdList.size() > this.submitSize) {
            insertBatchDealRecordPO.setObjIdList(objIdList.subList(0, this.submitSize));
            this.insertBatch(insertBatchDealRecordPO, reqBO);
            for (int i = 1; i < pageCount; ++i) {
                insertBatchDealRecordPO.setObjIdList(objIdList.subList(i * this.submitSize - 1, this.submitSize * (i + 1)));
                this.insertBatch(insertBatchDealRecordPO, reqBO);
            }
            if (modSzie > 0) {
                int ySize = this.submitSize * pageCount;
                insertBatchDealRecordPO.setObjIdList(objIdList.subList(ySize - 1, ySize + modSzie));
                this.insertBatch(insertBatchDealRecordPO, reqBO);
            }
        } else {
            insertBatchDealRecordPO.setObjIdList(objIdList);
            this.insertBatch(insertBatchDealRecordPO, reqBO);
        }
    }

    private void insertBatch(ComBatchDealRecordPO insertBatchDealRecordPO, UccBatchRecordObjBo reqBO) {
        if (UccConstants.BatchDealType.SKU_STRATEGY_REJECT.equals(reqBO.getDealType())) {
            this.dealStrategyReject(insertBatchDealRecordPO, reqBO);
        } else {
            if (UccConstants.BatchObjType.SKU.equals(reqBO.getObjType())) {
                List<UccSkuPo> skuPos;
                List<Long> commodityId;
                this.comBatchDealRrecordMapper.insertBatchSkuIgnore(insertBatchDealRecordPO);
                insertBatchDealRecordPO.setObjType(UccConstants.BatchObjType.SKU);
                if (UccConstants.BatchDealType.SKU_EDIT_SUBMIT_DRAFT.equals(insertBatchDealRecordPO.getDealType()) || UccConstants.BatchDealType.SKU_PUT_ON.equals(insertBatchDealRecordPO.getDealType()) || UccConstants.BatchDealType.SKU_RE_PUT_ON.equals(insertBatchDealRecordPO.getDealType())) {
                    this.comBatchDealRrecordMapper.updateOnShelveWayBy(insertBatchDealRecordPO);
                }
                if (UccConstants.BatchDealType.SKU_PUT_ON.equals(reqBO.getDealType()) && UccConstants.Source.ECOM.equals(reqBO.getSource()) && !CollectionUtils.isEmpty(commodityId = (skuPos = this.uccSkuMapper.qryCommodityIdBySkuId(insertBatchDealRecordPO.getObjIdList())).stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList()))) {
                    this.uccCommodityMapper.updateEcomSubmitOnShelveTime(commodityId);
                }
            }
            if (UccConstants.BatchObjType.COMMODITY.equals(reqBO.getObjType())) {
                if (UccConstants.IsSameLevelCommodity.YES.equals(reqBO.getSameLevel())) {
                    reqBO.setObjType(UccConstants.BatchObjType.SKU);
                    insertBatchDealRecordPO.setObjType(UccConstants.BatchObjType.SKU);
                    this.comBatchDealRrecordMapper.insertBatchSameCommodityIgnore(insertBatchDealRecordPO);
                } else {
                    this.comBatchDealRrecordMapper.insertBatchCommodityIgnore(insertBatchDealRecordPO);
                }
                if (UccConstants.BatchDealType.COMM_EDIT_SUBMIT.equals(insertBatchDealRecordPO.getDealType())) {
                    this.comBatchDealRrecordMapper.updateOnShelveWayBy(insertBatchDealRecordPO);
                }
            }
            if (UccConstants.BatchObjType.AUDIT_ORDER.equals(reqBO.getObjType())) {
                this.comBatchDealRrecordMapper.insertBatchAuditIgnore(insertBatchDealRecordPO);
                this.comBatchDealOrderMapper.updateOrderByRecord(insertBatchDealRecordPO.getBatchNo());
            }
            if (!StringUtils.isBlank((CharSequence)reqBO.getBatchObjList().get(0).getTaskId())) {
                insertBatchDealRecordPO.setBatchObjList(reqBO.getBatchObjList());
                this.comBatchDealRrecordMapper.updateRecordByBatch(insertBatchDealRecordPO);
            }
        }
    }

    private void dealStrategyReject(ComBatchDealRecordPO insertBatchDealRecordPO, UccBatchRecordObjBo reqBO) {
        List<ComBatchDealRecordPO> strategyRejectRecordPoList = reqBO.getBatchObjList().stream().map(uccSkuBatchAddRecordBO -> {
            ComBatchDealRecordPO strategyRejectRecordPo = new ComBatchDealRecordPO();
            strategyRejectRecordPo.setRemark(uccSkuBatchAddRecordBO.getObjJson());
            strategyRejectRecordPo.setObjId(uccSkuBatchAddRecordBO.getObjId());
            strategyRejectRecordPo.setObjType(UccConstants.BatchObjType.SKU);
            strategyRejectRecordPo.setBatchNo(insertBatchDealRecordPO.getBatchNo());
            strategyRejectRecordPo.setStatus(insertBatchDealRecordPO.getStatus());
            strategyRejectRecordPo.setCreateTime(insertBatchDealRecordPO.getCreateTime());
            strategyRejectRecordPo.setCreateUserId(insertBatchDealRecordPO.getCreateUserId());
            strategyRejectRecordPo.setCreateUserName(insertBatchDealRecordPO.getCreateUserName());
            strategyRejectRecordPo.setId(uccSkuBatchAddRecordBO.getObjId());
            strategyRejectRecordPo.setDealType(reqBO.getDealType());
            return strategyRejectRecordPo;
        }).collect(Collectors.toList());
        this.comBatchDealRrecordMapper.insertBatch(strategyRejectRecordPoList);
    }

    private void validReqParam(UccSkuBatchAddRecordAtomReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty(abilityReqBO.getUccBatchRecordObjBos())) {
            throw new BusinessException("8888", "\u5165\u53c2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccBatchRecordObjBo uccBatchRecordObjBo : abilityReqBO.getUccBatchRecordObjBos()) {
            if (CollectionUtils.isEmpty(uccBatchRecordObjBo.getBatchObjList())) {
                throw new BusinessException("8888", "\u5165\u53c2BatchObjList\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (UccSkuBatchAddRecordBO uccSkuBatchAddRecordBO : uccBatchRecordObjBo.getBatchObjList()) {
                if (null != uccSkuBatchAddRecordBO.getObjId()) continue;
                throw new BusinessException("8888", "\u5165\u53c2objId\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)uccBatchRecordObjBo.getDealType())) {
                throw new BusinessException("8888", "\u5165\u53c2dealType\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null != uccBatchRecordObjBo.getObjType()) continue;
            throw new BusinessException("8888", "\u5165\u53c2objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

