/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.UccQryFscRuleAbilitySerive;
import com.tydic.commodity.busibase.atom.bo.UccMerchantConfBatchQueryReqDataBO;
import com.tydic.commodity.busibase.atom.bo.UccQryFscRuleAbilityBo;
import com.tydic.commodity.busibase.atom.bo.UccQryFscRuleAbilityReqBO;
import com.tydic.commodity.busibase.atom.bo.UccQryFscRuleAbilityRspBO;
import com.tydic.commodity.busibase.busi.api.UccReplacementPriceBusiService;
import com.tydic.commodity.busibase.busi.bo.ReplacePriceInfoBO;
import com.tydic.commodity.busibase.busi.bo.UccReplacementPriceBusiReqBo;
import com.tydic.commodity.busibase.busi.bo.UccReplacementPriceBusiRspBo;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuVendorPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccReplacementPriceBusiServiceImpl
implements UccReplacementPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccReplacementPriceBusiServiceImpl.class);
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccQryFscRuleAbilitySerive uccQryFscRuleAbilitySerive;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public UccReplacementPriceBusiRspBo replacePrice(UccReplacementPriceBusiReqBo reqBO) {
        Map<Integer, List<ReplacePriceInfoBO>> groupBySource;
        UccReplacementPriceBusiRspBo rspBO = new UccReplacementPriceBusiRspBo();
        List<ReplacePriceInfoBO> replacePriceInfo = reqBO.getReplacePriceInfo();
        if (CollectionUtils.isEmpty(replacePriceInfo)) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        if (!"1".equals(reqBO.getIsprofess()) || StringUtils.isEmpty((Object)reqBO.getCompanyId())) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRows(reqBO.getReplacePriceInfo());
            return rspBO;
        }
        if (reqBO.getReplacePriceInfo().get(0).getVendorId() != null) {
            List<Long> skuIds = replacePriceInfo.stream().map(ReplacePriceInfoBO::getSkuId).collect(Collectors.toList());
            List<UccSkuVendorPO> cnncUccSkuVendorPOS = null;
            if (!CollectionUtils.isEmpty(skuIds)) {
                cnncUccSkuVendorPOS = this.uccVendorMapper.batchSelectBySkuIds(skuIds);
            }
        }
        if ((groupBySource = reqBO.getReplacePriceInfo().stream().collect(Collectors.groupingBy(ReplacePriceInfoBO::getSkuSource))).isEmpty()) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<UccMerchantConfBatchQueryReqDataBO> qryInfo = new ArrayList<UccMerchantConfBatchQueryReqDataBO>();
        UccMerchantConfBatchQueryReqDataBO fscMerchantConfBatchQueryReqDataBO = null;
        for (Map.Entry<Integer, List<ReplacePriceInfoBO>> entry : groupBySource.entrySet()) {
            if (ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT.equals(entry.getKey())) {
                for (ReplacePriceInfoBO bo : entry.getValue()) {
                    fscMerchantConfBatchQueryReqDataBO = new UccMerchantConfBatchQueryReqDataBO();
                    fscMerchantConfBatchQueryReqDataBO.setPurOrgId(reqBO.getCompanyId());
                    fscMerchantConfBatchQueryReqDataBO.setSupOrgId(bo.getVendorId());
                    fscMerchantConfBatchQueryReqDataBO.setCommodityTypeId(bo.getCommodityTypeId().toString());
                    qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
                }
            }
            if (!ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT.equals(entry.getKey())) continue;
            for (ReplacePriceInfoBO bo : entry.getValue()) {
                fscMerchantConfBatchQueryReqDataBO = new UccMerchantConfBatchQueryReqDataBO();
                fscMerchantConfBatchQueryReqDataBO.setPurOrgId(reqBO.getCompanyId());
                fscMerchantConfBatchQueryReqDataBO.setSupOrgId(bo.getVendorId());
                fscMerchantConfBatchQueryReqDataBO.setCommodityTypeId(bo.getCommodityTypeId().toString());
                UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(bo.getCommodityId());
                fscMerchantConfBatchQueryReqDataBO.setModelContractId(uccCommodityPo.getOtherSourceId());
                qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
            }
        }
        if (CollectionUtils.isEmpty(qryInfo)) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        UccQryFscRuleAbilityReqBO UccQryFscRuleAbilityReqBO2 = new UccQryFscRuleAbilityReqBO();
        UccQryFscRuleAbilityReqBO2.setQryInfo(qryInfo);
        UccQryFscRuleAbilityRspBO uccQryFscRuleAbilityRspBO = this.uccQryFscRuleAbilitySerive.qryRule(UccQryFscRuleAbilityReqBO2);
        if (!"0000".equals(uccQryFscRuleAbilityRspBO.getRespCode())) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc(uccQryFscRuleAbilityRspBO.getRespDesc());
            return rspBO;
        }
        if (CollectionUtils.isEmpty(uccQryFscRuleAbilityRspBO.getResult())) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Iterator<ReplacePriceInfoBO> iterator = reqBO.getReplacePriceInfo().iterator();
        block3: while (true) {
            if (!iterator.hasNext()) {
                this.replaceByPsDisount(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setRows(reqBO.getReplacePriceInfo());
                return rspBO;
            }
            ReplacePriceInfoBO eachprice = iterator.next();
            Iterator<UccQryFscRuleAbilityBo> iterator2 = uccQryFscRuleAbilityRspBO.getResult().iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block3;
                UccQryFscRuleAbilityBo fsc = iterator2.next();
                if (fsc.getVendorId().equals(eachprice.getVendorId()) && fsc.getCommodityTypeId().equals(eachprice.getCommodityTypeId()) && fsc.getBusiMode() != null && fsc.getBusiMode() == 2) {
                    eachprice.setSalePrice(eachprice.getAgreementPrice());
                    eachprice.setLadderPrice(null);
                    eachprice.setReplace(1);
                }
                if (ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION.equals(eachprice.getSkuSource())) {
                    if (!eachprice.getVendorId().equals(fsc.getVendorId()) || !eachprice.getAgreementId().equals(fsc.getContractId()) || fsc.getBusiMode() == null || fsc.getBusiMode() != 1) continue;
                    continue;
                }
                if (!eachprice.getVendorId().equals(fsc.getVendorId()) || !eachprice.getContractId().equals(fsc.getContractId()) || fsc.getBusiMode() == null || fsc.getBusiMode() != 1) continue;
                eachprice.setSalePrice(eachprice.getAgreementPrice());
                eachprice.setLadderPrice(null);
                eachprice.setReplace(1);
            }
            break;
        }
    }

    private void replaceByPsDisount(UccReplacementPriceBusiReqBo reqBO) {
        if (reqBO.getPsDiscountRate() != null && reqBO.getPsDiscountRate().compareTo(BigDecimal.ZERO) != 0) {
            for (ReplacePriceInfoBO replacePriceInfoBO : reqBO.getReplacePriceInfo()) {
                if (replacePriceInfoBO.getReplace() == 1) continue;
                replacePriceInfoBO.setLadderPrice(null);
                if (replacePriceInfoBO.getSalePrice().equals(replacePriceInfoBO.getAgreementPrice())) continue;
                Long difValue = replacePriceInfoBO.getSalePrice() - replacePriceInfoBO.getAgreementPrice();
                Long salePirce = new BigDecimal(difValue.toString()).multiply(reqBO.getPsDiscountRate().divide(BigDecimal.valueOf(100L), 4, 4)).longValue() + replacePriceInfoBO.getAgreementPrice();
                replacePriceInfoBO.setSalePrice(salePirce);
            }
        }
    }

    private void replaceEachByPsDisount(UccReplacementPriceBusiReqBo reqBO) {
        if (reqBO.getPsDiscountRate() != null && reqBO.getPsDiscountRate().compareTo(BigDecimal.ZERO) != 0) {
            for (ReplacePriceInfoBO replacePriceInfoBO : reqBO.getReplacePriceInfo()) {
                if (replacePriceInfoBO.getReplace() == 1) continue;
                replacePriceInfoBO.setLadderPrice(null);
                if (replacePriceInfoBO.getSalePrice().equals(replacePriceInfoBO.getAgreementPrice())) continue;
                Long difValue = replacePriceInfoBO.getSalePrice() - replacePriceInfoBO.getAgreementPrice();
                Long salePirce = new BigDecimal(difValue.toString()).multiply(reqBO.getPsDiscountRate().divide(BigDecimal.valueOf(100L), 4, 4)).longValue() + replacePriceInfoBO.getAgreementPrice();
                replacePriceInfoBO.setSalePrice(salePirce);
            }
        }
    }
}

