/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.busibase.busi.api.UccOrgAgrWhiteRestrictionBusiService;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBo;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBusiReqBo;
import com.tydic.commodity.busibase.busi.bo.UccOrgSkuWhiteRestrictionBusiRspBo;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.po.UccOrgSkuWhiteRestrictionPo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccOrgAgrWhiteRestrictionBusiServiceImpl
implements UccOrgAgrWhiteRestrictionBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccOrgAgrWhiteRestrictionBusiServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;

    @Override
    public UccOrgSkuWhiteRestrictionBusiRspBo dealWhite(UccOrgSkuWhiteRestrictionBusiReqBo reqBo) {
        UccOrgSkuWhiteRestrictionBusiRspBo rspBo = new UccOrgSkuWhiteRestrictionBusiRspBo();
        HashSet<String> orgPathQuery = new HashSet<String>();
        HashSet<Long> agrQuery = new HashSet<Long>();
        for (UccOrgSkuWhiteRestrictionBo each : reqBo.getWhites()) {
            orgPathQuery.add(each.getOrgTreePath());
            agrQuery.add(each.getAgreementId());
        }
        List<UccOrgSkuWhiteRestrictionPo> poList = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(new ArrayList<Long>(agrQuery), new ArrayList<String>(orgPathQuery), 1);
        if (!CollectionUtils.isEmpty(poList)) {
            boolean exist = false;
            ArrayList<UccOrgSkuWhiteRestrictionBo> canInsert = new ArrayList<UccOrgSkuWhiteRestrictionBo>();
            for (UccOrgSkuWhiteRestrictionBo org : reqBo.getWhites()) {
                exist = false;
                for (UccOrgSkuWhiteRestrictionPo each : poList) {
                    if (!each.getOrgTreePath().equals(org.getOrgTreePath()) || !org.getAgreementId().equals(each.getAgreementId())) continue;
                    exist = true;
                }
                if (exist) continue;
                canInsert.add(org);
            }
            if (CollectionUtils.isEmpty(canInsert)) {
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                return rspBo;
            }
            reqBo.setWhites(canInsert);
        }
        ArrayList<UccOrgSkuWhiteRestrictionPo> skuWhiteRestrictionPos = new ArrayList();
        skuWhiteRestrictionPos = JSONObject.parseArray((String)JSONObject.toJSONString(reqBo.getWhites()), UccOrgSkuWhiteRestrictionPo.class);
        try {
            this.uccOrgSkuWhiteRestrictionMapper.insertBatch(skuWhiteRestrictionPos);
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u5e94\u7528\u8303\u56f4\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u5546\u54c1\u5e94\u7528\u8303\u56f4\u63d2\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
        List<String> orgPath = reqBo.getWhites().stream().map(UccOrgSkuWhiteRestrictionBo::getOrgTreePath).collect(Collectors.toList());
        List<UccOrgSkuWhiteRestrictionPo> whiteRestrictionPos = this.uccOrgSkuWhiteRestrictionMapper.qryCommdInfoByPath(orgPath, 1);
        Map<String, List<UccOrgSkuWhiteRestrictionPo>> groupByOrgWhite = whiteRestrictionPos.stream().collect(Collectors.groupingBy(UccOrgSkuWhiteRestrictionPo::getOrgTreePath));
        for (Map.Entry<String, List<UccOrgSkuWhiteRestrictionPo>> entry : groupByOrgWhite.entrySet()) {
            HashSet<Long> agrIds = new HashSet<Long>();
            List<UccOrgSkuWhiteRestrictionPo> value = entry.getValue();
            for (UccOrgSkuWhiteRestrictionPo each : value) {
                if (each.getAgreementId() == null) continue;
                agrIds.add(each.getAgreementId());
            }
            ArrayList whiteAgr = new ArrayList(agrIds);
            try {
                if (CollectionUtils.isEmpty(value)) continue;
                this.cacheClient.set("UCC_ORG_AGR_WHITELIST_RESTRICTION" + value.get(0).getOrgId(), whiteAgr);
            }
            catch (Exception e) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u5546\u54c1\u53d1\u5e03\u7f13\u5b58\u673a\u6784\u767d\u540d\u5355\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                return rspBo;
            }
        }
        List<Long> agrList = this.uccOrgSkuWhiteRestrictionMapper.qryAgrList(1);
        try {
            this.cacheClient.set("UCC_ORG_AGR_EXCLUDE_RESTRICTION", agrList);
        }
        catch (Exception e) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5546\u54c1\u53d1\u5e03\u7f13\u5b58\u5546\u54c1\u767d\u540d\u5355\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

