/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchUtil.class);
    @Autowired
    private RestHighLevelClient client;
    private static RequestOptions options = RequestOptions.DEFAULT;
    private static ObjectMapper mapper;
    private static final int batchSize = 1000;
    private static final int NUMBER_OF_RETRY = 3;

    public boolean createIndex(String index) {
        CreateIndexRequest request = new CreateIndexRequest(index);
        try {
            CreateIndexResponse indexResponse = this.client.indices().create(request, options);
            if (indexResponse.isAcknowledged()) {
                LOGGER.info("\u521b\u5efa\u7d22\u5f15\u6210\u529f");
            } else {
                LOGGER.info("\u521b\u5efa\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (IOException e) {
            LOGGER.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public String addData(String index, String type, String id, JSONObject object) {
        try {
            String jsonString = JSON.toJSONString((Object)object);
            Request request = new Request("PUT", "/" + index + "/_doc/" + (id != null ? id : ""));
            request.setJsonEntity(jsonString);
            int maxRetries = 3;
            Response response = null;
            for (int retryCount = 0; retryCount < maxRetries; ++retryCount) {
                try {
                    response = this.getLowLevelClient().performRequest(request);
                    break;
                }
                catch (IOException e) {
                    if (e.getMessage().contains("Connection reset by peer")) {
                        LOGGER.error("\u51fa\u73b0Connection reset by peer\u5f02\u5e38\uff0c\u91cd\u8bd5\u7b2c{}\u6b21", (Object)(retryCount + 1));
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            LOGGER.error("\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38\uff1a", (Throwable)ie);
                            break;
                        }
                    }
                    LOGGER.error("\u8bf7\u6c42\u5931\u8d25\uff1a", (Throwable)e);
                    throw new Exception("\u8bf7\u6c42\u5931\u8d25", e);
                }
                catch (Exception e) {
                    LOGGER.error("\u8bf7\u6c42\u5931\u8d25\uff1a", (Throwable)e);
                    throw new Exception("\u8bf7\u6c42\u5931\u8d25", e);
                }
            }
            if (response == null) {
                throw new Exception("\u8bf7\u6c42\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570\u8fbe\u5230\u4e0a\u9650");
            }
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201) {
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                return id != null ? id : responseBody;
            }
            LOGGER.info("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + response.getStatusLine().getStatusCode());
        }
        catch (Exception e) {
            LOGGER.info("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public void addBatch(String index, String type, List<Map<String, JSONObject>> list) {
        if (list.isEmpty()) {
            return;
        }
        int pages = (int)Math.ceil((double)list.size() / 1000.0);
        for (int i = 0; i < pages; ++i) {
            List<Map<String, JSONObject>> subList = this.subList(list, 1000, i);
            this.dealBatch(index, type, subList);
            LOGGER.info("\u6279\u91cf\u5904\u7406\u7b2c--" + i + "\u6b21,\u5171\u8ba1:" + subList.size() + "--\u6761...");
        }
        LOGGER.info("\u63d2\u5165\u5b8c\u6bd5\uff0c\u5171\u8ba1:" + list.size() + "--\u6761...");
    }

    public List<Map<String, JSONObject>> subList(List<Map<String, JSONObject>> dataList, int pageSize, int currentPage) {
        ArrayList<Map<String, JSONObject>> currentPageList = new ArrayList<Map<String, JSONObject>>();
        if (dataList != null && dataList.size() > 0) {
            int currIdx = currentPage > 0 ? currentPage * pageSize : 0;
            for (int i = 0; i < pageSize && i < dataList.size() - currIdx; ++i) {
                Map<String, JSONObject> map = dataList.get(currIdx + i);
                currentPageList.add(map);
            }
        }
        return currentPageList;
    }

    private void dealBatch(String index, String type, List<Map<String, JSONObject>> list) {
        BulkRequest request = new BulkRequest();
        list.forEach(map -> {
            for (Map.Entry entry : map.entrySet()) {
                IndexRequest indexRequest = new IndexRequest();
                indexRequest.index(index);
                indexRequest.id((String)entry.getKey());
                try {
                    indexRequest.source(mapper.writeValueAsString(entry.getValue()), XContentType.JSON);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                request.add(indexRequest);
            }
        });
        try {
            BulkResponse responses = this.client.bulk(request, options);
            if (responses.hasFailures()) {
                LOGGER.info("\u6279\u91cf\u63d2\u5165\u6709\u5931\u8d25\u6570\u636e!");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u54c1\u4fe1\u606f\u540c\u6b65\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public Boolean deleteDataByCondition(String endPoint, JSONObject qryJson) {
        boolean deleteResult = false;
        NStringEntity entity = new NStringEntity(qryJson.toJSONString(), ContentType.APPLICATION_JSON);
        try {
            JSONObject deleteResultJson;
            int deleteCount;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotBlank((CharSequence)result) && (deleteCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("deleted").intValue()) > 0) {
                deleteResult = true;
            }
        }
        catch (IOException e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return deleteResult;
    }

    public Boolean updateData(String index, String type, String id, JSONObject qryJson) {
        boolean deleteResult = true;
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.index(index);
        indexRequest.id(id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)qryJson), XContentType.JSON);
            UpdateRequest updateRequest = new UpdateRequest();
            updateRequest.index(index);
            updateRequest.id(id);
            updateRequest.doc(indexRequest);
            UpdateResponse rspose = this.client.update(updateRequest, options);
            LOGGER.info(JSONObject.toJSONString((Object)rspose));
        }
        catch (Exception e) {
            if (e.getMessage().contains("Connection reset by peer")) {
                LOGGER.error("\u51fa\u73b0Connection reset by peer\u5f02\u5e38\uff0c\u91cd\u8bd51\u6b21");
                try {
                    Thread.sleep(1000L);
                    indexRequest.source(mapper.writeValueAsString((Object)qryJson), XContentType.JSON);
                    UpdateRequest updateRequest = new UpdateRequest();
                    updateRequest.index(index);
                    updateRequest.id(id);
                    updateRequest.doc(indexRequest);
                    UpdateResponse rspose = this.client.update(updateRequest, options);
                    LOGGER.info(JSONObject.toJSONString((Object)rspose));
                }
                catch (Exception ie) {
                    LOGGER.error("\u51fa\u73b0Connection reset by peer\u5f02\u5e38\u91cd\u8bd5\u4e4b\u540e\u4ecd\u7136\u5931\u8d25\uff1a" + ie.getMessage());
                    return false;
                }
            }
            LOGGER.error("es \u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    public Boolean updateBatchData(String index, Map<Long, Map<String, Object>> maps) {
        boolean deleteResult = false;
        try {
            BulkRequest request = new BulkRequest();
            maps.forEach((id, map) -> request.add(new UpdateRequest(index, id.toString()).doc(map).upsert(new Object[0])));
            BulkResponse response = this.client.bulk(request, RequestOptions.DEFAULT);
            LOGGER.info(JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("es \u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    public Boolean deleteData(String index, String id) {
        boolean deleteResult = false;
        IndexRequest indexRequest = new IndexRequest();
        indexRequest.index(index);
        indexRequest.id(id);
        try {
            DeleteRequest deleteRequest = new DeleteRequest();
            deleteRequest.index(index);
            deleteRequest.id(id);
            DeleteResponse rspose = this.client.delete(deleteRequest, options);
            LOGGER.info(JSONObject.toJSONString((Object)rspose));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("es \u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    public Boolean deleteBatchData(String index, List<String> ids) {
        boolean deleteResult = false;
        try {
            BulkRequest request = new BulkRequest();
            for (String id : ids) {
                request.add(((DeleteRequest)new DeleteRequest().index(index)).id(id));
            }
            BulkResponse response = this.client.bulk(request, RequestOptions.DEFAULT);
            LOGGER.info(JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("es \u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    public String updateByQuery(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/_update_by_query";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + qryJson);
        }
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    public String doPostSendQuery(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/_search";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + qryJson);
        }
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    public void bulkPutIndex(String index, String type, List<Map<String, Object>> list, String id) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int size = list.size();
        BulkRequest request = new BulkRequest();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = list.get(i);
            if (!StringUtils.isEmpty((CharSequence)id)) {
                request.add(new IndexRequest(index, type, String.valueOf(map.get(id))).source(map, XContentType.JSON));
                continue;
            }
            if (map.containsKey("id")) {
                request.add(new IndexRequest(index, type, String.valueOf(map.remove("id"))).source(map, XContentType.JSON));
                continue;
            }
            request.add(new IndexRequest(index, type, null).source(map, XContentType.JSON));
        }
        try {
            this.client.bulk(request, options);
        }
        catch (IOException e) {
            LOGGER.error("\u6279\u91cf\u63d2\u5165es \u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean checkIndexExist(String index) {
        try {
            Request request = new Request("HEAD", index);
            Response response = this.client.getLowLevelClient().performRequest(request);
            boolean exist = response.getStatusLine().getReasonPhrase().equals("OK");
            return exist;
        }
        catch (IOException e) {
            LOGGER.error("\u68c0\u67e5\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public RestClient getLowLevelClient() {
        return this.client.getLowLevelClient();
    }

    public String getIndexAnalyze(String index, String qryJson) {
        String endPoint = "/" + index + "/_analyze";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + qryJson);
        }
        NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.client.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    static {
        RequestOptions.Builder requestOptions = RequestOptions.DEFAULT.toBuilder();
        requestOptions.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(524288000));
        options = requestOptions.build();
        mapper = new ObjectMapper();
    }
}

