/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccApproveTaskSyncBusiService;
import com.tydic.commodity.busibase.busi.api.UccSendMessageAndNoteAtomService;
import com.tydic.commodity.busibase.busi.bo.ApproveTaskSyncBO;
import com.tydic.commodity.busibase.busi.bo.UccApproveTaskSyncBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccApproveTaskSyncBusiRspBO;
import com.tydic.commodity.busibase.busi.bo.UccSendTodoBusiReqBO;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccApproveTaskSyncBusiServiceImpl
implements UccApproveTaskSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccApproveTaskSyncBusiServiceImpl.class);
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Autowired
    private UccSendMessageAndNoteAtomService uccSendMessageAndNoteAtomService;

    @Override
    public UccApproveTaskSyncBusiRspBO ApproveTaskSync(UccApproveTaskSyncBusiReqBO reqBO) {
        List<UccSkuPo> uccSkuPoList;
        UccApproveTaskSyncBusiRspBO rspBO = new UccApproveTaskSyncBusiRspBO();
        UccSendTodoBusiReqBO uccSendTodoBusiReqBO = new UccSendTodoBusiReqBO();
        log.info("\u5ba1\u6279\u4efb\u52a1mq\u540c\u6b65API\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        if (!Objects.isNull(reqBO.getTag()) && reqBO.getTag().startsWith("MMC_TAG")) {
            return rspBO;
        }
        ArrayList<Long> spuIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(reqBO.getTaskList())) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e2) {
                throw new BusinessException("8888", "\u7ebf\u7a0b\u4f11\u7720\u62a5\u9519\uff1a" + e2.getMessage());
            }
            ArrayList<Long> thisTimeTaskIds = new ArrayList<Long>();
            for (ApproveTaskSyncBO each : reqBO.getTaskList()) {
                if (!ObjectUtils.isEmpty((Object)reqBO.getProcInstId())) {
                    each.setApproveInstId(reqBO.getProcInstId());
                }
                each.setBusinessId(each.getBusiness().getBusinessId());
                each.setBusinessType(each.getBusiness().getBusinessType());
                each.setTacheCode(each.getStepId());
                each.setTacheName(each.getStepName());
                EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
                eacRuTaskPO.setStatusList(Arrays.asList("ACTIVE", "SUSPEND"));
                eacRuTaskPO.setBusinessId(each.getBusinessId());
                if (each.getBusinessType().equals(ApprovalTypeEnum.uccOnShelfProcessOrder.code())) {
                    eacRuTaskPO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep()));
                    each.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep()));
                } else if (each.getBusinessType().equals(ApprovalTypeEnum.uccOffShelfProcessOrder.code())) {
                    eacRuTaskPO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep()));
                    each.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep()));
                } else if (each.getBusinessType().equals(ApprovalTypeEnum.uccReinstateProcessOrder.code())) {
                    eacRuTaskPO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccReinstateProcessOrder.getStep()));
                    each.setObjType(Integer.parseInt(ApprovalTypeEnum.uccReinstateProcessOrder.getStep()));
                } else if (each.getBusinessType().equals(ApprovalTypeEnum.uccEditProcessOrder.code())) {
                    eacRuTaskPO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccEditProcessOrder.getStep()));
                    each.setObjType(Integer.parseInt(ApprovalTypeEnum.uccEditProcessOrder.getStep()));
                }
                List<EacRuTaskPO> list = this.eacRuTaskMapper.getList(eacRuTaskPO);
                if (!CollectionUtils.isEmpty(list)) {
                    list.removeIf(e -> thisTimeTaskIds.contains(e.getTaskId()));
                }
                if (!CollectionUtils.isEmpty(list)) {
                    log.info("\u53bb\u9664\u8fd9\u6b21\u7684\u4efb\u52a1id\u4e4b\u540e\u7684list\uff1a{}", (Object)JSON.toJSONString(list));
                    Map<String, List<EacRuTaskPO>> collect = list.stream().collect(Collectors.groupingBy(EacRuTaskPO::getTacheCode));
                    if (collect.keySet().size() > 1) {
                        throw new BusinessException("8888", "businessId\u4e3a" + each.getBusinessId() + "\uff0cobjType\u4e3a" + each.getBusinessType() + "\u7684\u5ba1\u6279\u4efb\u52a1\u5728\u4e0d\u540c\u73af\u8282\u4e2d\u6709\u6fc0\u6d3b\u72b6\u6001");
                    }
                    if (list.get(0).getTacheCode().equals(each.getStepId())) {
                        log.info("\u5ba1\u6279\u73af\u8282\u4e00\u81f4");
                        EacRuTaskPO set = new EacRuTaskPO();
                        set.setStatus("COMPLETE");
                        set.setUpdateTime(new Date(System.currentTimeMillis()));
                        EacRuTaskPO eacRuTaskPO1 = new EacRuTaskPO();
                        eacRuTaskPO1.setColumn3(each.getApproveTaskId().toString());
                        this.eacRuTaskMapper.updateBy(set, eacRuTaskPO1);
                        EacRuTaskPO temp = new EacRuTaskPO();
                        BeanUtils.copyProperties((Object)each, (Object)temp);
                        EacRuTaskPO where = new EacRuTaskPO();
                        where.setTaskId(each.getApproveTaskId());
                        int n = this.eacRuTaskMapper.updateBy(temp, where);
                    } else {
                        log.info("\u5ba1\u6279\u73af\u8282\u4e0d\u4e00\u81f4");
                        EacRuTaskPO where = new EacRuTaskPO();
                        where.setBusinessId(each.getBusinessId());
                        where.setObjType(Integer.parseInt(ApprovalTypeEnum.find((String)each.getBusinessType()).getStep()));
                        EacRuTaskPO set = new EacRuTaskPO();
                        set.setStatus("COMPLETE");
                        set.setUpdateTime(new Date(System.currentTimeMillis()));
                        this.eacRuTaskMapper.updateBy(set, where);
                        EacRuTaskPO eacRuTaskPO1 = new EacRuTaskPO();
                        eacRuTaskPO1.setTaskId(each.getApproveTaskId());
                        EacRuTaskPO modelBy = this.eacRuTaskMapper.getModelBy(eacRuTaskPO1);
                        if (modelBy == null) {
                            EacRuTaskPO temp = new EacRuTaskPO();
                            BeanUtils.copyProperties((Object)each, (Object)temp);
                            temp.setTaskId(each.getApproveTaskId());
                            this.eacRuTaskMapper.insert(temp);
                        } else {
                            EacRuTaskPO where1 = new EacRuTaskPO();
                            where1.setTaskId(each.getApproveTaskId());
                            EacRuTaskPO temp = new EacRuTaskPO();
                            BeanUtils.copyProperties((Object)each, (Object)temp);
                            this.eacRuTaskMapper.updateBy(temp, where1);
                        }
                    }
                } else {
                    log.info("\u8bf4\u660e\u662f\u65b0\u521b\u5efa\u7684\u5ba1\u6279\uff0c\u76f4\u63a5\u5165\u5e93");
                    EacRuTaskPO temp = new EacRuTaskPO();
                    BeanUtils.copyProperties((Object)each, (Object)temp);
                    temp.setTaskId(each.getApproveTaskId());
                    this.eacRuTaskMapper.insert(temp);
                }
                if (each.getBusinessType().equals(ApprovalTypeEnum.uccEditProcessOrder.getCode())) {
                    this.uccSkuMapper.batchUpdateStep(Arrays.asList(Long.parseLong(each.getBusinessId())), each.getTacheCode(), null);
                    this.uccCommodityMapper.batchUpdateStep(Arrays.asList(Long.parseLong(each.getBusinessId())), each.getTacheCode(), null);
                    spuIds.add(Long.parseLong(each.getBusinessId()));
                } else {
                    this.uccSkuMapper.batchUpdateStepBySkuId(Arrays.asList(Long.parseLong(each.getBusinessId())), each.getTacheCode(), null);
                    uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(Long.parseLong(each.getBusinessId())), null);
                    if (ObjectUtil.isNotEmpty(uccSkuPoList)) {
                        spuIds.add(uccSkuPoList.get(0).getCommodityId());
                    }
                }
                thisTimeTaskIds.add(each.getApproveTaskId());
            }
        }
        if (reqBO.getIsfinish().booleanValue()) {
            log.info(reqBO.getProcInstId() + "\u6d41\u7a0b\u7ed3\u675f");
            EacRuTaskPO temp = new EacRuTaskPO();
            temp.setApproveInstId(reqBO.getProcInstId());
            List<EacRuTaskPO> list = this.eacRuTaskMapper.getList(temp);
            if (!CollectionUtils.isEmpty(list)) {
                EacRuTaskPO set = new EacRuTaskPO();
                set.setStatus("COMPLETE");
                set.setUpdateTime(new Date(System.currentTimeMillis()));
                this.eacRuTaskMapper.updateBy(set, temp);
                for (EacRuTaskPO each : list) {
                    if (each.getObjType() == 2) {
                        spuIds.add(Long.parseLong(each.getBusinessId()));
                        continue;
                    }
                    uccSkuPoList = this.uccSkuMapper.batchQrySku(Arrays.asList(Long.parseLong(each.getBusinessId())), null);
                    if (!ObjectUtil.isNotEmpty(uccSkuPoList)) continue;
                    spuIds.add(uccSkuPoList.get(0).getCommodityId());
                }
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getTaskList())) {
            try {
                this.dealToDo(reqBO);
                List<Long> taskIds = reqBO.getTaskList().stream().map(ApproveTaskSyncBO::getApproveTaskId).collect(Collectors.toList());
                uccSendTodoBusiReqBO.setTaskIds(taskIds);
                if (ApprovalTypeEnum.uccEditProcessOrder.code().equals(reqBO.getTaskList().get(0).getBusinessType())) {
                    UccCommodityPo commodityById = this.uccCommodityMapper.getCommodityById(Long.parseLong(reqBO.getTaskList().get(0).getBusinessId()));
                    uccSendTodoBusiReqBO.setSource(commodityById.getCommoditySource());
                } else {
                    List<UccSkuPo> uccSkuPoList2 = this.uccSkuMapper.batchQrySku(Arrays.asList(Long.parseLong(reqBO.getTaskList().get(0).getBusinessId())), null);
                    if (ObjectUtil.isNotEmpty(uccSkuPoList2)) {
                        uccSendTodoBusiReqBO.setSource(uccSkuPoList2.get(0).getSkuSource());
                    }
                }
                if (reqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccOnShelfProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOnShelfProcessOrder.getStep()));
                } else if (reqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccOffShelfProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccOffShelfProcessOrder.getStep()));
                } else if (reqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccReinstateProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccReinstateProcessOrder.getStep()));
                } else if (reqBO.getTaskList().get(0).getBusinessType().equals(ApprovalTypeEnum.uccEditProcessOrder.code())) {
                    uccSendTodoBusiReqBO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccEditProcessOrder.getStep()));
                }
            }
            catch (Exception e3) {
                log.error("\u5ba1\u6279mq\u6d88\u8d39\u8005 \u53d1\u9001\u5f85\u529emq\u5931\u8d25\uff1a" + e3.getMessage());
            }
        }
        rspBO.setSpuIds(spuIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealToDo(UccApproveTaskSyncBusiReqBO reqBO) {
        ArrayList eacRuTaskPOS = new ArrayList();
        reqBO.getTaskList().forEach(approveTaskSyncBO -> {
            EacRuTaskPO po = (EacRuTaskPO)JSON.parseObject((String)JSON.toJSONString((Object)approveTaskSyncBO), EacRuTaskPO.class);
            po.setTaskId(approveTaskSyncBO.getApproveTaskId());
            po.setBusinessId(approveTaskSyncBO.getBusiness().getBusinessId());
            po.setTacheCode(approveTaskSyncBO.getStepId());
            po.setTacheName(approveTaskSyncBO.getStepName());
            po.setIsJoinTransfer(2);
            if (!StringUtils.isEmpty((Object)approveTaskSyncBO.getJoinSignType())) {
                po.setIsJoinTransfer(1);
            }
            eacRuTaskPOS.add(po);
            this.sendTodo(po);
            this.sendMessage(po);
        });
    }

    private void sendTodo(EacRuTaskPO exitTaskInfo) {
    }

    private void sendMessage(EacRuTaskPO exitTaskInfo) {
    }
}

