/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UccEstoreLadderPriceBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.enumType.AssignCodeEnum;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.base.enumType.PricessingStepsEnum;
import com.tydic.commodity.base.enumType.ProcessingStepsEnum;
import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.enumType.YesNoEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.comb.api.UccSkuManagementListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccCombEsCommodityBo;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccAssignCodeMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuStandardRelationMapper;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSkuManagementListQryCombServiceImpl
implements UccSkuManagementListQryCombService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuManagementListQryCombServiceImpl.class);
    private static final long serialVersionUID = 1956659951572577168L;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccAssignCodeMapper uccAssignCodeMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    private Long userId;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStandardRelationMapper uccSkuStandardRelationMapper;

    @Override
    public UccSkuManagementListQryCombRspBO getSkuManagementListQry(UccSkuManagementListQryCombReqBO reqBO) {
        String result;
        String queryString;
        BoolQueryBuilder extBoolQueryBuilder;
        this.userId = reqBO.getUserId();
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        if (!StringUtils.isEmpty((Object)reqBO.getStdSkuId())) {
            reqBO.setSkuType(0);
            extBoolQueryBuilder = this.buildEsSql(reqBO);
            queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
            result = this.searchInfo(queryString);
            ArrayList<UccSkuManagementListCombQryBO> uccSkuManagementListCombQryBOS = new ArrayList<UccSkuManagementListCombQryBO>();
            if (!StringUtils.isEmpty((Object)result)) {
                JSONObject resultObj = JSONObject.parseObject((String)result);
                JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
                JSONArray listObject = hitsObj.getJSONArray("hits");
                if (!listObject.isEmpty() && listObject.size() > 0) {
                    Map<String, String> commodityStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS.toString());
                    Map<String, String> skuStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString());
                    Map<String, String> approveStateMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.SKU_APPROVAL_STATUS.toString());
                    Map<String, String> skuSourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_SOURCE.toString());
                    for (int i = 0; i < listObject.size(); ++i) {
                        UccSkuManagementListCombQryBO uccSkuManagementListCombQryBO;
                        JSONObject hitObj = listObject.getJSONObject(i);
                        JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                        UccCombEsCommodityBo commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                        if (StringUtils.isEmpty((Object)commodity) || ModelRuleConstant.PENDING_HANDLE_Status.equals((uccSkuManagementListCombQryBO = this.copyBean(commodity, reqBO, commodityStatusMap, skuStatusMap, approveStateMap, skuSourceMap)).getProcessingSteps())) continue;
                        uccSkuManagementListCombQryBOS.add(uccSkuManagementListCombQryBO);
                    }
                }
                rspBo.setRows(uccSkuManagementListCombQryBOS);
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                return rspBo;
            }
        }
        if (StringUtils.isEmpty((Object)(result = this.searchInfo(queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder = this.buildEsSql(reqBO)))))) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            List<UccSkuPricePo> pricePos;
            List<UccLadderPricePO> ladderPricePOS;
            Map<Integer, List<UccSkuPricePo>> groupBySwitch;
            List<Long> skus = rspBo.getRows().stream().map(UccSkuManagementListCombQryBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPricePo> bathPrice = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, null);
            if (!CollectionUtils.isEmpty((Collection)rspBo.getRows()) && (groupBySwitch = bathPrice.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSwitchOn))).containsKey(1) && !CollectionUtils.isEmpty(ladderPricePOS = this.uccLadderPriceMapper.selectListBySku(skus = (pricePos = groupBySwitch.get(1)).stream().map(UccSkuPricePo::getSkuId).collect(Collectors.toList())))) {
                Map<Long, List<UccLadderPricePO>> ladderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                Iterator<Long> iterator = ladderMap.keySet().iterator();
                HashMap<Long, List> longListMap = new HashMap<Long, List>();
                while (iterator.hasNext()) {
                    Long key = iterator.next();
                    List<UccLadderPricePO> mapPos = ladderMap.get(key);
                    List eachBo = JSONObject.parseArray((String)JSONObject.toJSONString(mapPos), UccEstoreLadderPriceBO.class);
                    eachBo.sort(new Comparator<UccEstoreLadderPriceBO>(){

                        @Override
                        public int compare(UccEstoreLadderPriceBO o1, UccEstoreLadderPriceBO o2) {
                            return o2.getStart().compareTo(o1.getStart());
                        }
                    });
                    for (UccEstoreLadderPriceBO each : eachBo) {
                        if (each.getStart() != null) {
                            each.setStart(MoneyUtils.haoToYuan(each.getStart()));
                        }
                        if (each.getStop() != null) {
                            each.setStop(MoneyUtils.haoToYuan(each.getStop()));
                        }
                        if (each.getPrice() == null) continue;
                        each.setPrice(MoneyUtils.haoToYuan(each.getPrice()));
                    }
                    longListMap.put(key, eachBo);
                }
                if (!longListMap.isEmpty()) {
                    for (UccSkuManagementListCombQryBO each : rspBo.getRows()) {
                        if (!longListMap.containsKey(each.getSkuId())) continue;
                        each.setLadderPriceInfo((List)longListMap.get(each.getSkuId()));
                    }
                }
            }
        }
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSkuManagementListQryCombReqBO reqBo) {
        RangeQueryBuilder createTimeQb;
        WildcardQueryBuilder wildcardQuery;
        List<Integer> allApprovedStatus;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isEmpty((Object)reqBo.getSkuType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_type", (int)0));
        } else {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_type", (Object)reqBo.getSkuType()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOoocClean())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"oooc_clean", (Object)reqBo.getOoocClean()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPricePassFlag())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"price_pass_flag", (Object)reqBo.getPricePassFlag()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getProcessingSteps())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"processing_steps", (Object)reqBo.getProcessingSteps()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getExportSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getExportSkuIds()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(reqBo.getApprovalStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_approval_status", reqBo.getApprovalStatus()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (reqBo.getCommodityTypeId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getApprovalStatus()) && (allApprovedStatus = Arrays.asList(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_PASS, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_REJECT, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_SHELF_OVER, ModelRuleConstant.SKU_STATUS_WAIT_SHELF_ING, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_PASS, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_REJECT, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_OVER, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_REJECT, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_OVER, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_REJECT)).containsAll(reqBo.getApprovalStatus()) && null != reqBo.getUserId() && null != reqBo.getObjType()) {
            ArrayList<String> approvedQry = new ArrayList<String>();
            String approvedQryStrPass = reqBo.getUserId() + "_" + reqBo.getObjType() + "_0";
            String approvedQryStrRefuse = reqBo.getUserId() + "_" + reqBo.getObjType() + "_1";
            if (StringUtils.isEmpty((Object)reqBo.getAuditResult())) {
                approvedQry.add(approvedQryStrPass);
                approvedQry.add(approvedQryStrRefuse);
            } else if ("0".equals(reqBo.getAuditResult())) {
                approvedQry.add(approvedQryStrPass);
            } else if ("1".equals(reqBo.getAuditResult())) {
                approvedQry.add(approvedQryStrRefuse);
            }
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"approvedInfoStr", approvedQry));
            reqBo.setOperIds(null);
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperOrgIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operOrgIds", reqBo.getOperOrgIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperRoleIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operRoleIds", reqBo.getOperRoleIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperStationCodes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operStationCodes", reqBo.getOperStationCodes()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", reqBo.getSkuStatus()));
        }
        ArrayList proNotExtOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getProNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getPurNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getSupNotExtendOrgIds());
        }
        ArrayList extOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getProExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getPurExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getSupExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty(proNotExtOrgIdList) || !CollectionUtils.isEmpty(extOrgIdList)) {
            BoolQueryBuilder orgQueryBuilder = QueryBuilders.boolQuery();
            if (!CollectionUtils.isEmpty(proNotExtOrgIdList)) {
                List collect = proNotExtOrgIdList.stream().distinct().collect(Collectors.toList());
                orgQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_org_id", collect));
            }
            if (!CollectionUtils.isEmpty(extOrgIdList)) {
                List extOrgIds = extOrgIdList.stream().distinct().collect(Collectors.toList());
                for (Long extOrgId : extOrgIds) {
                    orgQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"supplier_org_path.keyword", (String)("*" + extOrgId + "*")));
                }
            }
            boolQueryBuilder.must((QueryBuilder)orgQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (reqBo.getStdSkuStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"std_sku_status", (Object)reqBo.getStdSkuStatus()));
        }
        if (reqBo.getCreateType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_type", (Object)reqBo.getCreateType()));
        }
        if (reqBo.getStdSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"std_sku_id", (Object)reqBo.getStdSkuId()));
        }
        if (reqBo.getBindStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"bind_status", (Object)reqBo.getBindStatus()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"ext_spu_id.keyword", (String)("*" + reqBo.getExtSpuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getApplyNo())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"apply_no.keyword", (String)("*" + reqBo.getApplyNo() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStdSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"std_sku_code.keyword", (String)("*" + reqBo.getStdSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"ext_sku_id.keyword", (String)("*" + reqBo.getExtSkuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)("*" + reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            if (reqBo.getIsMaterCode() != null) {
                if (reqBo.getIsMaterCode() == 1) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_code.keyword", (String[])new String[]{reqBo.getMaterialCode()}));
                } else {
                    wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
                    boolQueryBuilder.must((QueryBuilder)wildcardQuery);
                }
            } else {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)("*" + reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)("*" + reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountStar())) {
            RangeQueryBuilder discountQbStar = QueryBuilders.rangeQuery((String)"discount").gte((Object)reqBo.getDiscountStar());
            boolQueryBuilder.must((QueryBuilder)discountQbStar);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountEnd())) {
            RangeQueryBuilder discountQbEnd = QueryBuilders.rangeQuery((String)"discount").lte((Object)reqBo.getDiscountEnd());
            boolQueryBuilder.must((QueryBuilder)discountQbEnd);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeStar())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").gte((Object)reqBo.getCreateTimeStar().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeEnd())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").lte((Object)reqBo.getCreateTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceStar()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceEnd()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        RangeQueryBuilder saleQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceStar())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceStar()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceEnd())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceEnd()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        log.debug("\u67e5\u8be2\u6761\u4ef6" + boolQueryBuilder.toString());
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSkuManagementListQryCombReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSortName()) && "asc".equals(reqBo.getSortOrder())) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "create_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (reqBo.getOrderByColumn() == 4) {
                sortField = "discounts";
            } else if (reqBo.getOrderByColumn() == 5) {
                sortField = "comment_number";
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSortName())) {
            if (reqBo.getSortName().equals("skuCode")) {
                sortField = "sku_code.keyword";
            } else if (reqBo.getSortName().equals("extSkuId")) {
                sortField = "ext_sku_id.keyword";
            } else if (reqBo.getSortName().equals("skuName")) {
                sortField = "sku_name.keyword";
            } else if (reqBo.getSortName().equals("commodityCode")) {
                sortField = "commodity_code.keyword";
            } else if (reqBo.getSortName().equals("extSpuId")) {
                sortField = "ext_spu_id.keyword";
            }
        }
        if (!StringUtils.isEmpty((Object)sortField)) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        return queryJson.toString();
    }

    private UccSkuManagementListQryCombRspBO dealSearchData(String result, UccSkuManagementListQryCombReqBO reqBo) {
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize(), reqBo);
        return rspBo;
    }

    private UccSkuManagementListQryCombRspBO copyData(List<UccCombEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize, UccSkuManagementListQryCombReqBO reqBo) {
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        ArrayList<UccSkuManagementListCombQryBO> uccSkuManagementListQryBOs = new ArrayList<UccSkuManagementListCombQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total);
            Object dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                Map<String, String> commodityStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS.toString());
                Map<String, String> skuStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString());
                Map<String, String> approveStateMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.SKU_APPROVAL_STATUS.toString());
                Map<String, String> skuSourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_SOURCE.toString());
                for (UccCombEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    UccSkuManagementListCombQryBO uccSkuManagementListQryBO = this.copyBean(cnncEsCommodityBo, reqBo, commodityStatusMap, skuStatusMap, approveStateMap, skuSourceMap);
                    if (ObjectUtil.isNotEmpty((Object)uccSkuManagementListQryBO.getProcessingSteps()) && ObjectUtil.isNotEmpty((Object)uccSkuManagementListQryBO.getSkuStatus()) && uccSkuManagementListQryBO.getProcessingSteps() == 4 && uccSkuManagementListQryBO.getSkuStatus() == 16) {
                        uccSkuManagementListQryBO.setSkuStatus(1);
                        uccSkuManagementListQryBO.setSkuStatusDesc("\u5f85\u5173\u8054");
                    }
                    uccSkuManagementListQryBOs.add(uccSkuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccSkuManagementListCombQryBO copyBean(UccCombEsCommodityBo cnncEsCommodityBo, UccSkuManagementListQryCombReqBO reqBO, Map<String, String> commodityStatusMap, Map<String, String> skuStatusMap, Map<String, String> approveStateMap, Map<String, String> skuSourceMap) {
        Serializable eacRuTaskPO;
        UccSkuManagementListCombQryBO uccSkuManagementListQryBO = new UccSkuManagementListCombQryBO();
        uccSkuManagementListQryBO.setRelStatus(cnncEsCommodityBo.getRel_status());
        uccSkuManagementListQryBO.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
        uccSkuManagementListQryBO.setCommodityId(cnncEsCommodityBo.getCommodity_id());
        uccSkuManagementListQryBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
        uccSkuManagementListQryBO.setSkuId(cnncEsCommodityBo.getSku_id());
        uccSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
        uccSkuManagementListQryBO.setSkuName(cnncEsCommodityBo.getSku_name());
        uccSkuManagementListQryBO.setSkuSource(cnncEsCommodityBo.getSku_source());
        uccSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
        uccSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
        uccSkuManagementListQryBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
        uccSkuManagementListQryBO.setCatalogId(cnncEsCommodityBo.getL4mg_category_id());
        uccSkuManagementListQryBO.setCatalogCode(cnncEsCommodityBo.getL4mg_category_code());
        uccSkuManagementListQryBO.setCatalogName(cnncEsCommodityBo.getL4mg_category_name());
        uccSkuManagementListQryBO.setProcessingSteps(cnncEsCommodityBo.getProcessing_steps());
        uccSkuManagementListQryBO.setSkuType(cnncEsCommodityBo.getSku_type());
        uccSkuManagementListQryBO.setPricePassFlag(cnncEsCommodityBo.getPrice_pass_flag());
        uccSkuManagementListQryBO.setApplyId(cnncEsCommodityBo.getApply_id());
        uccSkuManagementListQryBO.setApplyNo(cnncEsCommodityBo.getApply_no());
        uccSkuManagementListQryBO.setStdSkuId(cnncEsCommodityBo.getStd_sku_id());
        uccSkuManagementListQryBO.setStdSkuCode(cnncEsCommodityBo.getStd_sku_code());
        uccSkuManagementListQryBO.setMaterialId(cnncEsCommodityBo.getMaterial_id());
        uccSkuManagementListQryBO.setLongDesc(cnncEsCommodityBo.getLong_desc());
        uccSkuManagementListQryBO.setChannelIds(cnncEsCommodityBo.getChannel_id());
        uccSkuManagementListQryBO.setChannelNames(cnncEsCommodityBo.getChannel_Name());
        uccSkuManagementListQryBO.setAgreementDetailsId(cnncEsCommodityBo.getAgreement_details_id());
        uccSkuManagementListQryBO.setAgreementId(cnncEsCommodityBo.getAgreement_id());
        uccSkuManagementListQryBO.setLabels(cnncEsCommodityBo.getLabels());
        if (ObjectUtil.isNotEmpty((Object)cnncEsCommodityBo.getBind_status())) {
            uccSkuManagementListQryBO.setBindStatus(cnncEsCommodityBo.getBind_status());
        }
        uccSkuManagementListQryBO.setProcessingStepsDesc(ProcessingStepsEnum.getTypeDesc((Integer)cnncEsCommodityBo.getProcessing_steps()));
        uccSkuManagementListQryBO.setPricePassFlagDesc(PricessingStepsEnum.getTypeDesc((Integer)cnncEsCommodityBo.getPrice_pass_flag()));
        uccSkuManagementListQryBO.setOoocCleanDesc(YesNoEnum.getTypeDesc((Integer)cnncEsCommodityBo.getOooc_clean()));
        SkuStatusEnum statusDesc = SkuStatusEnum.getStatusDesc((Integer)cnncEsCommodityBo.getSku_status());
        if (statusDesc != null) {
            uccSkuManagementListQryBO.setSkuStatusDesc(statusDesc.getStatusDesc());
        }
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getRel_status())) {
            uccSkuManagementListQryBO.setMatStatus(cnncEsCommodityBo.getRel_status());
            uccSkuManagementListQryBO.setMatStatusDesc(AssignCodeEnum.getTypeDesc((Integer)cnncEsCommodityBo.getRel_status()));
        }
        uccSkuManagementListQryBO.setCommodityStatusDesc(commodityStatusMap.get(cnncEsCommodityBo.getCommodity_status().toString()));
        uccSkuManagementListQryBO.setSkuStatusDesc(skuStatusMap.get(Convert.toStr((Object)cnncEsCommodityBo.getSku_status())));
        if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.EC_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
            uccSkuManagementListQryBO.setSkuStatusDesc("\u5df2\u4e0b\u67b6");
            uccSkuManagementListQryBO.setDownTypeDesc(skuStatusMap.get(Convert.toStr((Object)cnncEsCommodityBo.getSku_status())));
            try {
                eacRuTaskPO = new UccSkuExpandPo();
                ((UccSkuExpandPo)eacRuTaskPO).setSkuId(uccSkuManagementListQryBO.getSkuId());
                List<UccSkuExpandPo> uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand((UccSkuExpandPo)eacRuTaskPO);
                if (!CollectionUtils.isEmpty(uccSkuExpandPos)) {
                    uccSkuManagementListQryBO.setDownReason(uccSkuExpandPos.get(0).getExpand16());
                }
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u4e0b\u67b6\u539f\u56e0\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
        }
        uccSkuManagementListQryBO.setApprovalStatusDesc(approveStateMap.get(Convert.toStr((Object)cnncEsCommodityBo.getSku_approval_status())));
        uccSkuManagementListQryBO.setSkuSourceDesc(skuSourceMap.get(Convert.toStr((Object)cnncEsCommodityBo.getSku_source())));
        uccSkuManagementListQryBO.setApprovalStatus(cnncEsCommodityBo.getSku_approval_status());
        uccSkuManagementListQryBO.setBrandId(cnncEsCommodityBo.getBrand_id());
        uccSkuManagementListQryBO.setBrandName(cnncEsCommodityBo.getBrand_name());
        uccSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
        uccSkuManagementListQryBO.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
        uccSkuManagementListQryBO.setMaterialName(cnncEsCommodityBo.getMaterial_name());
        uccSkuManagementListQryBO.setCommodityStatus(cnncEsCommodityBo.getCommodity_status());
        uccSkuManagementListQryBO.setSkuStatus(cnncEsCommodityBo.getSku_status());
        uccSkuManagementListQryBO.setMeasureId(cnncEsCommodityBo.getMeasure_id());
        uccSkuManagementListQryBO.setMeasureName(cnncEsCommodityBo.getMeasure_name());
        uccSkuManagementListQryBO.setSettlementUnit(cnncEsCommodityBo.getSettlement_unit());
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getDiscounts())) {
            uccSkuManagementListQryBO.setDiscount(new BigDecimal(cnncEsCommodityBo.getDiscounts()));
        }
        if (cnncEsCommodityBo.getDown_time() != null) {
            uccSkuManagementListQryBO.setDownTime(new Date(cnncEsCommodityBo.getDown_time()));
        }
        if (cnncEsCommodityBo.getUp_time() != null) {
            uccSkuManagementListQryBO.setUpTime(new Date(cnncEsCommodityBo.getUp_time()));
        }
        if (cnncEsCommodityBo.getOn_shelve_time() != 0L) {
            uccSkuManagementListQryBO.setOnShelveTime(new Date(cnncEsCommodityBo.getOn_shelve_time()));
        }
        uccSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
        uccSkuManagementListQryBO.setL4mgCategoryName(cnncEsCommodityBo.getL4mg_category_name());
        uccSkuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getSale_price()));
        uccSkuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getAgreement_price()));
        uccSkuManagementListQryBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
        uccSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
        uccSkuManagementListQryBO.setSell(cnncEsCommodityBo.getSell());
        uccSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
        uccSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getPicture_url())) {
            uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getPicture_url());
        } else {
            uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getCommd_pic_url());
        }
        uccSkuManagementListQryBO.setRate(cnncEsCommodityBo.getTaxRate());
        uccSkuManagementListQryBO.setPreDeliverDay(cnncEsCommodityBo.getPre_deliver_day());
        uccSkuManagementListQryBO.setMoq(cnncEsCommodityBo.getMoq());
        uccSkuManagementListQryBO.setSalesUnitId(cnncEsCommodityBo.getSales_unit_id());
        uccSkuManagementListQryBO.setSalesUnitName(cnncEsCommodityBo.getSales_unit_name());
        uccSkuManagementListQryBO.setSwitchOn(cnncEsCommodityBo.getSwitch_on());
        uccSkuManagementListQryBO.setOtherSourceCode(cnncEsCommodityBo.getOther_source_code());
        uccSkuManagementListQryBO.setOtherSourceName(cnncEsCommodityBo.getOther_source_name());
        uccSkuManagementListQryBO.setCommodityExpand1(cnncEsCommodityBo.getCommodity_expand1());
        uccSkuManagementListQryBO.setVendorName(cnncEsCommodityBo.getVendor_name());
        if (cnncEsCommodityBo.getComment_number() != null) {
            uccSkuManagementListQryBO.setTotalNum(cnncEsCommodityBo.getComment_number());
        } else {
            uccSkuManagementListQryBO.setTotalNum(BigDecimal.ZERO);
        }
        if (cnncEsCommodityBo.getSupplier_id() != null) {
            uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
        }
        if (cnncEsCommodityBo.getSupplier_name() != null) {
            uccSkuManagementListQryBO.setSupplierName(cnncEsCommodityBo.getSupplier_name());
        }
        if (cnncEsCommodityBo.getExt_spu_id() != null) {
            uccSkuManagementListQryBO.setExtSpuId(cnncEsCommodityBo.getExt_spu_id());
        }
        if (cnncEsCommodityBo.getExt_sku_id() != null) {
            uccSkuManagementListQryBO.setExtSkuId(cnncEsCommodityBo.getExt_sku_id());
        }
        if (cnncEsCommodityBo.getCreate_time() != null) {
            uccSkuManagementListQryBO.setCreateTime(new Date(cnncEsCommodityBo.getCreate_time()));
        }
        if (uccSkuManagementListQryBO.getApprovalStatus() != null && uccSkuManagementListQryBO.getApprovalStatus() != 0) {
            eacRuTaskPO = new EacRuTaskPO();
            ((EacRuTaskPO)eacRuTaskPO).setBusinessId(uccSkuManagementListQryBO.getSkuId().toString());
            ((EacRuTaskPO)eacRuTaskPO).setStatus("ACTIVE");
            ((EacRuTaskPO)eacRuTaskPO).setTacheCode(cnncEsCommodityBo.getTache_code());
            ((EacRuTaskPO)eacRuTaskPO).setOrderBy("CREATE_TIME");
            ((EacRuTaskPO)eacRuTaskPO).setUserId(Convert.toStr((Object)reqBO.getUserId()));
            List<EacRuTaskPO> list = this.eacRuTaskMapper.getList((EacRuTaskPO)eacRuTaskPO);
            if (!CollectionUtils.isEmpty(list)) {
                uccSkuManagementListQryBO.setTaskId(list.get(0).getTaskId());
                uccSkuManagementListQryBO.setIsJoinTransfer(list.get(0).getIsJoinTransfer());
            }
        }
        if (cnncEsCommodityBo.getAudit_time() != null) {
            uccSkuManagementListQryBO.setAuditTime(new Date(cnncEsCommodityBo.getAudit_time()));
        }
        return uccSkuManagementListQryBO;
    }
}

