/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.po.UccSkuStockPo;
import com.tydic.commodity.zone.ability.api.UccDDSyncStockBusiService;
import com.tydic.commodity.zone.ability.bo.UccDDSyncStockAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccDDSyncStockAbilityRspBO;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/3.3.0/com.tydic.commodity.zone.ability.api.UccDDSyncStockBusiService"})
public class UccDDSyncStockBusiServiceImpl
implements UccDDSyncStockBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccDDSyncStockBusiServiceImpl.class);
    @Autowired
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"syncStock"})
    public UccDDSyncStockAbilityRspBO syncStock(@RequestBody UccDDSyncStockAbilityReqBO reqBO) {
        UccDDSyncStockAbilityRspBO rspBO = new UccDDSyncStockAbilityRspBO();
        List skuPoList = this.uccSkuMapper.batchQrySku(reqBO.getSkuIds(), reqBO.getSupplierShopId());
        if (CollectionUtils.isEmpty((Collection)skuPoList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5355\u54c1\u6570\u636e");
            return rspBO;
        }
        skuPoList.forEach(bo -> {
            UccSkuStockPo po = new UccSkuStockPo();
            po.setSkuId(bo.getSkuId());
            po.setSupplierShopId(bo.getSupplierShopId());
            UccSkuStockPo uccSkuStockPo = this.uccSkuStockMapper.querySkuStock(po);
            if (uccSkuStockPo == null) {
                this.add(bo.getSkuId(), bo.getCommodityId(), reqBO.getStockNum());
            } else {
                this.update(bo.getSkuId(), bo.getCommodityId(), uccSkuStockPo.getStockNum().longValue());
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void update(Long skuId, Long commdityId, Long stockNum) {
        try {
            SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
            smcsdkOperateStockNumReqBO.setOperateType("10");
            smcsdkOperateStockNumReqBO.setOperateNo("admin");
            ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
            SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
            smcsdkStockNumInfoBO.setOperateNum(stockNum);
            smcsdkStockNumInfoBO.setSkuId(String.valueOf(skuId));
            smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
            smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
            smcsdkOperateStockNumReqBO.setObjectId(String.valueOf(commdityId));
            smcsdkOperateStockNumReqBO.setObjectType("20");
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
            SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
            if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
            }
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new ZTBusinessException("\u521b\u5efa\u5546\u54c1\u5e93\u5b58\u4fe1\u606f\u5931\u8d25!" + e.getMessage());
        }
    }

    private void add(Long skuId, Long commdityId, Long stockNum) {
        try {
            SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
            smcsdkOperateStockNumReqBO.setOperateType("10");
            smcsdkOperateStockNumReqBO.setOperateNo("1");
            ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
            SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
            if (stockNum != null) {
                smcsdkStockNumInfoBO.setOperateNum(stockNum);
            } else {
                smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(0L));
            }
            smcsdkStockNumInfoBO.setSkuId(String.valueOf(skuId));
            smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
            smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
            smcsdkOperateStockNumReqBO.setObjectId(String.valueOf(commdityId));
            smcsdkOperateStockNumReqBO.setObjectType("10");
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
            SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
            if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                throw new ZTBusinessException("8888" + smcsdkOperateStockNumRspBO.getRespDesc());
            }
            log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
        }
        catch (Exception e) {
            throw new ZTBusinessException("8888" + e.getMessage());
        }
    }
}

