/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.zone.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.bo.SkuChangePriceBO;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ComBatchDealObjPO;
import com.tydic.commodity.po.ComBatchDealOrderPO;
import com.tydic.commodity.zone.ability.bo.AgrMessageBo;
import com.tydic.commodity.zone.ability.bo.AgrMessageContentBo;
import com.tydic.commodity.zone.ability.bo.AgrMessageRspBo;
import com.tydic.commodity.zone.atom.api.UccChangeStatusAtomService;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.osworkflow.ability.OsworkflowRuntimeProcInstHandleAbilityService;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleReqBO;
import com.tydic.osworkflow.ability.bo.DeleteProcInstSingleRespBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccChangeStatusAtomServiceImpl
implements UccChangeStatusAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccChangeStatusAtomServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Autowired
    private OsworkflowRuntimeProcInstHandleAbilityService osworkflowRuntimeProcInstHandleAbilityService;

    @Override
    public AgrMessageRspBo changeCommod(AgrMessageBo reqBO) {
        AgrMessageRspBo agrMessageRspBo = new AgrMessageRspBo();
        agrMessageRspBo.setRespCode("0000");
        agrMessageRspBo.setRespDesc("\u6210\u529f");
        try {
            Integer count;
            if ((UccConstants.AgrStatusChangeType.FREZE.equals(reqBO.getChangeType()) || UccConstants.AgrStatusChangeType.INVALID.equals(reqBO.getChangeType())) && (count = this.uccSkuMapper.checkCountByAgreementIds(reqBO.getAgreementIds())) > 0) {
                List<ComBatchDealObjPO> comBatchDealObjPOList = this.getOrderIds(reqBO);
                this.freeze(reqBO);
                this.stopProcInst(reqBO, comBatchDealObjPOList, agrMessageRspBo);
            }
            if (UccConstants.AgrStatusChangeType.THAW.equals(reqBO.getChangeType()) || UccConstants.AgrStatusChangeType.PRICE.equals(reqBO.getChangeType())) {
                this.thaw(reqBO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u66f4\u65b0\u5f02\u5e38\uff01" + e.getMessage());
        }
        return agrMessageRspBo;
    }

    private void thaw(AgrMessageBo reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgreementIds())) {
            this.uccSkuMapper.revertSkuByAgreementIds(reqBO.getAgreementIds());
            this.uccSkuMapper.revertCommodityStatusByAgreementIds(reqBO.getAgreementIds());
        } else if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuChangePriceBOs())) {
            List agrIds = reqBO.getSkuChangePriceBOs().stream().map(SkuChangePriceBO::getAgreementId).collect(Collectors.toList());
            this.uccSkuMapper.revertSkuByAgreementIds(agrIds);
            this.uccSkuMapper.revertCommodityStatusByAgreementIds(agrIds);
        }
    }

    private void stopProcInst(AgrMessageBo reqBO, List<ComBatchDealObjPO> comBatchDealObjPOList, AgrMessageRspBo agrMessageRspBo) {
        if (!CollectionUtils.isEmpty(comBatchDealObjPOList)) {
            List batchNoList;
            List orderIds = comBatchDealObjPOList.stream().map(ComBatchDealObjPO::getOrderId).distinct().collect(Collectors.toList());
            this.eacRuTaskMapper.revokeAuditTask(orderIds);
            ComBatchDealOrderPO comBatchDealOrderPO = new ComBatchDealOrderPO();
            comBatchDealOrderPO.setOrderIds(orderIds);
            List comBatchDealOrderPOList = this.comBatchDealOrderMapper.getList(comBatchDealOrderPO);
            if (!CollectionUtils.isEmpty((Collection)comBatchDealOrderPOList) && !CollectionUtils.isEmpty(batchNoList = comBatchDealOrderPOList.stream().map(ComBatchDealOrderPO::getBatchNo).distinct().collect(Collectors.toList()))) {
                this.comBatchDealRrecordMapper.deleteByBatchNos(batchNoList);
            }
            List approveInstIds = comBatchDealObjPOList.stream().map(ComBatchDealObjPO::getApproveInstId).distinct().collect(Collectors.toList());
            for (String approveInstId : approveInstIds) {
                DeleteProcInstSingleReqBO deleteProcInstSingleReqBO = new DeleteProcInstSingleReqBO();
                deleteProcInstSingleReqBO.setProcInstId(approveInstId);
                log.debug("\u534f\u8bae\u5f71\u54cd\u5546\u54c1\u7ec8\u6b62\u5ba1\u6279\u6d41\u7a0b\u5b9e\u4f8b\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)deleteProcInstSingleReqBO));
                DeleteProcInstSingleRespBO deleteProcInstSingleRespBO = this.osworkflowRuntimeProcInstHandleAbilityService.deleteProcInstSingle(deleteProcInstSingleReqBO);
                log.debug("\u534f\u8bae\u5f71\u54cd\u5546\u54c1\u7ec8\u6b62\u5ba1\u6279\u6d41\u7a0b\u5b9e\u4f8b\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)deleteProcInstSingleRespBO));
            }
            agrMessageRspBo.setAgrMessageContentBoList(JUtil.jsl((List)comBatchDealObjPOList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(ComBatchDealObjPO::getOrderId, Function.identity(), (existing, replacement) -> existing), map -> new ArrayList(map.values()))), AgrMessageContentBo.class));
        }
    }

    @NotNull
    private List<ComBatchDealObjPO> getOrderIds(AgrMessageBo reqBO) {
        List commodityObjPos;
        ArrayList<ComBatchDealObjPO> comBatchDealObjPOList = new ArrayList<ComBatchDealObjPO>();
        List skuObjPos = this.uccSkuMapper.qryAgrSkuAuditOrderList(reqBO.getAgreementIds());
        if (!CollectionUtils.isEmpty((Collection)skuObjPos)) {
            comBatchDealObjPOList.addAll(skuObjPos);
        }
        if (!CollectionUtils.isEmpty((Collection)(commodityObjPos = this.uccSkuMapper.qryAgrCommodityAuditOrderList(reqBO.getAgreementIds())))) {
            comBatchDealObjPOList.addAll(commodityObjPos);
        }
        return comBatchDealObjPOList;
    }

    private void freeze(AgrMessageBo reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgreementIds())) {
            Integer status = null;
            status = UccConstants.AgrStatusChangeType.FREZE.equals(reqBO.getChangeType()) ? SkuStatusConstants.SKU_STATUS_FREEZE : SkuStatusConstants.SKU_STATUS_INVALID;
            this.uccSkuMapper.freezeSkuByAgreementIdsNotAudit(reqBO.getAgreementIds(), status);
            this.uccSkuMapper.freezeCommodityByAgreementIdsNotAudit(reqBO.getAgreementIds(), status);
        }
    }
}

